/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.proxy.jdk;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.wicket.Application;
import org.apache.wicket.proxy.ILazyInitProxy;
import org.apache.wicket.proxy.IProxyFactory;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;

public class JdkProxyFactory
implements IProxyFactory {
    @Override
    public <T> T createProxy(Class<T> type, IProxyTargetLocator locator) {
        JdkHandler handler = new JdkHandler(type, locator);
        try {
            return (T)Proxy.newProxyInstance(this.resolveClassLoader(), new Class[]{type, Serializable.class, ILazyInitProxy.class, LazyInitProxyFactory.IWriteReplace.class}, (InvocationHandler)handler);
        }
        catch (IllegalArgumentException e) {
            return (T)Proxy.newProxyInstance(LazyInitProxyFactory.class.getClassLoader(), new Class[]{type, Serializable.class, ILazyInitProxy.class, LazyInitProxyFactory.IWriteReplace.class}, (InvocationHandler)handler);
        }
    }

    private ClassLoader resolveClassLoader() {
        ClassLoader classLoader = null;
        if (Application.exists()) {
            classLoader = Application.get().getApplicationSettings().getClassResolver().getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    private static class JdkHandler
    implements InvocationHandler,
    ILazyInitProxy,
    Serializable,
    LazyInitProxyFactory.IWriteReplace {
        private static final long serialVersionUID = 1L;
        private final IProxyTargetLocator locator;
        private final String typeName;
        private transient Object target;

        public JdkHandler(Class<?> type, IProxyTargetLocator locator) {
            this.locator = locator;
            this.typeName = type.getName();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (LazyInitProxyFactory.isFinalizeMethod(method)) {
                return null;
            }
            if (LazyInitProxyFactory.isEqualsMethod(method)) {
                return this.equals(args[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (LazyInitProxyFactory.isHashCodeMethod(method)) {
                return this.hashCode();
            }
            if (LazyInitProxyFactory.isToStringMethod(method)) {
                return this.toString();
            }
            if (method.getDeclaringClass().equals(ILazyInitProxy.class)) {
                return this.getObjectLocator();
            }
            if (LazyInitProxyFactory.isWriteReplaceMethod(method)) {
                return this.writeReplace();
            }
            if (this.target == null) {
                this.target = this.locator.locateProxyTarget();
            }
            try {
                method.setAccessible(true);
                return method.invoke(this.target, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        @Override
        public IProxyTargetLocator getObjectLocator() {
            return this.locator;
        }

        @Override
        public Object writeReplace() throws ObjectStreamException {
            return new LazyInitProxyFactory.ProxyReplacement(this.typeName, this.locator);
        }
    }
}

