/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload.resource;

import com.github.openjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileCountLimitExceededException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.wicket.Application;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.resource.IUploadsFileManager;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.StringValueConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileUploadResource
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileUploadResource.class);
    public static final String PARAM_NAME = "WICKET-FILE-UPLOAD";
    public static final String UPLOAD_ID = "uploadId";
    public static final String NO_FILE_SELECTED = "wicket.no.files.selected";
    private final IUploadsFileManager fileManager;

    public AbstractFileUploadResource(IUploadsFileManager fileManager) {
        this.fileManager = fileManager;
    }

    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
        ServletWebRequest webRequest = (ServletWebRequest)attributes.getRequest();
        String uploadId = webRequest.getRequestParameters().getParameterValue(UPLOAD_ID).toString("resource");
        Bytes maxSize = this.getMaxSize(webRequest);
        Bytes fileMaxSize = this.getFileMaxSize(webRequest);
        long fileCountMax = this.getFileCountMax(webRequest);
        try {
            MultipartServletWebRequest multiPartRequest = webRequest.newMultipartWebRequest(maxSize, uploadId);
            multiPartRequest.setFileMaxSize(fileMaxSize);
            multiPartRequest.setFileCountMax(fileCountMax);
            multiPartRequest.parseFileParts();
            RequestCycle.get().setRequest(multiPartRequest);
            Map<String, List<FileItem>> files = multiPartRequest.getFiles();
            List<FileItem> fileItems = files.get(PARAM_NAME);
            if (fileItems != null) {
                ArrayList<FileUpload> fileUploads = new ArrayList<FileUpload>();
                for (FileItem fileItem : fileItems) {
                    fileUploads.add(new FileUpload(fileItem));
                }
                this.saveFiles(fileUploads, uploadId);
                this.prepareResponse(resourceResponse, webRequest, fileUploads);
            } else {
                resourceResponse.setContentType("application/json");
                resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

                    @Override
                    public void writeData(IResource.Attributes attributes) throws IOException {
                        JSONObject json = new JSONObject();
                        json.put("error", true);
                        json.put("errorMessage", AbstractFileUploadResource.NO_FILE_SELECTED);
                        String error = json.toString();
                        attributes.getResponse().write(error);
                    }
                });
            }
            return resourceResponse;
        }
        catch (FileUploadException fux) {
            resourceResponse.setContentType("application/json");
            resourceResponse.setStatusCode(200);
            JSONObject json = new JSONObject();
            json.put("error", true);
            String errorMessage = this.getFileUploadExceptionKey(fux);
            json.put("errorMessage", errorMessage);
            final String error = json.toString();
            resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

                @Override
                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write(error);
                }
            });
            return resourceResponse;
        }
        catch (Exception fux) {
            resourceResponse.setContentType("application/json");
            JSONObject json = new JSONObject();
            json.put("error", true);
            String errorMessage = LOG.isDebugEnabled() ? fux.getMessage() : "uploadFailed";
            json.put("errorMessage", errorMessage);
            final String error = json.toString();
            resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

                @Override
                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write(error);
                }
            });
            return resourceResponse;
        }
    }

    protected String getFileUploadExceptionKey(FileUploadException e) {
        if (e instanceof FileUploadBase.SizeLimitExceededException) {
            return "uploadTooLarge";
        }
        if (e instanceof FileUploadBase.FileSizeLimitExceededException) {
            return "uploadSingleFileTooLarge";
        }
        if (e instanceof FileCountLimitExceededException) {
            return "uploadTooManyFiles";
        }
        return "uploadFailed";
    }

    protected void prepareResponse(AbstractResource.ResourceResponse resourceResponse, ServletWebRequest webRequest, List<FileUpload> fileItems) {
        resourceResponse.setContentType("application/json");
        final String responseContent = this.generateJsonResponse(resourceResponse, webRequest, fileItems);
        resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

            @Override
            public void writeData(IResource.Attributes attributes) throws IOException {
                attributes.getResponse().write(responseContent);
            }
        });
    }

    protected void saveFiles(List<FileUpload> fileItems, String uploadId) {
        for (FileUpload fileItem : fileItems) {
            this.fileManager.save(fileItem, uploadId);
        }
    }

    private Bytes getMaxSize(ServletWebRequest webRequest) {
        try {
            return Bytes.bytes(webRequest.getRequestParameters().getParameterValue("maxSize").toLong());
        }
        catch (StringValueConversionException e) {
            return Application.get().getApplicationSettings().getDefaultMaximumUploadSize();
        }
    }

    private Bytes getFileMaxSize(ServletWebRequest webRequest) {
        long fileMaxSize = webRequest.getRequestParameters().getParameterValue("fileMaxSize").toLong(-1L);
        return fileMaxSize > 0L ? Bytes.bytes(fileMaxSize) : null;
    }

    private long getFileCountMax(ServletWebRequest webRequest) {
        return webRequest.getRequestParameters().getParameterValue("fileCountMax").toLong(-1L);
    }

    protected abstract String generateJsonResponse(AbstractResource.ResourceResponse var1, ServletWebRequest var2, List<FileUpload> var3);
}

