/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParseStart;
import com.github.javaparser.Problem;
import com.github.javaparser.Providers;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.printer.PrettyPrinter;
import com.github.javaparser.utils.CodeGenerationUtils;
import com.github.javaparser.utils.Log;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SourceRoot {
    private final Path root;
    private final Map<Path, ParseResult<CompilationUnit>> content = new HashMap<Path, ParseResult<CompilationUnit>>();
    private JavaParser javaParser = new JavaParser();

    public SourceRoot(Path root) {
        if (!Files.isDirectory(root, new LinkOption[0])) {
            throw new IllegalArgumentException("Only directories are allowed as root path!");
        }
        this.root = root.normalize();
        Log.info("New source root at \"%s\"", this.root);
    }

    public Map<Path, ParseResult<CompilationUnit>> tryToParse(String startPackage) throws IOException {
        Log.info("Parsing package \"%s\"", startPackage);
        Path path = CodeGenerationUtils.packageAbsolutePath(this.root, startPackage);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isDirectory() && file.toString().endsWith(".java")) {
                    Path relative = SourceRoot.this.root.relativize(file.getParent());
                    SourceRoot.this.tryToParse(relative.toString(), file.getFileName().toString());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return this.content;
    }

    public void parse(String startPackage, final JavaParser javaParser, final Callback callback) throws IOException {
        Log.info("Parsing package \"%s\"", startPackage);
        final Path path = CodeGenerationUtils.packageAbsolutePath(this.root, startPackage);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path absolutePath, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isDirectory() && absolutePath.toString().endsWith(".java")) {
                    Path localPath = SourceRoot.this.root.relativize(absolutePath);
                    Log.trace("Parsing %s", localPath);
                    ParseResult<CompilationUnit> result = javaParser.parse(ParseStart.COMPILATION_UNIT, Providers.provider(absolutePath));
                    if (callback.process(localPath, absolutePath, result) == Callback.Result.SAVE && result.getResult().isPresent()) {
                        SourceRoot.this.save(result.getResult().get(), path);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public Map<Path, ParseResult<CompilationUnit>> tryToParse() throws IOException {
        return this.tryToParse("");
    }

    public void saveAll() throws IOException {
        this.saveAll(this.root);
    }

    public void saveAll(Path root) throws IOException {
        Log.info("Saving all files (%s) to %s", this.content.size(), root);
        for (Map.Entry<Path, ParseResult<CompilationUnit>> cu : this.content.entrySet()) {
            Path path = root.resolve(cu.getKey());
            if (!cu.getValue().getResult().isPresent()) continue;
            Log.trace("Saving %s", path);
            this.save(cu.getValue().getResult().get(), path);
        }
    }

    private void save(CompilationUnit cu, Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        String code = new PrettyPrinter().print(cu);
        Files.write(path, code.getBytes(Providers.UTF8), new OpenOption[0]);
    }

    public Map<Path, ParseResult<CompilationUnit>> getContent() {
        return this.content;
    }

    public List<CompilationUnit> getCompilationUnits() {
        return this.content.values().stream().filter(ParseResult::isSuccessful).map(p -> (CompilationUnit)p.getResult().get()).collect(Collectors.toList());
    }

    public ParseResult<CompilationUnit> tryToParse(String packag, String filename) throws IOException {
        Path relativePath = CodeGenerationUtils.fileInPackageRelativePath(packag, filename);
        if (this.content.containsKey(relativePath)) {
            Log.trace("Retrieving cached %s", relativePath);
            return this.content.get(relativePath);
        }
        Path path = this.root.resolve(relativePath);
        Log.trace("Parsing %s", path);
        ParseResult<CompilationUnit> result = this.javaParser.parse(ParseStart.COMPILATION_UNIT, Providers.provider(path));
        this.content.put(relativePath, result);
        return result;
    }

    public CompilationUnit parse(String packag, String filename) {
        try {
            ParseResult<CompilationUnit> result = this.tryToParse(packag, filename);
            if (result.isSuccessful()) {
                return result.getResult().get();
            }
            throw new ParseProblemException(result.getProblems());
        }
        catch (IOException e) {
            throw new ParseProblemException(e);
        }
    }

    public void add(String pkg, String filename, CompilationUnit compilationUnit) {
        Log.trace("Adding new file %s.%s", pkg, filename);
        Path path = CodeGenerationUtils.fileInPackageRelativePath(pkg, filename);
        ParseResult<CompilationUnit> parseResult = new ParseResult<CompilationUnit>(compilationUnit, new ArrayList<Problem>(), null, null);
        this.content.put(path, parseResult);
    }

    public Path getRoot() {
        return this.root;
    }

    public JavaParser getJavaParser() {
        return this.javaParser;
    }

    public SourceRoot setJavaParser(JavaParser javaParser) {
        this.javaParser = javaParser;
        return this;
    }

    public static interface Callback {
        public Result process(Path var1, Path var2, ParseResult<CompilationUnit> var3) throws IOException;

        public static enum Result {
            SAVE,
            DONT_SAVE;

        }
    }
}

