/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.transform;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import wiremock.org.xmlunit.ConfigurationException;
import wiremock.org.xmlunit.XMLUnitException;

public final class Transformation {
    private Source source;
    private Source styleSheet;
    private TransformerFactory factory;
    private URIResolver uriResolver;
    private ErrorListener errorListener;
    private final Properties output = new Properties();
    private final Map<String, Object> params = new HashMap<String, Object>();

    public Transformation() {
    }

    public Transformation(Source s) {
        this.setSource(s);
    }

    public void setSource(Source s) {
        if (s == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.source = s;
    }

    public void setStylesheet(Source s) {
        this.styleSheet = s;
    }

    public void addOutputProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.output.setProperty(name, value);
    }

    public void clearOutputProperties() {
        this.output.clear();
    }

    public void addParameter(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.params.put(name, value);
    }

    public void clearParameters() {
        this.params.clear();
    }

    public void setFactory(TransformerFactory f) {
        this.factory = f;
    }

    public void setURIResolver(URIResolver r) {
        this.uriResolver = r;
    }

    public void setErrorListener(ErrorListener l) {
        this.errorListener = l;
    }

    public void transformTo(Result r) {
        if (this.source == null) {
            throw new IllegalStateException("source must not be null");
        }
        if (r == null) {
            throw new IllegalArgumentException("result must not be null");
        }
        try {
            TransformerFactory fac = this.factory;
            if (fac == null) {
                fac = TransformerFactory.newInstance();
            }
            Transformer t = this.styleSheet != null ? fac.newTransformer(this.styleSheet) : fac.newTransformer();
            if (this.uriResolver != null) {
                t.setURIResolver(this.uriResolver);
            }
            if (this.errorListener != null) {
                t.setErrorListener(this.errorListener);
            }
            t.setOutputProperties(this.output);
            for (Map.Entry<String, Object> ent : this.params.entrySet()) {
                t.setParameter(ent.getKey(), ent.getValue());
            }
            t.transform(this.source, r);
        }
        catch (TransformerConfigurationException e) {
            throw new ConfigurationException(e);
        }
        catch (TransformerException e) {
            throw new XMLUnitException(e);
        }
    }

    public String transformToString() {
        StringWriter sw = new StringWriter();
        this.transformTo(new StreamResult(sw));
        return sw.toString();
    }

    public Document transformToDocument() {
        DOMResult r = new DOMResult();
        this.transformTo(r);
        return (Document)r.getNode();
    }
}

