/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.ResolverException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.saml.metadata.resolver.RemoteMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractReloadingMetadataResolver;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;

public class HTTPMetadataResolver
extends AbstractReloadingMetadataResolver
implements RemoteMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPMetadataResolver.class);
    @NonnullAfterInit
    private HttpClient httpClient;
    @NonnullAfterInit
    private URI metadataURI;
    @Nullable
    private String cachedMetadataETag;
    @Nullable
    private String cachedMetadataLastModified;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    public HTTPMetadataResolver(@Nonnull HttpClient client, String metadataURL) throws ResolverException {
        this(null, client, metadataURL);
    }

    public HTTPMetadataResolver(Timer backgroundTaskTimer, @Nonnull HttpClient client, String metadataURL) throws ResolverException {
        super(backgroundTaskTimer);
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
        try {
            this.metadataURI = new URI(metadataURL);
        }
        catch (URISyntaxException e) {
            throw new ResolverException("Illegal URL syntax", (Exception)e);
        }
    }

    @Nonnull
    public String getMetadataURI() {
        return this.metadataURI.toASCIIString();
    }

    @Nullable
    protected HttpClientSecurityParameters getHttpClientSecurityParameters() {
        return this.httpClientSecurityParameters;
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    @Override
    protected void doDestroy() {
        this.httpClient = null;
        this.httpClientSecurityParameters = null;
        this.metadataURI = null;
        this.cachedMetadataETag = null;
        this.cachedMetadataLastModified = null;
        super.doDestroy();
    }

    @Override
    protected String getMetadataIdentifier() {
        return this.metadataURI.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected byte[] fetchMetadata() throws ResolverException {
        HttpGet httpGet = this.buildHttpGet();
        HttpClientContext context = this.buildHttpClientContext((ClassicHttpRequest)httpGet);
        this.log.debug("{} Attempting to fetch metadata document from '{}'", (Object)this.getLogPrefix(), (Object)this.metadataURI);
        try (ClassicHttpResponse response = this.httpClient.executeOpen(null, (ClassicHttpRequest)httpGet, (HttpContext)context);){
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)context, (String)this.metadataURI.getScheme());
            int httpStatusCode222 = response.getCode();
            if (httpStatusCode222 == 304) {
                this.log.debug("{} Metadata document from '{}' has not changed since last retrieval", (Object)this.getLogPrefix(), (Object)this.getMetadataURI());
                byte[] byArray2 = null;
                return byArray2;
            }
            if (httpStatusCode222 != 200) {
                String errMsg = "Non-ok status code " + httpStatusCode222 + " returned from remote metadata source " + String.valueOf(this.metadataURI);
                this.log.error("{} " + errMsg, (Object)this.getLogPrefix());
                throw new ResolverException(errMsg);
            }
            this.processConditionalRetrievalHeaders(response);
            byte[] rawMetadata = this.getMetadataBytesFromResponse(response);
            this.log.debug("{} Successfully fetched {} bytes of metadata from {}", new Object[]{this.getLogPrefix(), rawMetadata.length, this.getMetadataURI()});
            byte[] byArray = rawMetadata;
            return byArray;
        }
        catch (IOException e) {
            String errMsg = "Error retrieving metadata from " + String.valueOf(this.metadataURI);
            this.log.error("{} {}: {}", new Object[]{this.getLogPrefix(), errMsg, e.getMessage()});
            throw new ResolverException(errMsg, (Exception)e);
        }
    }

    @Nonnull
    protected HttpGet buildHttpGet() {
        HttpGet getMethod = new HttpGet(this.getMetadataURI());
        if (this.cachedMetadataETag != null) {
            getMethod.setHeader("If-None-Match", (Object)this.cachedMetadataETag);
        }
        if (this.cachedMetadataLastModified != null) {
            getMethod.setHeader("If-Modified-Since", (Object)this.cachedMetadataLastModified);
        }
        return getMethod;
    }

    @Nonnull
    protected HttpClientContext buildHttpClientContext(@Nonnull ClassicHttpRequest request) {
        HttpClientContext context = HttpClientSecuritySupport.buildHttpClientContext((HttpClientSecurityParameters)this.httpClientSecurityParameters);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)context, (HttpRequest)request);
        return context;
    }

    protected void processConditionalRetrievalHeaders(@Nonnull ClassicHttpResponse response) {
        Header httpHeader = response.getFirstHeader("ETag");
        if (httpHeader != null) {
            this.cachedMetadataETag = httpHeader.getValue();
        }
        if ((httpHeader = response.getFirstHeader("Last-Modified")) != null) {
            this.cachedMetadataLastModified = httpHeader.getValue();
        }
    }

    @Nonnull
    protected byte[] getMetadataBytesFromResponse(@Nonnull ClassicHttpResponse response) throws ResolverException {
        byte[] byArray;
        block8: {
            this.log.debug("{} Attempting to extract metadata from response to request for metadata from '{}'", (Object)this.getLogPrefix(), (Object)this.getMetadataURI());
            HttpEntity entity = response.getEntity();
            try {
                byArray = this.inputstreamToByteArray(entity.getContent());
                if (entity == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entity != null) {
                        try {
                            entity.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.log.error("{} Unable to read response: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                    throw new ResolverException("Unable to read response", (Exception)e);
                }
            }
            entity.close();
        }
        return byArray;
    }
}

