/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import jakarta.ejb.ConcurrentAccessTimeoutException;
import jakarta.ejb.EJBContext;
import jakarta.ejb.SessionBean;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.SystemException;
import org.apache.openejb.cdi.CdiEjbBean;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.InstanceContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.mdb.EndpointFactory;
import org.apache.openejb.core.mdb.InboundRecovery;
import org.apache.openejb.core.mdb.Instance;
import org.apache.openejb.core.mdb.MdbContext;
import org.apache.openejb.core.mdb.MdbPoolContainer;
import org.apache.openejb.core.timer.TimerServiceWrapper;
import org.apache.openejb.loader.Options;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ManagedMBean;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.monitoring.StatsInterceptor;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PassthroughFactory;
import org.apache.openejb.util.Pool;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class MdbInstanceManager {
    protected static final Logger logger;
    protected static final Method removeSessionBeanMethod;
    private final Duration accessTimeout;
    private final Duration closeTimeout;
    private final Pool.Builder poolBuilder;
    private final ThreadPoolExecutor executor;
    private final ScheduledExecutorService scheduledExecutor;
    private final Map<BeanContext, MdbPoolContainer.MdbActivationContext> activationContexts = new ConcurrentHashMap<BeanContext, MdbPoolContainer.MdbActivationContext>();
    private final Map<BeanContext, ObjectName> mbeanNames = new ConcurrentHashMap<BeanContext, ObjectName>();
    protected final List<ObjectName> jmxNames = new ArrayList<ObjectName>();
    private final ResourceAdapter resourceAdapter;
    private final InboundRecovery inboundRecovery;
    private final Object containerID;
    private final SecurityService securityService;

    public MdbInstanceManager(SecurityService securityService, ResourceAdapter resourceAdapter, InboundRecovery inboundRecovery, Object containerID, Duration accessTimeout, Duration closeTimeout, Pool.Builder poolBuilder, int callbackThreads, ScheduledExecutorService ses) {
        this.accessTimeout = accessTimeout;
        this.closeTimeout = closeTimeout;
        this.poolBuilder = poolBuilder;
        this.scheduledExecutor = ses;
        if (ScheduledThreadPoolExecutor.class.isInstance(ses) && !((ScheduledThreadPoolExecutor)ScheduledThreadPoolExecutor.class.cast(ses)).getRemoveOnCancelPolicy()) {
            ((ScheduledThreadPoolExecutor)ScheduledThreadPoolExecutor.class.cast(ses)).setRemoveOnCancelPolicy(true);
        }
        if (accessTimeout.getUnit() == null) {
            accessTimeout.setUnit(TimeUnit.MILLISECONDS);
        }
        int qsize = callbackThreads > 1 ? callbackThreads - 1 : 1;
        DaemonThreadFactory threadFactory = new DaemonThreadFactory("InstanceManagerPool.worker.");
        this.executor = new ThreadPoolExecutor(callbackThreads, callbackThreads * 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(qsize), threadFactory);
        this.executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor tpe) {
                if (null == r || null == tpe || tpe.isShutdown() || tpe.isTerminated() || tpe.isTerminating()) {
                    return;
                }
                try {
                    if (!tpe.getQueue().offer(r, 20L, TimeUnit.SECONDS)) {
                        logger.warning("Executor failed to run asynchronous process: " + String.valueOf(r));
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.securityService = securityService;
        this.resourceAdapter = resourceAdapter;
        this.inboundRecovery = inboundRecovery;
        this.containerID = containerID;
    }

    public void deploy(BeanContext beanContext, ActivationSpec activationSpec, EndpointFactory endpointFactory) throws OpenEJBException {
        if (this.inboundRecovery != null) {
            this.inboundRecovery.recover(this.resourceAdapter, activationSpec, this.containerID.toString());
        }
        ObjectRecipe recipe = PassthroughFactory.recipe(new Pool.Builder(this.poolBuilder));
        recipe.allow(Option.CASE_INSENSITIVE_FACTORY);
        recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        recipe.setAllProperties((Map)beanContext.getProperties());
        Pool.Builder builder = (Pool.Builder)recipe.create();
        this.setDefault(builder.getMaxAge(), TimeUnit.HOURS);
        this.setDefault(builder.getIdleTimeout(), TimeUnit.MINUTES);
        this.setDefault(builder.getInterval(), TimeUnit.MINUTES);
        InstanceSupplier supplier = new InstanceSupplier(beanContext);
        builder.setSupplier(supplier);
        builder.setExecutor(this.executor);
        builder.setScheduledExecutor(this.scheduledExecutor);
        int min = builder.getMin();
        long maxAge = builder.getMaxAge().getTime(TimeUnit.MILLISECONDS);
        double maxAgeOffset = builder.getMaxAgeOffset();
        Data data = new Data(builder.build(), this.accessTimeout, this.closeTimeout);
        MdbContext mdbContext = new MdbContext(this.securityService, data::flush);
        try {
            Context context = beanContext.getJndiEnc();
            context.bind("comp/EJBContext", (Object)mdbContext);
            context.bind("comp/TimerService", (Object)new TimerServiceWrapper());
        }
        catch (NamingException e) {
            throw new OpenEJBException("Failed to bind EJBContext/TimerService", e);
        }
        beanContext.set(EJBContext.class, mdbContext);
        data.setBaseContext(mdbContext);
        beanContext.setContainerData(data);
        MBeanServer server = LocalMBeanServer.get();
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
        jmxName.set("J2EEServer", "openejb");
        jmxName.set("J2EEApplication", null);
        jmxName.set("EJBModule", beanContext.getModuleID());
        jmxName.set("MessageDrivenBean", beanContext.getEjbName());
        jmxName.set("j2eeType", "");
        jmxName.set("name", beanContext.getEjbName());
        if (StatsInterceptor.isStatsActivated()) {
            StatsInterceptor stats = new StatsInterceptor(beanContext.getBeanClass());
            beanContext.addFirstSystemInterceptor(stats);
            try {
                ObjectName objectName = jmxName.set("j2eeType", "Invocations").build();
                if (server.isRegistered(objectName)) {
                    server.unregisterMBean(objectName);
                }
                server.registerMBean(new ManagedMBean(stats), objectName);
                this.jmxNames.add(objectName);
            }
            catch (Exception e) {
                logger.error("Unable to register MBean ", e);
            }
        }
        try {
            MdbPoolContainer.MdbActivationContext activationContext = new MdbPoolContainer.MdbActivationContext(Thread.currentThread().getContextClassLoader(), beanContext, this.resourceAdapter, endpointFactory, activationSpec);
            this.activationContexts.put(beanContext, activationContext);
            boolean activeOnStartup = true;
            String activeOnStartupSetting = beanContext.getActivationProperties().get("MdbActiveOnStartup");
            if (activeOnStartupSetting == null) {
                activeOnStartupSetting = beanContext.getActivationProperties().get("DeliveryActive");
            }
            if (activeOnStartupSetting != null) {
                activeOnStartup = Boolean.parseBoolean(activeOnStartupSetting);
            }
            if (activeOnStartup) {
                activationContext.start();
            } else {
                logger.info("Not auto-activating endpoint for " + String.valueOf(beanContext.getDeploymentID()));
            }
            String jmxControlName = beanContext.getActivationProperties().get("MdbJMXControl");
            if (jmxControlName == null) {
                jmxControlName = "true";
            }
            this.addJMxControl(beanContext, jmxControlName, activationContext);
        }
        catch (ResourceException e) {
            throw new OpenEJBException(e);
        }
        Options options = new Options(beanContext.getProperties());
        if (!options.get("BackgroundStartup", false) && min > 0) {
            ExecutorService es = Executors.newFixedThreadPool(min);
            for (int i = 0; i < min; ++i) {
                es.submit(new InstanceCreatorRunnable(maxAge, i, min, maxAgeOffset, data, supplier));
            }
            es.shutdown();
            try {
                es.awaitTermination(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                logger.error("can't fill the message driven bean pool", e);
            }
        }
        try {
            ObjectName objectName = jmxName.set("j2eeType", "Pool").build();
            if (server.isRegistered(objectName)) {
                server.unregisterMBean(objectName);
            }
            server.registerMBean(new ManagedMBean(data.pool), objectName);
            data.add(objectName);
        }
        catch (Exception e) {
            logger.error("Unable to register MBean ", e);
        }
        data.getPool().start();
    }

    public void undeploy(BeanContext beanContext) {
        MdbPoolContainer.MdbActivationContext actContext = this.activationContexts.get(beanContext);
        if (actContext == null) {
            return;
        }
        EndpointFactory endpointFactory = actContext.getEndpointFactory();
        if (endpointFactory != null) {
            MdbPoolContainer.MdbActivationContext activationContext;
            ObjectName jmxBeanToRemove = this.mbeanNames.remove(beanContext);
            if (jmxBeanToRemove != null) {
                LocalMBeanServer.unregisterSilently(jmxBeanToRemove);
                logger.info("Undeployed MDB control for " + String.valueOf(beanContext.getDeploymentID()));
            }
            if ((activationContext = this.activationContexts.remove(beanContext)) != null && activationContext.isStarted()) {
                this.resourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, endpointFactory.getActivationSpec());
            }
            MBeanServer server = LocalMBeanServer.get();
            for (ObjectName objectName : this.jmxNames) {
                try {
                    server.unregisterMBean(objectName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                }
                catch (Exception e) {
                    logger.error("Unable to unregister MBean " + String.valueOf(objectName), e);
                }
            }
        }
    }

    private void addJMxControl(BeanContext current, String name, MdbPoolContainer.MdbActivationContext activationContext) throws ResourceException {
        ObjectName jmxName;
        if (name == null || "false".equalsIgnoreCase(name)) {
            logger.debug("Not adding JMX control for " + String.valueOf(current.getDeploymentID()));
            return;
        }
        try {
            jmxName = "true".equalsIgnoreCase(name) ? new ObjectNameBuilder().set("J2EEServer", "openejb").set("J2EEApplication", null).set("EJBModule", current.getModuleID()).set("StatelessSessionBean", current.getEjbName()).set("j2eeType", "control").set("name", current.getEjbName()).build() : new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
        this.mbeanNames.put(current, jmxName);
        LocalMBeanServer.registerSilently(new MdbJmxControl(activationContext), jmxName);
        logger.info("Deployed MDB control for " + String.valueOf(current.getDeploymentID()) + " on " + String.valueOf(jmxName));
    }

    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                    java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.WARNING, this.getClass().getSimpleName() + " pool  timeout expired");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            try {
                if (!this.scheduledExecutor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                    java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.WARNING, this.getClass().getSimpleName() + " pool  timeout expired");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Instance getInstance(ThreadContext callContext) throws OpenEJBException {
        BeanContext beanContext = callContext.getBeanContext();
        Data data = (Data)beanContext.getContainerData();
        Instance instance = null;
        try {
            Pool.Entry entry = data.poolPop();
            if (entry != null) {
                instance = (Instance)entry.get();
                instance.setPoolEntry(entry);
            }
        }
        catch (TimeoutException e) {
            String msg = "No instances available in Message Driven Bean pool.  Waited " + data.getAccessTimeout().toString();
            ConcurrentAccessTimeoutException timeoutException = new ConcurrentAccessTimeoutException(msg);
            timeoutException.fillInStackTrace();
            throw new ApplicationException((Exception)timeoutException);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpenEJBException("Unexpected Interruption of current thread: ", e);
        }
        if (null == instance) {
            instance = this.createInstance(beanContext);
        }
        return instance;
    }

    private Instance createInstance(BeanContext beanContext) throws ApplicationException {
        try {
            InstanceContext context = beanContext.newInstance();
            return new Instance(context.getBean(), context.getInterceptors(), context.getCreationalContext());
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            String t = "The bean instance " + String.valueOf(beanContext.getDeploymentID()) + " threw a system exception:" + String.valueOf(e);
            logger.error(t, e);
            throw new ApplicationException(new RemoteException("Cannot obtain a free instance.", e));
        }
    }

    public void poolInstance(ThreadContext callContext, Object bean) throws OpenEJBException {
        if (bean == null) {
            throw new SystemException("Invalid arguments");
        }
        Instance instance = (Instance)Instance.class.cast(bean);
        BeanContext beanContext = callContext.getBeanContext();
        Data data = (Data)beanContext.getContainerData();
        Pool<Instance> pool = data.getPool();
        if (instance.getPoolEntry() != null) {
            pool.push(instance.getPoolEntry());
        } else {
            pool.push(instance);
        }
    }

    public void discardInstance(ThreadContext callContext, Object bean) throws SystemException {
        if (bean == null) {
            throw new SystemException("Invalid arguments");
        }
        Instance instance = (Instance)Instance.class.cast(bean);
        BeanContext beanContext = callContext.getBeanContext();
        Data data = (Data)beanContext.getContainerData();
        if (null != data) {
            Pool<Instance> pool = data.getPool();
            pool.discard(instance.getPoolEntry());
        }
    }

    private void freeInstance(ThreadContext callContext, Instance instance) {
        try {
            callContext.setCurrentOperation(Operation.PRE_DESTROY);
            BeanContext beanContext = callContext.getBeanContext();
            Method remove = instance.bean instanceof SessionBean ? removeSessionBeanMethod : null;
            List<InterceptorData> callbackInterceptors = beanContext.getCallbackInterceptors();
            InterceptorStack interceptorStack = new InterceptorStack(instance.bean, remove, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
            CdiEjbBean bean = beanContext.get(CdiEjbBean.class);
            if (bean != null) {
                bean.getInjectionTarget().preDestroy(instance.bean);
            }
            interceptorStack.invoke(new Object[0]);
            if (instance.creationalContext != null) {
                instance.creationalContext.release();
            }
        }
        catch (Throwable re) {
            logger.error("The bean instance " + String.valueOf(instance) + " threw a system exception:" + String.valueOf(re), re);
        }
    }

    private void setDefault(Duration duration, TimeUnit unit) {
        if (duration.getUnit() == null) {
            duration.setUnit(unit);
        }
    }

    static {
        Method foundRemoveMethod;
        logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
        try {
            foundRemoveMethod = SessionBean.class.getDeclaredMethod("ejbRemove", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            foundRemoveMethod = null;
        }
        removeSessionBeanMethod = foundRemoveMethod;
    }

    private final class InstanceSupplier
    implements Pool.Supplier<Instance> {
        private final BeanContext beanContext;

        public InstanceSupplier(BeanContext beanContext) {
            this.beanContext = beanContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discard(Instance instance, Pool.Event reason) {
            ThreadContext ctx = new ThreadContext(this.beanContext, null);
            ThreadContext oldCallContext = ThreadContext.enter(ctx);
            try {
                MdbInstanceManager.this.freeInstance(ctx, instance);
            }
            finally {
                ThreadContext.exit(oldCallContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Instance create() {
            ThreadContext ctx = new ThreadContext(this.beanContext, null);
            ThreadContext oldCallContext = ThreadContext.enter(ctx);
            try {
                Instance instance = MdbInstanceManager.this.createInstance(ctx.getBeanContext());
                return instance;
            }
            catch (OpenEJBException e) {
                logger.error("Unable to fill pool: for deployment '" + String.valueOf(this.beanContext.getDeploymentID()) + "'", e);
            }
            finally {
                ThreadContext.exit(oldCallContext);
            }
            return null;
        }
    }

    private class Data {
        private final Pool<Instance> pool;
        private final Duration accessTimeout;
        private final Duration closeTimeout;
        private final List<ObjectName> jmxNames = new ArrayList<ObjectName>();
        private BaseContext baseContext;

        public Data(Pool<Instance> pool, Duration accessTimeout, Duration closeTimeout) {
            this.pool = pool;
            this.accessTimeout = accessTimeout;
            this.closeTimeout = closeTimeout;
        }

        public Duration getAccessTimeout() {
            return this.accessTimeout;
        }

        public Pool.Entry poolPop() throws InterruptedException, TimeoutException {
            return this.pool.pop(this.accessTimeout.getTime(), this.accessTimeout.getUnit());
        }

        public Pool<Instance> getPool() {
            return this.pool;
        }

        public void flush() {
            this.pool.flush();
        }

        public boolean closePool() throws InterruptedException {
            return this.pool.close(this.closeTimeout.getTime(), this.closeTimeout.getUnit());
        }

        public ObjectName add(ObjectName name) {
            this.jmxNames.add(name);
            return name;
        }

        public List<ObjectName> getJmxNames() {
            return this.jmxNames;
        }

        public BaseContext getBaseContext() {
            return this.baseContext;
        }

        public void setBaseContext(BaseContext baseContext) {
            this.baseContext = baseContext;
        }
    }

    private final class InstanceCreatorRunnable
    implements Runnable {
        private final Data data;
        private final InstanceSupplier supplier;
        private final long offset;

        public InstanceCreatorRunnable(long maxAge, long iteration, long min, double maxAgeOffset, Data data, InstanceSupplier supplier) {
            this.data = data;
            this.supplier = supplier;
            this.offset = maxAge > 0L ? (long)((double)maxAge / maxAgeOffset * (double)min * (double)iteration) % maxAge : 0L;
        }

        @Override
        public void run() {
            Instance obj = this.supplier.create();
            if (obj != null) {
                this.data.getPool().add(obj, this.offset);
            }
        }
    }

    public static final class MdbJmxControl
    implements DynamicMBean {
        private static final AttributeList ATTRIBUTE_LIST = new AttributeList();
        private static final MBeanInfo INFO = new MBeanInfo("org.apache.openejb.resource.activemq.ActiveMQResourceAdapter.MdbJmxControl", "Allows to control a MDB (start/stop)", new MBeanAttributeInfo[]{new MBeanAttributeInfo("started", "boolean", "started: boolean indicating whether this MDB endpoint has been activated.", true, false, true)}, new MBeanConstructorInfo[0], new MBeanOperationInfo[]{new MBeanOperationInfo("start", "Ensure the listener is active.", new MBeanParameterInfo[0], "void", 1), new MBeanOperationInfo("stop", "Ensure the listener is not active.", new MBeanParameterInfo[0], "void", 1)}, new MBeanNotificationInfo[0]);
        private final MdbPoolContainer.MdbActivationContext activationContext;

        private MdbJmxControl(MdbPoolContainer.MdbActivationContext activationContext) {
            this.activationContext = activationContext;
        }

        @Override
        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            if (actionName.equals("stop")) {
                this.activationContext.stop();
            } else if (actionName.equals("start")) {
                try {
                    this.activationContext.start();
                }
                catch (ResourceException e) {
                    logger.error("Error invoking " + actionName + ": " + e.getMessage());
                    throw new MBeanException(new IllegalStateException(e.getMessage(), e));
                }
            } else {
                throw new MBeanException(new IllegalStateException("unsupported operation: " + actionName));
            }
            return null;
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            return INFO;
        }

        @Override
        public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if ("started".equals(attribute)) {
                return this.activationContext.isStarted();
            }
            throw new AttributeNotFoundException();
        }

        @Override
        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            throw new AttributeNotFoundException();
        }

        @Override
        public AttributeList getAttributes(String[] attributes) {
            return ATTRIBUTE_LIST;
        }

        @Override
        public AttributeList setAttributes(AttributeList attributes) {
            return ATTRIBUTE_LIST;
        }
    }
}

