/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.transaction.Transaction;
import jakarta.validation.ValidatorFactory;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.assembler.classic.ComparableValidationConfig;
import org.apache.openejb.assembler.classic.ImportSql;
import org.apache.openejb.assembler.classic.SingleValidatorFactoryWrapper;
import org.apache.openejb.assembler.classic.ValidatorFactoryWrapper;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.PersistenceUnitInfoImpl;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectableBeanManager;

public class EntityManagerFactoryCallable
implements Callable<EntityManagerFactory> {
    public static final String OPENEJB_JPA_INIT_ENTITYMANAGER = "openejb.jpa.init-entitymanager";
    public static final String OPENJPA_ENTITY_MANAGER_FACTORY_POOL = "openjpa.EntityManagerFactoryPool";
    private final String persistenceProviderClassName;
    private final PersistenceUnitInfoImpl unitInfo;
    private final Map<ComparableValidationConfig, ValidatorFactory> potentialValidators;
    private final boolean cdi;
    private ClassLoader appClassLoader;
    private Class<?> provider;

    public EntityManagerFactoryCallable(String persistenceProviderClassName, PersistenceUnitInfoImpl unitInfo, ClassLoader cl, Map<ComparableValidationConfig, ValidatorFactory> validators, boolean hasCdi) {
        this.persistenceProviderClassName = persistenceProviderClassName;
        this.unitInfo = unitInfo;
        this.appClassLoader = cl;
        this.potentialValidators = validators;
        this.cdi = hasCdi;
    }

    public Class<?> getProvider() {
        if (this.provider != null) {
            return this.provider;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.appClassLoader);
        try {
            this.provider = this.appClassLoader.loadClass(this.persistenceProviderClassName);
            Class<?> clazz = this.provider;
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityManagerFactory call() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.appClassLoader);
        try {
            ImportSql importer;
            EntityManagerFactory emf;
            Class<?> clazz = this.appClassLoader.loadClass(this.persistenceProviderClassName);
            PersistenceProvider persistenceProvider = (PersistenceProvider)clazz.newInstance();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (!ValidationMode.NONE.equals((Object)this.unitInfo.getValidationMode())) {
                properties.put("jakarta.persistence.validation.factory", this.potentialValidators != null && this.potentialValidators.size() == 1 ? this.ensureSerializable(this.potentialValidators.values().iterator().next()) : new ValidatorFactoryWrapper(this.potentialValidators));
            }
            if (this.cdi && "true".equalsIgnoreCase(this.unitInfo.getProperties().getProperty("tomee.jpa.cdi", "true")) && "true".equalsIgnoreCase(SystemInstance.get().getProperty("tomee.jpa.cdi", "true"))) {
                properties.put("jakarta.persistence.bean.manager", Proxy.newProxyInstance(this.appClassLoader, new Class[]{BeanManager.class}, (InvocationHandler)new BmHandler()));
            }
            this.customizeProperties(properties);
            Transaction transaction = this.unitInfo.isLazilyInitialized() ? OpenEJB.getTransactionManager().suspend() : null;
            try {
                emf = persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.unitInfo, properties);
            }
            finally {
                if (this.unitInfo.isLazilyInitialized() && transaction != null) {
                    OpenEJB.getTransactionManager().resume(transaction);
                }
            }
            if (this.unitInfo.getProperties() != null && "true".equalsIgnoreCase(this.unitInfo.getProperties().getProperty(OPENEJB_JPA_INIT_ENTITYMANAGER)) || SystemInstance.get().getOptions().get(OPENEJB_JPA_INIT_ENTITYMANAGER, false)) {
                emf.createEntityManager().close();
            }
            if (this.unitInfo.getNonJtaDataSource() != null && (importer = new ImportSql(this.appClassLoader, this.unitInfo.getPersistenceUnitName(), this.unitInfo.getNonJtaDataSource())).hasSomethingToImport()) {
                emf.createEntityManager().close();
                importer.doImport();
            }
            EntityManagerFactory entityManagerFactory = emf;
            return entityManagerFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void customizeProperties(Map<String, Object> properties) {
        String pool = SystemInstance.get().getProperty(OPENJPA_ENTITY_MANAGER_FACTORY_POOL);
        if (pool != null) {
            properties.put(OPENJPA_ENTITY_MANAGER_FACTORY_POOL, pool);
        }
    }

    public PersistenceUnitInfoImpl getUnitInfo() {
        return this.unitInfo;
    }

    public void overrideClassLoader(ClassLoader loader) {
        this.appClassLoader = loader;
    }

    private ValidatorFactory ensureSerializable(ValidatorFactory factory) {
        if (Serializable.class.isInstance(factory)) {
            return factory;
        }
        return new SingleValidatorFactoryWrapper(factory);
    }

    private static class BmHandler
    implements InvocationHandler,
    Serializable {
        private volatile transient BeanManager bm;

        private BmHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.findBm(), args);
            }
            catch (InvocationTargetException ite) {
                Logger.getInstance(LogCategory.OPENEJB_JPA, EntityManagerFactoryCallable.class).warning("Exception calling CDI, if a lifecycle issue you should maybe set tomee.jpa.factory.lazy=true", ite.getCause());
                throw ite.getCause();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object findBm() {
            if (this.bm == null) {
                BmHandler bmHandler = this;
                synchronized (bmHandler) {
                    if (this.bm == null) {
                        this.bm = new InjectableBeanManager(WebBeansContext.currentInstance().getBeanManagerImpl());
                    }
                }
            }
            return this.bm;
        }
    }
}

