/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils.multipart;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.ext.multipart.MultipartInputFilter;
import org.apache.cxf.jaxrs.ext.multipart.MultipartOutputFilter;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.multipart.MultipartReadException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public final class AttachmentUtils {
    public static final String OUT_FILTERS = "multipart.output.filters";
    public static final String IN_FILTERS = "multipart.input.filters";
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSUtils.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSUtils.class);

    private AttachmentUtils() {
    }

    public static void addMultipartOutFilter(MultipartOutputFilter filter) {
        Message m = JAXRSUtils.getCurrentMessage();
        ArrayList<MultipartOutputFilter> outFilters = CastUtils.cast((List)((List)m.get((Object)OUT_FILTERS)));
        if (outFilters == null) {
            outFilters = new ArrayList<MultipartOutputFilter>();
            m.put((Object)OUT_FILTERS, outFilters);
        }
        outFilters.add(filter);
    }

    public static void addMultipartInFilter(MultipartInputFilter filter) {
        Message m = JAXRSUtils.getCurrentMessage();
        ArrayList<MultipartInputFilter> inFilters = CastUtils.cast((List)((List)m.get((Object)IN_FILTERS)));
        if (inFilters == null) {
            inFilters = new ArrayList<MultipartInputFilter>();
            m.put((Object)IN_FILTERS, inFilters);
        }
        inFilters.add(filter);
    }

    public static MultipartBody getMultipartBody(MessageContext mc) {
        return (MultipartBody)mc.get("org.apache.cxf.jaxrs.attachments.inbound");
    }

    public static Map<String, Attachment> getChildAttachmentsMap(MessageContext mc, boolean preferContentDisposition) {
        return AttachmentUtils.fromListToMap(AttachmentUtils.getChildAttachments(mc), preferContentDisposition);
    }

    public static Map<String, Attachment> getChildAttachmentsMap(MessageContext mc) {
        return AttachmentUtils.fromListToMap(AttachmentUtils.getChildAttachments(mc), false);
    }

    public static List<Attachment> getChildAttachments(MessageContext mc) {
        return AttachmentUtils.getMultipartBody(mc).getChildAttachments();
    }

    public static Map<String, Attachment> getAttachmentsMap(MessageContext mc, boolean preferContentDisposition) {
        return AttachmentUtils.fromListToMap(AttachmentUtils.getAttachments(mc), preferContentDisposition);
    }

    public static Map<String, Attachment> getAttachmentsMap(MessageContext mc) {
        return AttachmentUtils.fromListToMap(AttachmentUtils.getAttachments(mc), false);
    }

    public static List<Attachment> getAttachments(MessageContext mc) {
        return AttachmentUtils.getMultipartBody(mc).getAllAttachments();
    }

    public static Attachment getFirstMatchingPart(MessageContext mc, Multipart id) {
        return AttachmentUtils.getFirstMatchingPart(mc, id.value());
    }

    public static Attachment getFirstMatchingPart(MessageContext mc, String id) {
        return AttachmentUtils.getFirstMatchingPart(mc, id, null);
    }

    public static Attachment getFirstMatchingPart(MessageContext mc, String id, String mediaType) {
        List<Attachment> all = AttachmentUtils.getAttachments(mc);
        List<Attachment> matching = AttachmentUtils.getMatchingAttachments(id, mediaType, all);
        return matching.isEmpty() ? null : matching.get(0);
    }

    public static MultipartBody getMultipartBody(MessageContext mc, String attachmentDir, String attachmentThreshold, String attachmentMaxSize) {
        if (attachmentDir != null) {
            mc.put("attachment-directory", attachmentDir);
        }
        if (attachmentThreshold != null) {
            mc.put("attachment-memory-threshold", attachmentThreshold);
        }
        if (attachmentMaxSize != null) {
            mc.put("attachment-max-size", attachmentMaxSize);
        }
        boolean embeddedAttachment = mc.get("org.apache.cxf.multipart.embedded") != null;
        String propertyName = embeddedAttachment ? "org.apache.cxf.jaxrs.attachments.inbound.embedded" : "org.apache.cxf.jaxrs.attachments.inbound";
        MultipartBody body = (MultipartBody)mc.get(propertyName);
        if (!embeddedAttachment && mc.get(IN_FILTERS) != null) {
            List filters = CastUtils.cast((List)((List)mc.get(IN_FILTERS)));
            for (MultipartInputFilter filter : filters) {
                filter.filter(body.getAllAttachments());
            }
        }
        return body;
    }

    public static List<Attachment> getAttachments(MessageContext mc, String attachmentDir, String attachmentThreshold, String attachmentMaxSize) {
        return AttachmentUtils.getMultipartBody(mc, attachmentDir, attachmentThreshold, attachmentMaxSize).getAllAttachments();
    }

    public static Attachment getMultipart(Multipart id, MediaType mt, List<Attachment> infos) throws IOException {
        if (id != null) {
            for (Attachment a : infos) {
                if (!AttachmentUtils.matchAttachmentId(a, id)) continue;
                AttachmentUtils.checkMediaTypes(a.getContentType(), id.type());
                return a;
            }
            if (id.required()) {
                org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("MULTTIPART_ID_NOT_FOUND", BUNDLE, new Object[]{id.value(), mt.toString()});
                LOG.warning(errorMsg.toString());
                throw ExceptionUtils.toBadRequestException(new MultipartReadException(id.value(), id.type(), errorMsg.toString()), null);
            }
            return null;
        }
        return !infos.isEmpty() ? infos.get(0) : null;
    }

    public static List<Attachment> getMatchingAttachments(Multipart id, List<Attachment> infos) {
        return AttachmentUtils.getMatchingAttachments(id.value(), id.type(), infos);
    }

    public static List<Attachment> getMatchingAttachments(String id, List<Attachment> infos) {
        return AttachmentUtils.getMatchingAttachments(id, null, infos);
    }

    public static List<Attachment> getMatchingAttachments(String id, String mediaType, List<Attachment> infos) {
        LinkedList<Attachment> all = new LinkedList<Attachment>();
        for (Attachment a : infos) {
            if (!AttachmentUtils.matchAttachmentId(a, id)) continue;
            if (mediaType != null) {
                AttachmentUtils.checkMediaTypes(a.getContentType(), mediaType);
            }
            all.add(a);
        }
        return all;
    }

    public static boolean matchAttachmentId(Attachment at, Multipart mid) {
        return AttachmentUtils.matchAttachmentId(at, mid.value());
    }

    public static boolean matchAttachmentId(Attachment at, String value) {
        if (value.isEmpty()) {
            return true;
        }
        if (at.getContentId().equals(value)) {
            return true;
        }
        ContentDisposition cd = at.getContentDisposition();
        return cd != null && value.equals(cd.getParameter("name"));
    }

    public static MultivaluedMap<String, String> populateFormMap(MessageContext mc, boolean errorIfMissing) {
        MetadataMap<String, String> data = new MetadataMap<String, String>();
        FormUtils.populateMapFromMultipart(data, AttachmentUtils.getMultipartBody(mc), PhaseInterceptorChain.getCurrentMessage(), true);
        return data;
    }

    public static MultivaluedMap<String, String> populateFormMap(MessageContext mc) {
        return AttachmentUtils.populateFormMap(mc, true);
    }

    private static Map<String, Attachment> fromListToMap(List<Attachment> atts, boolean preferContentDisposition) {
        LinkedHashMap<String, Attachment> map = new LinkedHashMap<String, Attachment>();
        for (Attachment a : atts) {
            ContentDisposition cd;
            String contentId = null;
            if (preferContentDisposition && (cd = a.getContentDisposition()) != null) {
                contentId = cd.getParameter("name");
            }
            if (contentId == null) {
                contentId = a.getContentId();
            }
            map.put(contentId, a);
        }
        return map;
    }

    private static void checkMediaTypes(MediaType mt1, String mt2) {
        if (!mt1.isCompatible(JAXRSUtils.toMediaType(mt2))) {
            throw ExceptionUtils.toNotSupportedException(null, null);
        }
    }
}

