/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.serializer.EJBDSerializer;

public class ClientMetaData
implements Externalizable {
    private static final long serialVersionUID = -8769170505291957783L;
    transient Object clientIdentity;
    private transient EJBDSerializer serializer;
    private transient ProtocolMetaData metaData;

    public ClientMetaData() {
    }

    public ClientMetaData(Object identity) {
        this.clientIdentity = identity;
    }

    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    public Object getClientIdentity() {
        return this.clientIdentity;
    }

    public void setClientIdentity(Object clientIdentity) {
        this.clientIdentity = clientIdentity;
    }

    public EJBDSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(EJBDSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this.clientIdentity = in.readObject();
        if ((null == this.metaData || this.metaData.isAtLeast(4, 6)) && in.readBoolean()) {
            try {
                this.serializer = (EJBDSerializer)EJBDSerializer.class.cast(Thread.currentThread().getContextClassLoader().loadClass(in.readUTF()).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.clientIdentity);
        if (null == this.metaData || this.metaData.isAtLeast(4, 6)) {
            out.writeBoolean(this.serializer != null);
            if (this.serializer != null) {
                out.writeUTF(this.serializer.getClass().getName());
            }
        }
    }
}

