/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.core.FailureContext;
import io.smallrye.faulttolerance.core.invocation.Invoker;
import io.smallrye.faulttolerance.core.invocation.NormalMethodInvoker;
import io.smallrye.faulttolerance.core.invocation.SpecialMethodInvoker;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import io.smallrye.faulttolerance.internal.SecurityActions;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

public final class BeforeRetryMethod {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final Method method;

    BeforeRetryMethod(Method method) {
        this.method = method;
    }

    public Invoker<?> createInvoker(FailureContext ctx) throws ReflectiveOperationException {
        InvocationContext interceptionContext = (InvocationContext)ctx.invocationContext.get(InvocationContext.class);
        Object[] arguments = interceptionContext.getParameters();
        if (arguments == null) {
            arguments = EMPTY_ARRAY;
        }
        return this.method.isDefault() ? new SpecialMethodInvoker(this.method, interceptionContext.getTarget(), arguments) : new NormalMethodInvoker(this.method, interceptionContext.getTarget(), arguments);
    }

    public static BeforeRetryMethod find(InterceptionPoint point, String beforeRetryMethodName) {
        try {
            Method beforeRetryMethod = SecurityActions.findBeforeRetryMethod(point.beanClass(), point.method().getDeclaringClass(), beforeRetryMethodName);
            if (beforeRetryMethod != null) {
                SecurityActions.setAccessible(beforeRetryMethod);
                return new BeforeRetryMethod(beforeRetryMethod);
            }
            return null;
        }
        catch (PrivilegedActionException e) {
            throw new FaultToleranceException("Could not obtain before retry method " + beforeRetryMethodName, (Throwable)e);
        }
    }
}

