/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.RetryConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Retry;

public final class RetryConfigImpl
implements RetryConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Retry instance;
    private final boolean onMethod;
    private Integer _maxRetries;
    private Long _delay;
    private ChronoUnit _delayUnit;
    private Long _maxDuration;
    private ChronoUnit _durationUnit;
    private Long _jitter;
    private ChronoUnit _jitterDelayUnit;
    private Class<? extends Throwable>[] _retryOn;
    private Class<? extends Throwable>[] _abortOn;

    private RetryConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.retry;
        this.onMethod = method.annotationsPresentDirectly.contains(Retry.class);
    }

    public static RetryConfigImpl create(FaultToleranceMethod method) {
        if (method.retry == null) {
            return null;
        }
        if (!io.smallrye.faulttolerance.autoconfig.Config.isEnabled(Retry.class, (MethodDescriptor)method.method)) {
            return null;
        }
        return new RetryConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return Retry.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public int maxRetries() {
        if (this._maxRetries == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Retry/maxRetries";
                this._maxRetries = config.getOptionalValue(key, Integer.TYPE).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Retry/maxRetries";
                this._maxRetries = config.getOptionalValue(key, Integer.TYPE).orElse(null);
            }
            if (this._maxRetries == null) {
                this._maxRetries = config.getOptionalValue("Retry/maxRetries", Integer.TYPE).orElse(null);
            }
            if (this._maxRetries == null) {
                this._maxRetries = this.instance.maxRetries();
            }
        }
        return this._maxRetries;
    }

    public long delay() {
        if (this._delay == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Retry/delay";
                this._delay = config.getOptionalValue(key, Long.TYPE).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Retry/delay";
                this._delay = config.getOptionalValue(key, Long.TYPE).orElse(null);
            }
            if (this._delay == null) {
                this._delay = config.getOptionalValue("Retry/delay", Long.TYPE).orElse(null);
            }
            if (this._delay == null) {
                this._delay = this.instance.delay();
            }
        }
        return this._delay;
    }

    public ChronoUnit delayUnit() {
        if (this._delayUnit == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Retry/delayUnit";
                this._delayUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Retry/delayUnit";
                this._delayUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            }
            if (this._delayUnit == null) {
                this._delayUnit = config.getOptionalValue("Retry/delayUnit", ChronoUnit.class).orElse(null);
            }
            if (this._delayUnit == null) {
                this._delayUnit = this.instance.delayUnit();
            }
        }
        return this._delayUnit;
    }

    public long maxDuration() {
        if (this._maxDuration == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Retry/maxDuration";
                this._maxDuration = config.getOptionalValue(key, Long.TYPE).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Retry/maxDuration";
                this._maxDuration = config.getOptionalValue(key, Long.TYPE).orElse(null);
            }
            if (this._maxDuration == null) {
                this._maxDuration = config.getOptionalValue("Retry/maxDuration", Long.TYPE).orElse(null);
            }
            if (this._maxDuration == null) {
                this._maxDuration = this.instance.maxDuration();
            }
        }
        return this._maxDuration;
    }

    public ChronoUnit durationUnit() {
        if (this._durationUnit == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Retry/durationUnit";
                this._durationUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Retry/durationUnit";
                this._durationUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            }
            if (this._durationUnit == null) {
                this._durationUnit = config.getOptionalValue("Retry/durationUnit", ChronoUnit.class).orElse(null);
            }
            if (this._durationUnit == null) {
                this._durationUnit = this.instance.durationUnit();
            }
        }
        return this._durationUnit;
    }

    public long jitter() {
        if (this._jitter == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Retry/jitter";
                this._jitter = config.getOptionalValue(key, Long.TYPE).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Retry/jitter";
                this._jitter = config.getOptionalValue(key, Long.TYPE).orElse(null);
            }
            if (this._jitter == null) {
                this._jitter = config.getOptionalValue("Retry/jitter", Long.TYPE).orElse(null);
            }
            if (this._jitter == null) {
                this._jitter = this.instance.jitter();
            }
        }
        return this._jitter;
    }

    public ChronoUnit jitterDelayUnit() {
        if (this._jitterDelayUnit == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Retry/jitterDelayUnit";
                this._jitterDelayUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Retry/jitterDelayUnit";
                this._jitterDelayUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            }
            if (this._jitterDelayUnit == null) {
                this._jitterDelayUnit = config.getOptionalValue("Retry/jitterDelayUnit", ChronoUnit.class).orElse(null);
            }
            if (this._jitterDelayUnit == null) {
                this._jitterDelayUnit = this.instance.jitterDelayUnit();
            }
        }
        return this._jitterDelayUnit;
    }

    public Class<? extends Throwable>[] retryOn() {
        if (this._retryOn == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Retry/retryOn";
                this._retryOn = config.getOptionalValue(key, Class[].class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Retry/retryOn";
                this._retryOn = config.getOptionalValue(key, Class[].class).orElse(null);
            }
            if (this._retryOn == null) {
                this._retryOn = config.getOptionalValue("Retry/retryOn", Class[].class).orElse(null);
            }
            if (this._retryOn == null) {
                this._retryOn = this.instance.retryOn();
            }
        }
        return this._retryOn;
    }

    public Class<? extends Throwable>[] abortOn() {
        if (this._abortOn == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Retry/abortOn";
                this._abortOn = config.getOptionalValue(key, Class[].class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Retry/abortOn";
                this._abortOn = config.getOptionalValue(key, Class[].class).orElse(null);
            }
            if (this._abortOn == null) {
                this._abortOn = config.getOptionalValue("Retry/abortOn", Class[].class).orElse(null);
            }
            if (this._abortOn == null) {
                this._abortOn = this.instance.abortOn();
            }
        }
        return this._abortOn;
    }

    public void materialize() {
        this.maxRetries();
        this.delay();
        this.delayUnit();
        this.maxDuration();
        this.durationUnit();
        this.jitter();
        this.jitterDelayUnit();
        this.retryOn();
        this.abortOn();
    }
}

