/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi.openid;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.json.JsonObject;
import jakarta.security.enterprise.authentication.mechanism.http.OpenIdAuthenticationMechanismDefinition;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import jakarta.security.enterprise.identitystore.openid.IdentityToken;
import jakarta.security.enterprise.identitystore.openid.OpenIdClaims;
import jakarta.security.enterprise.identitystore.openid.OpenIdContext;
import jakarta.security.enterprise.identitystore.openid.RefreshToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import org.apache.tomee.security.cdi.openid.storage.OpenIdStorageHandler;
import org.apache.tomee.security.http.openid.model.TomEEOpenIdClaims;

@SessionScoped
public class TomEEOpenIdContext
implements OpenIdContext {
    @Inject
    private Instance<OpenIdAuthenticationMechanismDefinition> definition;
    @Inject
    private OpenIdStorageHandler storageHandler;
    private JsonObject userInfoClaims;
    private String tokenType;
    private AccessToken accessToken;
    private IdentityToken identityToken;
    private Optional<RefreshToken> refreshToken;
    private Long expiresIn;

    @PostConstruct
    public void init() {
        if (this.definition.isUnsatisfied()) {
            throw new IllegalStateException("OpenIdContext is not available if no @OpenIdAuthenticationMechanismDefinition is defined");
        }
    }

    public String getSubject() {
        return (String)this.getIdentityToken().getJwtClaims().getSubject().orElseThrow(() -> new IllegalStateException("No subject received from openid provider in id_token"));
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public IdentityToken getIdentityToken() {
        return this.identityToken;
    }

    public Optional<RefreshToken> getRefreshToken() {
        return this.refreshToken;
    }

    public Optional<Long> getExpiresIn() {
        return Optional.ofNullable(this.expiresIn);
    }

    public JsonObject getClaimsJson() {
        return this.userInfoClaims;
    }

    public OpenIdClaims getClaims() {
        return new TomEEOpenIdClaims(this.getClaimsJson());
    }

    public JsonObject getProviderMetadata() {
        throw new UnsupportedOperationException();
    }

    public <T> Optional<T> getStoredValue(HttpServletRequest request, HttpServletResponse response, String key) {
        return Optional.ofNullable(this.storageHandler.get(request, response, key));
    }

    public void setUserInfoClaims(JsonObject userInfoClaims) {
        this.userInfoClaims = userInfoClaims;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public void setIdentityToken(IdentityToken identityToken) {
        this.identityToken = identityToken;
    }

    public void setRefreshToken(Optional<RefreshToken> refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }
}

