/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Typed;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@ApplicationScoped
@Typed(value={DefaultAuthenticationMechanism.class})
public class DefaultAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private HttpAuthenticationMechanism delegate;

    @PostConstruct
    private void init() {
        this.delegate = new EmptyAuthenticationMechanism();
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        return this.delegate.validateRequest(request, response, httpMessageContext);
    }

    public AuthenticationStatus secureResponse(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        return this.delegate.secureResponse(request, response, httpMessageContext);
    }

    public void cleanSubject(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) {
        this.delegate.cleanSubject(request, response, httpMessageContext);
    }

    void setDelegate(HttpAuthenticationMechanism delegate) {
        this.delegate = delegate;
    }

    private static class EmptyAuthenticationMechanism
    implements HttpAuthenticationMechanism {
        private EmptyAuthenticationMechanism() {
        }

        public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
            return httpMessageContext.doNothing();
        }
    }
}

