/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.pem;

import io.churchkey.Key;
import io.churchkey.util.Pem;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class BeginPublicKey {
    private BeginPublicKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            RSAPublicKey publicKey = (RSAPublicKey)factory.generatePublic(new X509EncodedKeySpec(bytes));
            return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.PEM);
        }
        catch (InvalidKeySpecException factory) {
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        try {
            KeyFactory factory = KeyFactory.getInstance("DSA");
            DSAPublicKey publicKey = (DSAPublicKey)factory.generatePublic(new X509EncodedKeySpec(bytes));
            return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.DSA, Key.Format.PEM);
        }
        catch (InvalidKeySpecException factory) {
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        try {
            KeyFactory factory = KeyFactory.getInstance("EC");
            ECPublicKey publicKey = (ECPublicKey)factory.generatePublic(new X509EncodedKeySpec(bytes));
            return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.EC, Key.Format.PEM);
        }
        catch (InvalidKeySpecException factory) {
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        throw new UnsupportedOperationException("Unsupported algorithm or invalid x509 key spec");
    }

    public static byte[] encode(Key key) {
        Pem.Builder pem = Pem.builder().type("PUBLIC KEY").wrap(64);
        java.security.Key value = key.getKey();
        try {
            if (value instanceof RSAPublicKey) {
                KeyFactory factory = KeyFactory.getInstance("RSA");
                X509EncodedKeySpec keySpec = factory.getKeySpec(value, X509EncodedKeySpec.class);
                return pem.data(keySpec.getEncoded()).format().getBytes();
            }
            if (value instanceof DSAPublicKey) {
                KeyFactory factory = KeyFactory.getInstance("DSA");
                X509EncodedKeySpec keySpec = factory.getKeySpec(value, X509EncodedKeySpec.class);
                return pem.data(keySpec.getEncoded()).format().getBytes();
            }
            if (value instanceof ECPublicKey) {
                KeyFactory factory = KeyFactory.getInstance("EC");
                X509EncodedKeySpec keySpec = factory.getKeySpec(value, X509EncodedKeySpec.class);
                return pem.data(keySpec.getEncoded()).format().getBytes();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported key algorithm", e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException("Invalid Key Spec", e);
        }
        throw new UnsupportedOperationException("Unsupported key algorithm " + (Object)((Object)key.getAlgorithm()));
    }
}

