/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;

public final class GeronimoUserTransaction
implements UserTransaction,
Serializable {
    private static final long serialVersionUID = -7524804683512228998L;
    private transient TransactionManager transactionManager;

    public GeronimoUserTransaction(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    boolean isActive() {
        return this.transactionManager != null;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        if (this.transactionManager == null) {
            this.transactionManager = transactionManager;
        } else if (this.transactionManager != transactionManager) {
            throw new IllegalStateException("This user transaction is already associated with another transaction manager");
        }
    }

    public int getStatus() throws SystemException {
        return this.transactionManager.getStatus();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.transactionManager.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            throw new SystemException("transaction timeout must be positive or 0, not " + seconds);
        }
        this.transactionManager.setTransactionTimeout(seconds);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.transactionManager.begin();
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.transactionManager.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.transactionManager.rollback();
    }
}

