/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.converter;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Locale;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.util.DateUtil;

public class DateConverter
implements Converter<Date> {
    public static final DateConverter ISO_8601_SHORT = new DateConverter("yyyyMMddHHmmssv");
    private static final ZoneId UTC = ZoneId.of("UTC");
    private final DateTimeFormatter formatter;

    public DateConverter(String pattern) {
        this.formatter = DateTimeFormatter.ofPattern(pattern, Locale.ROOT);
    }

    @Override
    public String toString(Date instance) {
        return this.formatter.format(ZonedDateTime.ofInstant(instance.toInstant(), UTC));
    }

    @Override
    public Date fromString(String text) {
        try {
            return Date.from(DateUtil.parseZonedDateTime(text, this.formatter, UTC).toInstant());
        }
        catch (DateTimeParseException dpe) {
            return Date.from(LocalDateTime.parse(text).toInstant(ZoneOffset.UTC));
        }
    }
}

