/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.webparameters;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.view.facelets.ELExpressionCacheMode;

public class MyfacesConfig {
    private static final String APPLICATION_MAP_PARAM_NAME;
    public static final String CONFIG_REFRESH_PERIOD = "org.apache.myfaces.CONFIG_REFRESH_PERIOD";
    private static final long CONFIG_REFRESH_PERIOD_DEFAULT = 2L;
    public static final String RENDER_VIEWSTATE_ID = "org.apache.myfaces.RENDER_VIEWSTATE_ID";
    private static final boolean RENDER_VIEWSTATE_ID_DEFAULT = true;
    public static final String STRICT_XHTML_LINKS = "org.apache.myfaces.STRICT_XHTML_LINKS";
    private static final boolean STRICT_XHTML_LINKS_DEFAULT = true;
    public static final String RENDER_CLEAR_JAVASCRIPT_FOR_BUTTON = "org.apache.myfaces.RENDER_CLEAR_JAVASCRIPT_FOR_BUTTON";
    private static final boolean RENDER_CLEAR_JAVASCRIPT_FOR_BUTTON_DEFAULT = false;
    public static final String DELEGATE_FACES_SERVLET = "org.apache.myfaces.DELEGATE_FACES_SERVLET";
    public static final String REFRESH_TRANSIENT_BUILD_ON_PSS = "org.apache.myfaces.REFRESH_TRANSIENT_BUILD_ON_PSS";
    private static final String REFRESH_TRANSIENT_BUILD_ON_PSS_DEFAULT = "auto";
    public static final String REFRESH_TRANSIENT_BUILD_ON_PSS_PRESERVE_STATE = "org.apache.myfaces.REFRESH_TRANSIENT_BUILD_ON_PSS_PRESERVE_STATE";
    private static final boolean REFRESH_TRANSIENT_BUILD_ON_PSS_PRESERVE_STATE_DEFAULT = false;
    public static final String VALIDATE_XML = "org.apache.myfaces.VALIDATE_XML";
    private static final boolean VALIDATE_XML_DEFAULT = false;
    public static final String WRAP_SCRIPT_CONTENT_WITH_XML_COMMENT_TAG = "org.apache.myfaces.WRAP_SCRIPT_CONTENT_WITH_XML_COMMENT_TAG";
    private static final boolean WRAP_SCRIPT_CONTENT_WITH_XML_COMMENT_TAG_DEFAULT = false;
    public static final String DEBUG_PHASE_LISTENER = "org.apache.myfaces.DEBUG_PHASE_LISTENER";
    private static final boolean DEBUG_PHASE_LISTENER_DEFAULT = false;
    public static final String STRICT_JSF_2_CC_EL_RESOLVER = "org.apache.myfaces.STRICT_JSF_2_CC_EL_RESOLVER";
    private static final boolean STRICT_JSF_2_CC_EL_RESOLVER_DEFAULT = false;
    public static final String DEFAULT_RESPONSE_WRITER_CONTENT_TYPE_MODE = "org.apache.myfaces.DEFAULT_RESPONSE_WRITER_CONTENT_TYPE_MODE";
    private static final String DEFAULT_RESPONSE_WRITER_CONTENT_TYPE_MODE_DEFAULT = "text/html";
    public static final String VIEW_UNIQUE_IDS_CACHE_ENABLED = "org.apache.myfaces.VIEW_UNIQUE_IDS_CACHE_ENABLED";
    private static final boolean VIEW_UNIQUE_IDS_CACHE_ENABLED_DEFAULT = true;
    public static final String COMPONENT_UNIQUE_IDS_CACHE_SIZE = "org.apache.myfaces.COMPONENT_UNIQUE_IDS_CACHE_SIZE";
    private static final int COMPONENT_UNIQUE_IDS_CACHE_SIZE_DEFAULT = 200;
    public static final String STRICT_JSF_2_VIEW_NOT_FOUND = "org.apache.myfaces.STRICT_JSF_2_VIEW_NOT_FOUND";
    private static final boolean STRICT_JSF_2_VIEW_NOT_FOUND_DEFAULT = false;
    public static final String EARLY_FLUSH_ENABLED = "org.apache.myfaces.EARLY_FLUSH_ENABLED";
    private static final boolean EARLY_FLUSH_ENABLED_DEFAULT = false;
    public static final String STRICT_JSF_2_FACELETS_COMPATIBILITY = "org.apache.myfaces.STRICT_JSF_2_FACELETS_COMPATIBILITY";
    private static final boolean STRICT_JSF_2_FACELETS_COMPATIBILITY_DEFAULT = false;
    public static final String RENDER_FORM_VIEW_STATE_AT_BEGIN = "org.apache.myfaces.RENDER_FORM_VIEW_STATE_AT_BEGIN";
    private static final boolean RENDER_FORM_VIEW_STATE_AT_BEGIN_DEFAULT = false;
    public static final String FLASH_SCOPE_DISABLED = "org.apache.myfaces.FLASH_SCOPE_DISABLED";
    private static final boolean FLASH_SCOPE_DISABLED_DEFAULT = false;
    public static final String NUMBER_OF_VIEWS_IN_SESSION = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    public static final int NUMBER_OF_VIEWS_IN_SESSION_DEFAULT = 20;
    public static final String NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION = "org.apache.myfaces.NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION";
    public static final Integer NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION_DEFAULT;
    public static final String NUMBER_OF_FLASH_TOKENS_IN_SESSION = "org.apache.myfaces.NUMBER_OF_FLASH_TOKENS_IN_SESSION";
    public static final String SUPPORT_EL_3_IMPORT_HANDLER = "org.apache.myfaces.SUPPORT_EL_3_IMPORT_HANDLER";
    private static final boolean SUPPORT_EL_3_IMPORT_HANDLER_DEFAULT = false;
    public static final String STRICT_JSF_2_ORIGIN_HEADER_APP_PATH = "org.apache.myfaces.STRICT_JSF_2_ORIGIN_HEADER_APP_PATH";
    private static final boolean STRICT_JSF_2_ORIGIN_HEADER_APP_PATH_DEFAULT = false;
    public static final String STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME = "org.apache.myfaces.STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME";
    private static final boolean STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME_DEFAULT = false;
    public static final String RESOURCE_BUFFER_SIZE = "org.apache.myfaces.RESOURCE_BUFFER_SIZE";
    private static final int RESOURCE_BUFFER_SIZE_DEFAULT = 2048;
    public static final String VALIDATE = "org.apache.myfaces.VALIDATE";
    public static final String USE_CDI_FOR_ANNOTATION_SCANNING = "org.apache.myfaces.annotation.USE_CDI_FOR_ANNOTATION_SCANNING";
    private static final boolean USE_CDI_FOR_ANNOTATION_SCANNING_DEFAULT = false;
    public static final String RESOURCE_HANDLER_CACHE_SIZE = "org.apache.myfaces.RESOURCE_HANDLER_CACHE_SIZE";
    private static final int RESOURCE_HANDLER_CACHE_SIZE_DEFAULT = 500;
    public static final String RESOURCE_HANDLER_CACHE_ENABLED = "org.apache.myfaces.RESOURCE_HANDLER_CACHE_ENABLED";
    private static final boolean RESOURCE_HANDLER_CACHE_ENABLED_DEFAULT = true;
    public static final String SCAN_PACKAGES = "org.apache.myfaces.annotation.SCAN_PACKAGES";
    public static final String WEBSOCKET_ENDPOINT_PORT = "jakarta.faces.WEBSOCKET_ENDPOINT_PORT";
    public static final String WEBSOCKET_MAX_IDLE_TIMEOUT = "org.apache.myfaces.WEBSOCKET_MAX_IDLE_TIMEOUT";
    private static final long WEBSOCKET_MAX_IDLE_TIMEOUT_DEFAULT = 300000L;
    public static final String RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN = "org.apache.myfaces.RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN";
    public static final String RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN_SECURE_RANDOM = "secureRandom";
    public static final String RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN_RANDOM = "random";
    private static final String RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN_DEFAULT = "secureRandom";
    public static final String CLIENT_VIEW_STATE_TIMEOUT = "org.apache.myfaces.CLIENT_VIEW_STATE_TIMEOUT";
    private static final Long CLIENT_VIEW_STATE_TIMEOUT_DEFAULT;
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM = "secureRandom";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_RANDOM = "random";
    private static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_DEFAULT = "secureRandom";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH";
    private static final int RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH_DEFAULT = 8;
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_CLASS = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_CLASS";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_PROVIDER = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_PROVIDER";
    public static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITHM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITHM";
    private static final String RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITHM_DEFAULT = "SHA1PRNG";
    public static final String RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM = "secureRandom";
    public static final String RANDOM_KEY_IN_CSRF_SESSION_TOKEN_RANDOM = "random";
    public static final String RANDOM_KEY_IN_CSRF_SESSION_TOKEN = "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN";
    private static final String RANDOM_KEY_IN_CSRF_SESSION_TOKEN_DEFAULT = "secureRandom";
    public static final String COMPRESS_STATE_IN_SESSION = "org.apache.myfaces.COMPRESS_STATE_IN_SESSION";
    private static final boolean COMPRESS_STATE_IN_SESSION_DEFAULT = true;
    public static final String USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION = "org.apache.myfaces.USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION";
    private static final boolean USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION_DEFAULT = false;
    public static final String AUTOCOMPLETE_OFF_VIEW_STATE = "org.apache.myfaces.AUTOCOMPLETE_OFF_VIEW_STATE";
    private static final boolean AUTOCOMPLETE_OFF_VIEW_STATE_DEFAULT = false;
    public static final String RESOURCE_MAX_TIME_EXPIRES = "org.apache.myfaces.RESOURCE_MAX_TIME_EXPIRES";
    private static final long RESOURCE_MAX_TIME_EXPIRES_DEFAULT = 604800000L;
    public static final String LAZY_LOAD_CONFIG_OBJECTS = "org.apache.myfaces.LAZY_LOAD_CONFIG_OBJECTS";
    private static final boolean LAZY_LOAD_CONFIG_OBJECTS_DEFAULT = true;
    public static final String EL_RESOLVER_COMPARATOR = "org.apache.myfaces.EL_RESOLVER_COMPARATOR";
    public static final String EL_RESOLVER_PREDICATE = "org.apache.myfaces.EL_RESOLVER_PREDICATE";
    public static final String VIEWID_CACHE_SIZE = "org.apache.myfaces.VIEWID_CACHE_SIZE";
    private static final int VIEWID_CACHE_SIZE_DEFAULT = 500;
    public static final String VIEWID_EXISTS_CACHE_ENABLED = "org.apache.myfaces.VIEWID_EXISTS_CACHE_ENABLED";
    private static final boolean VIEWID_EXISTS_CACHE_ENABLED_DEFAULT = true;
    public static final String VIEWID_PROTECTED_CACHE_ENABLED = "org.apache.myfaces.VIEWID_PROTECTED_CACHE_ENABLED";
    private static final boolean VIEWID_PROTECTED_CACHE_ENABLED_DEFAULT = true;
    public static final String VIEWID_DERIVE_CACHE_ENABLED = "org.apache.myfaces.VIEWID_DERIVE_CACHE_ENABLED";
    private static final boolean VIEWID_DERIVE_CACHE_ENABLED_DEFAULT = true;
    public static final String BEAN_BEFORE_JSF_VALIDATION = "org.apache.myfaces.validator.BEAN_BEFORE_JSF_VALIDATION";
    private static final boolean BEAN_BEFORE_JSF_VALIDATION_DEFAULT = false;
    public static final String FACES_INIT_PLUGINS = "org.apache.myfaces.FACES_INIT_PLUGINS";
    public static final String INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN = "org.apache.myfaces.INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN";
    private static final boolean INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN_DEFAULT = false;
    public static final String INITIALIZE_ALWAYS_STANDALONE = "org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE";
    public static final String EXPRESSION_FACTORY = "org.apache.myfaces.EXPRESSION_FACTORY";
    public static final String CHECK_ID_PRODUCTION_MODE = "org.apache.myfaces.CHECK_ID_PRODUCTION_MODE";
    private static final String CHECK_ID_PRODUCTION_MODE_DEFAULT = "auto";
    public static final String CHECK_ID_PRODUCTION_MODE_TRUE = "true";
    public static final String CHECK_ID_PRODUCTION_MODE_AUTO = "auto";
    public static final String MARK_INITIAL_STATE_WHEN_APPLY_BUILD_VIEW = "org.apache.myfaces.MARK_INITIAL_STATE_WHEN_APPLY_BUILD_VIEW";
    private static final boolean MARK_INITIAL_STATE_WHEN_APPLY_BUILD_VIEW_DEFAULT = false;
    public static final String CACHE_EL_EXPRESSIONS = "org.apache.myfaces.CACHE_EL_EXPRESSIONS";
    private static final String CACHE_EL_EXPRESSIONS_DEFAULT;
    public static final String WRAP_TAG_EXCEPTIONS_AS_CONTEXT_AWARE = "org.apache.myfaces.WRAP_TAG_EXCEPTIONS_AS_CONTEXT_AWARE";
    private static final boolean WRAP_TAG_EXCEPTIONS_AS_CONTEXT_AWARE_DEFAULT = true;
    public static final String RESOURCE_CACHE_LAST_MODIFIED = "org.apache.myfaces.RESOURCE_CACHE_LAST_MODIFIED";
    private static final boolean RESOURCE_CACHE_LAST_MODIFIED_DEFAULT = true;
    public static final String LOG_WEB_CONTEXT_PARAMS = "org.apache.myfaces.LOG_WEB_CONTEXT_PARAMS";
    private static final String LOG_WEB_CONTEXT_PARAMS_DEFAULT = "dev-only";
    public static final boolean AUTOMATIC_EXTENSIONLESS_MAPPING_DEFAULT = false;
    public static final String FACES_INITIALIZER = "org.apache.myfaces.FACES_INITIALIZER";
    public static final String INJECTION_PROVIDER;
    public static final String WEBSOCKET_MAX_CONNECTIONS = "org.apache.myfaces.WEBSOCKET_MAX_CONNECTIONS";
    public static final Integer WEBSOCKET_MAX_CONNECTIONS_DEFAULT;
    public static final String RENDER_CLIENTBEHAVIOR_SCRIPTS_AS_STRING = "org.apache.myfaces.RENDER_CLIENTBEHAVIOR_SCRIPTS_AS_STRING";
    public static final boolean RENDER_CLIENTBEHAVIOR_SCRIPTS_AS_STRING_DEFAULT = false;
    public static final String ALWAYS_FORCE_SESSION_CREATION = "org.apache.myfaces.ALWAYS_FORCE_SESSION_CREATION";
    protected static final boolean ALWAYS_FORCE_SESSION_CREATION_DEFAULT = false;
    public static final String RESOURCE_BUNDLE_CONTROL = "org.apache.myfaces.RESOURCE_BUNDLE_CONTROL";
    public static final String EL_RESOLVER_TRACING = "org.apache.myfaces.EL_RESOLVER_TRACING";
    public static final boolean EL_RESOLVER_TRACING_DEFAULT = false;
    public static final String EXCEPTION_TYPES_TO_IGNORE_IN_LOGGING = "org.apache.myfaces.EXCEPTION_TYPES_TO_IGNORE_IN_LOGGING";
    private ProjectStage projectStage = ProjectStage.Production;
    private boolean strictJsf2AllowSlashLibraryName;
    private long configRefreshPeriod = 2L;
    private boolean renderViewStateId = true;
    private boolean strictXhtmlLinks = true;
    private boolean renderClearJavascriptOnButton = false;
    private String delegateFacesServlet;
    private boolean refreshTransientBuildOnPSS = true;
    private boolean refreshTransientBuildOnPSSAuto = true;
    private boolean refreshTransientBuildOnPSSPreserveState = false;
    private boolean validateXML = false;
    private boolean wrapScriptContentWithXmlCommentTag = false;
    private boolean debugPhaseListenerEnabled = false;
    private boolean strictJsf2CCELResolver = false;
    private String defaultResponseWriterContentTypeMode = "text/html";
    private boolean viewUniqueIdsCacheEnabled = true;
    private int componentUniqueIdsCacheSize = 200;
    private boolean strictJsf2ViewNotFound = false;
    private boolean earlyFlushEnabled = false;
    private boolean strictJsf2FaceletsCompatibility = false;
    private boolean renderFormViewStateAtBegin = false;
    private boolean flashScopeDisabled = false;
    private Integer numberOfViewsInSession = 20;
    private Integer numberOfSequentialViewsInSession = NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION_DEFAULT;
    private Integer numberOfFlashTokensInSession;
    private Integer numberOfClientWindows;
    private boolean supportEL3ImportHandler = false;
    private boolean strictJsf2OriginHeaderAppPath = false;
    private int resourceBufferSize = 2048;
    private boolean useCdiForAnnotationScanning = false;
    private boolean resourceHandlerCacheEnabled = true;
    private int resourceHandlerCacheSize = 500;
    private String scanPackages;
    private long websocketMaxIdleTimeout = 300000L;
    private Integer websocketEndpointPort;
    private String randomKeyInWebsocketSessionToken = "secureRandom";
    private long clientViewStateTimeout = CLIENT_VIEW_STATE_TIMEOUT_DEFAULT;
    private String randomKeyInViewStateSessionToken = "secureRandom";
    private int randomKeyInViewStateSessionTokenLength = 8;
    private String randomKeyInViewStateSessionTokenSecureRandomClass;
    private String randomKeyInViewStateSessionTokenSecureRandomProvider;
    private String randomKeyInViewStateSessionTokenSecureRandomAlgorithm = "SHA1PRNG";
    private String randomKeyInCsrfSessionToken = "secureRandom";
    private boolean serializeStateInSession = false;
    private boolean compressStateInSession = true;
    private boolean useFlashScopePurgeViewsInSession = false;
    private boolean autocompleteOffViewState = false;
    private long resourceMaxTimeExpires = 604800000L;
    private boolean lazyLoadConfigObjects = true;
    private String elResolverComparator;
    private String elResolverPredicate;
    private boolean viewIdExistsCacheEnabled = true;
    private boolean viewIdProtectedCacheEnabled = true;
    private boolean viewIdDeriveCacheEnabled = true;
    private int viewIdCacheSize = 500;
    private boolean beanBeforeJsfValidation = false;
    private String facesInitPlugins;
    private boolean initializeSkipJarFacesConfigScan = false;
    private String expressionFactory;
    private String checkIdProductionMode = "auto";
    private boolean partialStateSaving = true;
    private String[] fullStateSavingViewIds;
    private int faceletsBufferSize = 1024;
    private boolean markInitialStateWhenApplyBuildView = false;
    private String[] viewSuffix = new String[]{".xhtml"};
    private String[] faceletsViewMappings = new String[0];
    private String faceletsViewSuffix = ".xhtml";
    private ELExpressionCacheMode elExpressionCacheMode;
    private boolean wrapTagExceptionsAsContextAware = true;
    private boolean resourceCacheLastModified = true;
    private boolean logWebContextParams = false;
    private int websocketMaxConnections = WEBSOCKET_MAX_CONNECTIONS_DEFAULT;
    private boolean renderClientBehaviorScriptsAsString = false;
    private boolean alwaysForceSessionCreation = false;
    private ResourceBundle.Control resourceBundleControl;
    private boolean automaticExtensionlessMapping = false;
    private boolean elResolverTracing = false;
    private List<String> exceptionTypesToIgnoreInLogging = new ArrayList<String>();
    private static final boolean MYFACES_IMPL_AVAILABLE;
    private static final boolean RI_IMPL_AVAILABLE;

    public static MyfacesConfig getCurrentInstance() {
        return MyfacesConfig.getCurrentInstance(FacesContext.getCurrentInstance().getExternalContext());
    }

    public static MyfacesConfig getCurrentInstance(FacesContext facesContext) {
        return MyfacesConfig.getCurrentInstance(facesContext.getExternalContext());
    }

    public static MyfacesConfig getCurrentInstance(ExternalContext extCtx) {
        MyfacesConfig config = (MyfacesConfig)extCtx.getApplicationMap().get(APPLICATION_MAP_PARAM_NAME);
        if (config == null) {
            config = MyfacesConfig.createAndInitializeMyFacesConfig(extCtx);
            extCtx.getApplicationMap().put(APPLICATION_MAP_PARAM_NAME, config);
        }
        return config;
    }

    public MyfacesConfig() {
        this.numberOfFlashTokensInSession = 20 / NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION_DEFAULT + 1;
    }

    private static MyfacesConfig createAndInitializeMyFacesConfig(ExternalContext extCtx) {
        String[] exceptionTypesToIgnoreInLogging;
        String logWebContextParams;
        MyfacesConfig cfg = new MyfacesConfig();
        try {
            cfg.projectStage = ProjectStage.valueOf((String)MyfacesConfig.getString(extCtx, "jakarta.faces.PROJECT_STAGE", null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cfg.projectStage == null) {
            cfg.projectStage = ProjectStage.Production;
        }
        cfg.renderClearJavascriptOnButton = MyfacesConfig.getBoolean(extCtx, RENDER_CLEAR_JAVASCRIPT_FOR_BUTTON, false);
        cfg.renderViewStateId = MyfacesConfig.getBoolean(extCtx, RENDER_VIEWSTATE_ID, true);
        cfg.strictXhtmlLinks = MyfacesConfig.getBoolean(extCtx, STRICT_XHTML_LINKS, true);
        cfg.configRefreshPeriod = MyfacesConfig.getLong(extCtx, CONFIG_REFRESH_PERIOD, 2L);
        cfg.delegateFacesServlet = MyfacesConfig.getString(extCtx, DELEGATE_FACES_SERVLET, null);
        String refreshTransientBuildOnPSS = MyfacesConfig.getString(extCtx, REFRESH_TRANSIENT_BUILD_ON_PSS, "auto");
        if (refreshTransientBuildOnPSS == null) {
            cfg.refreshTransientBuildOnPSS = false;
            cfg.refreshTransientBuildOnPSSAuto = false;
        } else if ("auto".equalsIgnoreCase(refreshTransientBuildOnPSS)) {
            cfg.refreshTransientBuildOnPSS = true;
            cfg.refreshTransientBuildOnPSSAuto = true;
        } else if (refreshTransientBuildOnPSS.equalsIgnoreCase(CHECK_ID_PRODUCTION_MODE_TRUE) || refreshTransientBuildOnPSS.equalsIgnoreCase("on") || refreshTransientBuildOnPSS.equalsIgnoreCase("yes")) {
            cfg.refreshTransientBuildOnPSS = true;
            cfg.refreshTransientBuildOnPSSAuto = false;
        } else {
            cfg.refreshTransientBuildOnPSS = false;
            cfg.refreshTransientBuildOnPSSAuto = false;
        }
        cfg.refreshTransientBuildOnPSSPreserveState = MyfacesConfig.getBoolean(extCtx, REFRESH_TRANSIENT_BUILD_ON_PSS_PRESERVE_STATE, false);
        cfg.validateXML = MyfacesConfig.getBoolean(extCtx, VALIDATE_XML, false);
        cfg.wrapScriptContentWithXmlCommentTag = MyfacesConfig.getBoolean(extCtx, WRAP_SCRIPT_CONTENT_WITH_XML_COMMENT_TAG, false);
        cfg.debugPhaseListenerEnabled = MyfacesConfig.getBoolean(extCtx, DEBUG_PHASE_LISTENER, false);
        cfg.strictJsf2CCELResolver = MyfacesConfig.getBoolean(extCtx, STRICT_JSF_2_CC_EL_RESOLVER, false);
        cfg.defaultResponseWriterContentTypeMode = MyfacesConfig.getString(extCtx, DEFAULT_RESPONSE_WRITER_CONTENT_TYPE_MODE, DEFAULT_RESPONSE_WRITER_CONTENT_TYPE_MODE_DEFAULT);
        cfg.viewUniqueIdsCacheEnabled = MyfacesConfig.getBoolean(extCtx, VIEW_UNIQUE_IDS_CACHE_ENABLED, true);
        cfg.componentUniqueIdsCacheSize = MyfacesConfig.getInt(extCtx, COMPONENT_UNIQUE_IDS_CACHE_SIZE, 200);
        cfg.strictJsf2ViewNotFound = MyfacesConfig.getBoolean(extCtx, STRICT_JSF_2_VIEW_NOT_FOUND, false);
        cfg.earlyFlushEnabled = MyfacesConfig.getBoolean(extCtx, EARLY_FLUSH_ENABLED, false);
        if (cfg.projectStage != ProjectStage.Production) {
            cfg.earlyFlushEnabled = false;
        }
        cfg.strictJsf2FaceletsCompatibility = MyfacesConfig.getBoolean(extCtx, STRICT_JSF_2_FACELETS_COMPATIBILITY, false);
        cfg.renderFormViewStateAtBegin = MyfacesConfig.getBoolean(extCtx, RENDER_FORM_VIEW_STATE_AT_BEGIN, false);
        cfg.flashScopeDisabled = MyfacesConfig.getBoolean(extCtx, FLASH_SCOPE_DISABLED, false);
        cfg.strictJsf2AllowSlashLibraryName = MyfacesConfig.getBoolean(extCtx, STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME, false);
        try {
            cfg.numberOfSequentialViewsInSession = MyfacesConfig.getInt(extCtx, NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION, NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION_DEFAULT);
            if (cfg.numberOfSequentialViewsInSession == null || cfg.numberOfSequentialViewsInSession < 0) {
                Logger.getLogger(MyfacesConfig.class.getName()).severe("Configured value for org.apache.myfaces.NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION is not valid, must be an value >= 0, using default value (" + NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION_DEFAULT);
                cfg.numberOfSequentialViewsInSession = NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION_DEFAULT;
            }
        }
        catch (Throwable e) {
            Logger.getLogger(MyfacesConfig.class.getName()).log(Level.SEVERE, "Error determining the value for org.apache.myfaces.NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION, expected an integer value > 0, using default value (" + NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION_DEFAULT + "): " + e.getMessage(), e);
        }
        try {
            cfg.numberOfViewsInSession = MyfacesConfig.getInt(extCtx, NUMBER_OF_VIEWS_IN_SESSION, 20);
            if (cfg.numberOfViewsInSession == null || cfg.numberOfViewsInSession <= 0) {
                Logger.getLogger(MyfacesConfig.class.getName()).severe("Configured value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION is not valid, must be an value > 0, using default value (20");
                cfg.numberOfViewsInSession = 20;
            }
        }
        catch (Throwable e) {
            Logger.getLogger(MyfacesConfig.class.getName()).log(Level.SEVERE, "Error determining the value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION, expected an integer value > 0, using default value (20): " + e.getMessage(), e);
        }
        int numberOfFlashTokensInSessionDefault = cfg.numberOfSequentialViewsInSession != null && cfg.numberOfSequentialViewsInSession > 0 ? cfg.numberOfViewsInSession / cfg.numberOfSequentialViewsInSession + 1 : cfg.numberOfViewsInSession + 1;
        cfg.numberOfFlashTokensInSession = MyfacesConfig.getInt(extCtx, NUMBER_OF_FLASH_TOKENS_IN_SESSION, numberOfFlashTokensInSessionDefault);
        cfg.numberOfClientWindows = MyfacesConfig.getInt(extCtx, "jakarta.faces.NUMBER_OF_CLIENT_WINDOWS", 10);
        cfg.supportEL3ImportHandler = MyfacesConfig.getBoolean(extCtx, SUPPORT_EL_3_IMPORT_HANDLER, false);
        cfg.strictJsf2OriginHeaderAppPath = MyfacesConfig.getBoolean(extCtx, STRICT_JSF_2_ORIGIN_HEADER_APP_PATH, false);
        cfg.resourceBufferSize = MyfacesConfig.getInt(extCtx, RESOURCE_BUFFER_SIZE, 2048);
        cfg.useCdiForAnnotationScanning = MyfacesConfig.getBoolean(extCtx, USE_CDI_FOR_ANNOTATION_SCANNING, false);
        cfg.resourceHandlerCacheEnabled = MyfacesConfig.getBoolean(extCtx, RESOURCE_HANDLER_CACHE_ENABLED, true);
        if (cfg.projectStage != ProjectStage.Production) {
            cfg.resourceHandlerCacheEnabled = false;
        }
        cfg.resourceHandlerCacheSize = MyfacesConfig.getInt(extCtx, RESOURCE_HANDLER_CACHE_SIZE, 500);
        cfg.scanPackages = MyfacesConfig.getString(extCtx, SCAN_PACKAGES, null);
        String websocketEndpointPort = extCtx.getInitParameter(WEBSOCKET_ENDPOINT_PORT);
        if (websocketEndpointPort != null && !websocketEndpointPort.isEmpty()) {
            cfg.websocketEndpointPort = Integer.valueOf(websocketEndpointPort);
        }
        cfg.websocketMaxIdleTimeout = MyfacesConfig.getLong(extCtx, WEBSOCKET_MAX_IDLE_TIMEOUT, 300000L);
        cfg.randomKeyInWebsocketSessionToken = MyfacesConfig.getString(extCtx, RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN, "secureRandom");
        cfg.clientViewStateTimeout = MyfacesConfig.getLong(extCtx, CLIENT_VIEW_STATE_TIMEOUT, CLIENT_VIEW_STATE_TIMEOUT_DEFAULT);
        if (cfg.clientViewStateTimeout < 0L) {
            cfg.clientViewStateTimeout = 0L;
        }
        cfg.randomKeyInViewStateSessionToken = MyfacesConfig.getString(extCtx, RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN, "secureRandom");
        cfg.randomKeyInViewStateSessionTokenLength = MyfacesConfig.getInt(extCtx, RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH, 8);
        cfg.randomKeyInViewStateSessionTokenSecureRandomClass = MyfacesConfig.getString(extCtx, RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_CLASS, null);
        cfg.randomKeyInViewStateSessionTokenSecureRandomProvider = MyfacesConfig.getString(extCtx, RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_PROVIDER, null);
        cfg.randomKeyInViewStateSessionTokenSecureRandomAlgorithm = MyfacesConfig.getString(extCtx, RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITHM, RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITHM_DEFAULT);
        cfg.randomKeyInCsrfSessionToken = MyfacesConfig.getString(extCtx, RANDOM_KEY_IN_CSRF_SESSION_TOKEN, "secureRandom");
        cfg.serializeStateInSession = MyfacesConfig.getBoolean(extCtx, "jakarta.faces.SERIALIZE_SERVER_STATE", false);
        cfg.compressStateInSession = MyfacesConfig.getBoolean(extCtx, COMPRESS_STATE_IN_SESSION, true);
        cfg.useFlashScopePurgeViewsInSession = MyfacesConfig.getBoolean(extCtx, USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION, false);
        cfg.autocompleteOffViewState = MyfacesConfig.getBoolean(extCtx, AUTOCOMPLETE_OFF_VIEW_STATE, false);
        cfg.resourceMaxTimeExpires = MyfacesConfig.getLong(extCtx, RESOURCE_MAX_TIME_EXPIRES, 604800000L);
        cfg.lazyLoadConfigObjects = MyfacesConfig.getBoolean(extCtx, LAZY_LOAD_CONFIG_OBJECTS, true);
        cfg.elResolverComparator = MyfacesConfig.getString(extCtx, EL_RESOLVER_COMPARATOR, null);
        cfg.elResolverPredicate = MyfacesConfig.getString(extCtx, EL_RESOLVER_PREDICATE, null);
        cfg.viewIdExistsCacheEnabled = MyfacesConfig.getBoolean(extCtx, VIEWID_EXISTS_CACHE_ENABLED, true);
        if (cfg.projectStage == ProjectStage.Development) {
            cfg.viewIdExistsCacheEnabled = false;
        }
        cfg.viewIdProtectedCacheEnabled = MyfacesConfig.getBoolean(extCtx, VIEWID_PROTECTED_CACHE_ENABLED, true);
        if (cfg.projectStage == ProjectStage.Development) {
            cfg.viewIdProtectedCacheEnabled = false;
        }
        cfg.viewIdDeriveCacheEnabled = MyfacesConfig.getBoolean(extCtx, VIEWID_DERIVE_CACHE_ENABLED, true);
        if (cfg.projectStage == ProjectStage.Development) {
            cfg.viewIdDeriveCacheEnabled = false;
        }
        cfg.viewIdCacheSize = MyfacesConfig.getInt(extCtx, VIEWID_CACHE_SIZE, 500);
        cfg.beanBeforeJsfValidation = MyfacesConfig.getBoolean(extCtx, BEAN_BEFORE_JSF_VALIDATION, false);
        cfg.facesInitPlugins = MyfacesConfig.getString(extCtx, FACES_INIT_PLUGINS, null);
        cfg.initializeSkipJarFacesConfigScan = MyfacesConfig.getBoolean(extCtx, INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN, false);
        cfg.expressionFactory = MyfacesConfig.getString(extCtx, EXPRESSION_FACTORY, null);
        cfg.checkIdProductionMode = MyfacesConfig.getString(extCtx, CHECK_ID_PRODUCTION_MODE, "auto");
        cfg.partialStateSaving = MyfacesConfig.getBoolean(extCtx, "jakarta.faces.PARTIAL_STATE_SAVING", true);
        cfg.fullStateSavingViewIds = StringUtils.splitShortString(MyfacesConfig.getString(extCtx, "jakarta.faces.FULL_STATE_SAVING_VIEW_IDS", null), ',');
        cfg.faceletsBufferSize = MyfacesConfig.getInt(extCtx, "jakarta.faces.FACELETS_BUFFER_SIZE", 1024);
        cfg.markInitialStateWhenApplyBuildView = MyfacesConfig.getBoolean(extCtx, MARK_INITIAL_STATE_WHEN_APPLY_BUILD_VIEW, false);
        cfg.viewSuffix = StringUtils.splitShortString(MyfacesConfig.getString(extCtx, "jakarta.faces.DEFAULT_SUFFIX", ".xhtml"), ' ');
        cfg.faceletsViewMappings = StringUtils.splitShortString(MyfacesConfig.getString(extCtx, "jakarta.faces.FACELETS_VIEW_MAPPINGS", null), ';');
        cfg.faceletsViewSuffix = MyfacesConfig.getString(extCtx, "jakarta.faces.FACELETS_SUFFIX", ".xhtml");
        String elExpressionCacheMode = MyfacesConfig.getString(extCtx, CACHE_EL_EXPRESSIONS, CACHE_EL_EXPRESSIONS_DEFAULT);
        cfg.elExpressionCacheMode = Enum.valueOf(ELExpressionCacheMode.class, elExpressionCacheMode);
        cfg.wrapTagExceptionsAsContextAware = MyfacesConfig.getBoolean(extCtx, WRAP_TAG_EXCEPTIONS_AS_CONTEXT_AWARE, true);
        cfg.resourceCacheLastModified = MyfacesConfig.getBoolean(extCtx, RESOURCE_CACHE_LAST_MODIFIED, true);
        if (cfg.projectStage == ProjectStage.Development) {
            cfg.resourceCacheLastModified = false;
        }
        switch (logWebContextParams = MyfacesConfig.getString(extCtx, LOG_WEB_CONTEXT_PARAMS, LOG_WEB_CONTEXT_PARAMS_DEFAULT)) {
            case "dev-only": {
                if (cfg.projectStage == ProjectStage.Development) {
                    cfg.logWebContextParams = true;
                    break;
                }
                cfg.logWebContextParams = false;
                break;
            }
            case "true": {
                if (cfg.projectStage == ProjectStage.Production || cfg.projectStage == ProjectStage.Development) {
                    cfg.logWebContextParams = true;
                    break;
                }
                cfg.logWebContextParams = false;
                break;
            }
            default: {
                cfg.logWebContextParams = false;
            }
        }
        cfg.websocketMaxConnections = MyfacesConfig.getInt(extCtx, WEBSOCKET_MAX_CONNECTIONS, WEBSOCKET_MAX_CONNECTIONS_DEFAULT);
        cfg.renderClientBehaviorScriptsAsString = MyfacesConfig.getBoolean(extCtx, RENDER_CLIENTBEHAVIOR_SCRIPTS_AS_STRING, false);
        cfg.alwaysForceSessionCreation = MyfacesConfig.getBoolean(extCtx, ALWAYS_FORCE_SESSION_CREATION, false);
        String resourceBundleControl = MyfacesConfig.getString(extCtx, RESOURCE_BUNDLE_CONTROL, null);
        if (StringUtils.isNotBlank(resourceBundleControl)) {
            cfg.resourceBundleControl = (ResourceBundle.Control)ClassUtils.newInstance((String)resourceBundleControl);
        }
        cfg.automaticExtensionlessMapping = MyfacesConfig.getBoolean(extCtx, "jakarta.faces.AUTOMATIC_EXTENSIONLESS_MAPPING", false);
        cfg.elResolverTracing = MyfacesConfig.getBoolean(extCtx, EL_RESOLVER_TRACING, false);
        for (String exceptionTypeToIgnoreInLogging : exceptionTypesToIgnoreInLogging = StringUtils.splitShortString(MyfacesConfig.getString(extCtx, EXCEPTION_TYPES_TO_IGNORE_IN_LOGGING, ""), ',')) {
            if (!StringUtils.isNotBlank(exceptionTypeToIgnoreInLogging)) continue;
            cfg.exceptionTypesToIgnoreInLogging.add(exceptionTypeToIgnoreInLogging);
        }
        return cfg;
    }

    private static boolean getBoolean(ExternalContext externalContext, String paramName, boolean defaultValue) {
        String value = externalContext.getInitParameter(paramName);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase(CHECK_ID_PRODUCTION_MODE_TRUE) || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no")) {
            return false;
        }
        return defaultValue;
    }

    private static String getString(ExternalContext externalContext, String paramName, String defaultValue) {
        String value = externalContext.getInitParameter(paramName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static int getInt(ExternalContext externalContext, String paramName, int defaultValue) {
        String value = externalContext.getInitParameter(paramName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private static long getLong(ExternalContext externalContext, String paramName, long defaultValue) {
        String value = externalContext.getInitParameter(paramName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public boolean isMyfacesImplAvailable() {
        return MYFACES_IMPL_AVAILABLE;
    }

    public boolean isRiImplAvailable() {
        return RI_IMPL_AVAILABLE;
    }

    public boolean isStrictJsf2AllowSlashLibraryName() {
        return this.strictJsf2AllowSlashLibraryName;
    }

    public long getConfigRefreshPeriod() {
        return this.configRefreshPeriod;
    }

    public boolean isRenderViewStateId() {
        return this.renderViewStateId;
    }

    public boolean isStrictXhtmlLinks() {
        return this.strictXhtmlLinks;
    }

    public boolean isRenderClearJavascriptOnButton() {
        return this.renderClearJavascriptOnButton;
    }

    public String getDelegateFacesServlet() {
        return this.delegateFacesServlet;
    }

    public boolean isRefreshTransientBuildOnPSS() {
        return this.refreshTransientBuildOnPSS;
    }

    public boolean isRefreshTransientBuildOnPSSAuto() {
        return this.refreshTransientBuildOnPSSAuto;
    }

    public boolean isRefreshTransientBuildOnPSSPreserveState() {
        return this.refreshTransientBuildOnPSSPreserveState;
    }

    public boolean isValidateXML() {
        return this.validateXML;
    }

    public boolean isWrapScriptContentWithXmlCommentTag() {
        return this.wrapScriptContentWithXmlCommentTag;
    }

    public boolean isDebugPhaseListenerEnabled() {
        return this.debugPhaseListenerEnabled;
    }

    public boolean isStrictJsf2CCELResolver() {
        return this.strictJsf2CCELResolver;
    }

    public String getDefaultResponseWriterContentTypeMode() {
        return this.defaultResponseWriterContentTypeMode;
    }

    public boolean isViewUniqueIdsCacheEnabled() {
        return this.viewUniqueIdsCacheEnabled;
    }

    public int getComponentUniqueIdsCacheSize() {
        return this.componentUniqueIdsCacheSize;
    }

    public boolean isStrictJsf2ViewNotFound() {
        return this.strictJsf2ViewNotFound;
    }

    public boolean isEarlyFlushEnabled() {
        return this.earlyFlushEnabled;
    }

    public boolean isStrictJsf2FaceletsCompatibility() {
        return this.strictJsf2FaceletsCompatibility;
    }

    public boolean isRenderFormViewStateAtBegin() {
        return this.renderFormViewStateAtBegin;
    }

    public boolean isFlashScopeDisabled() {
        return this.flashScopeDisabled;
    }

    public Integer getNumberOfViewsInSession() {
        return this.numberOfViewsInSession;
    }

    public Integer getNumberOfSequentialViewsInSession() {
        return this.numberOfSequentialViewsInSession;
    }

    public Integer getNumberOfFlashTokensInSession() {
        return this.numberOfFlashTokensInSession;
    }

    public boolean isSupportEL3ImportHandler() {
        return this.supportEL3ImportHandler;
    }

    public boolean isStrictJsf2OriginHeaderAppPath() {
        return this.strictJsf2OriginHeaderAppPath;
    }

    public int getResourceBufferSize() {
        return this.resourceBufferSize;
    }

    public boolean isUseCdiForAnnotationScanning() {
        return this.useCdiForAnnotationScanning;
    }

    public boolean isResourceHandlerCacheEnabled() {
        return this.resourceHandlerCacheEnabled;
    }

    public int getResourceHandlerCacheSize() {
        return this.resourceHandlerCacheSize;
    }

    public String getScanPackages() {
        return this.scanPackages;
    }

    public long getWebsocketMaxIdleTimeout() {
        return this.websocketMaxIdleTimeout;
    }

    public Integer getWebsocketEndpointPort() {
        return this.websocketEndpointPort;
    }

    public long getClientViewStateTimeout() {
        return this.clientViewStateTimeout;
    }

    public String getRandomKeyInViewStateSessionToken() {
        return this.randomKeyInViewStateSessionToken;
    }

    public int getRandomKeyInViewStateSessionTokenLength() {
        return this.randomKeyInViewStateSessionTokenLength;
    }

    public String getRandomKeyInViewStateSessionTokenSecureRandomClass() {
        return this.randomKeyInViewStateSessionTokenSecureRandomClass;
    }

    public String getRandomKeyInViewStateSessionTokenSecureRandomProvider() {
        return this.randomKeyInViewStateSessionTokenSecureRandomProvider;
    }

    public String getRandomKeyInViewStateSessionTokenSecureRandomAlgorithm() {
        return this.randomKeyInViewStateSessionTokenSecureRandomAlgorithm;
    }

    public String getRandomKeyInCsrfSessionToken() {
        return this.randomKeyInCsrfSessionToken;
    }

    public boolean isSerializeStateInSession() {
        return this.serializeStateInSession;
    }

    public boolean isCompressStateInSession() {
        return this.compressStateInSession;
    }

    public boolean isUseFlashScopePurgeViewsInSession() {
        return this.useFlashScopePurgeViewsInSession;
    }

    public boolean isAutocompleteOffViewState() {
        return this.autocompleteOffViewState;
    }

    public long getResourceMaxTimeExpires() {
        return this.resourceMaxTimeExpires;
    }

    public boolean isLazyLoadConfigObjects() {
        return this.lazyLoadConfigObjects;
    }

    public String getElResolverComparator() {
        return this.elResolverComparator;
    }

    public String getElResolverPredicate() {
        return this.elResolverPredicate;
    }

    public int getViewIdCacheSize() {
        return this.viewIdCacheSize;
    }

    public boolean isBeanBeforeJsfValidation() {
        return this.beanBeforeJsfValidation;
    }

    public String getRandomKeyInWebsocketSessionToken() {
        return this.randomKeyInWebsocketSessionToken;
    }

    public String getFacesInitPlugins() {
        return this.facesInitPlugins;
    }

    public boolean isInitializeSkipJarFacesConfigScan() {
        return this.initializeSkipJarFacesConfigScan;
    }

    public String getExpressionFactory() {
        return this.expressionFactory;
    }

    public String getCheckIdProductionMode() {
        return this.checkIdProductionMode;
    }

    public boolean isPartialStateSaving() {
        return this.partialStateSaving;
    }

    public String[] getFullStateSavingViewIds() {
        return this.fullStateSavingViewIds;
    }

    public int getFaceletsBufferSize() {
        return this.faceletsBufferSize;
    }

    public boolean isMarkInitialStateWhenApplyBuildView() {
        return this.markInitialStateWhenApplyBuildView;
    }

    public String[] getViewSuffix() {
        return this.viewSuffix;
    }

    public String[] getFaceletsViewMappings() {
        return this.faceletsViewMappings;
    }

    public String getFaceletsViewSuffix() {
        return this.faceletsViewSuffix;
    }

    public boolean isViewIdExistsCacheEnabled() {
        return this.viewIdExistsCacheEnabled;
    }

    public boolean isViewIdProtectedCacheEnabled() {
        return this.viewIdProtectedCacheEnabled;
    }

    public boolean isViewIdDeriveCacheEnabled() {
        return this.viewIdDeriveCacheEnabled;
    }

    public ELExpressionCacheMode getELExpressionCacheMode() {
        return this.elExpressionCacheMode;
    }

    public boolean isWrapTagExceptionsAsContextAware() {
        return this.wrapTagExceptionsAsContextAware;
    }

    public boolean isResourceCacheLastModified() {
        return this.resourceCacheLastModified;
    }

    public boolean isLogWebContextParams() {
        return this.logWebContextParams;
    }

    public int getWebsocketMaxConnections() {
        return this.websocketMaxConnections;
    }

    public boolean isRenderClientBehaviorScriptsAsString() {
        return this.renderClientBehaviorScriptsAsString;
    }

    public boolean isAlwaysForceSessionCreation() {
        return this.alwaysForceSessionCreation;
    }

    public ProjectStage getProjectStage() {
        return this.projectStage;
    }

    public ResourceBundle.Control getResourceBundleControl() {
        return this.resourceBundleControl;
    }

    public boolean isAutomaticExtensionlessMapping() {
        return this.automaticExtensionlessMapping;
    }

    public Integer getNumberOfClientWindows() {
        return this.numberOfClientWindows;
    }

    public boolean isElResolverTracing() {
        return this.elResolverTracing;
    }

    public List<String> getExceptionTypesToIgnoreInLogging() {
        return this.exceptionTypesToIgnoreInLogging;
    }

    static {
        boolean riImplAvailable;
        boolean myfacesImplAvailable;
        APPLICATION_MAP_PARAM_NAME = MyfacesConfig.class.getName();
        NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION_DEFAULT = 4;
        CLIENT_VIEW_STATE_TIMEOUT_DEFAULT = 0L;
        CACHE_EL_EXPRESSIONS_DEFAULT = ELExpressionCacheMode.noCache.name();
        INJECTION_PROVIDER = InjectionProvider.class.getName();
        WEBSOCKET_MAX_CONNECTIONS_DEFAULT = 5000;
        try {
            ClassUtils.classForName("org.apache.myfaces.application.ApplicationImpl");
            myfacesImplAvailable = true;
        }
        catch (ClassNotFoundException e) {
            myfacesImplAvailable = false;
        }
        MYFACES_IMPL_AVAILABLE = myfacesImplAvailable;
        try {
            ClassUtils.classForName("com.sun.faces.application.ApplicationImpl");
            riImplAvailable = true;
        }
        catch (ClassNotFoundException e) {
            riImplAvailable = false;
        }
        RI_IMPL_AVAILABLE = riImplAvailable;
    }
}

