/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader.provisining;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.openejb.loader.provisining.ArchiveResolver;

public class HttpResolver
implements ArchiveResolver {
    private static final int CONNECT_TIMEOUT = 10000;

    @Override
    public String prefix() {
        return "http";
    }

    @Override
    public InputStream resolve(String location) {
        try {
            URL url = new URL(location);
            for (Proxy proxy : ProxySelector.getDefault().select(url.toURI())) {
                try {
                    URLConnection urlConnection = url.openConnection(proxy);
                    urlConnection.setConnectTimeout(10000);
                    return urlConnection.getInputStream();
                }
                catch (IOException iOException) {
                }
            }
        }
        catch (MalformedURLException | URISyntaxException exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String name(String rawLocation) {
        return HttpResolver.lastPart(rawLocation.replace(':', '/'));
    }

    public static String lastPart(String location) {
        int idx = location.lastIndexOf(47);
        if (idx <= 0 && (idx = location.lastIndexOf(58)) <= 0) {
            return location;
        }
        return location.substring(idx + 1, location.length());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[timeout=10000ms]";
    }
}

