/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.openejb.loader.SystemInstance;

public class FileUtils {
    private File home;

    private FileUtils(String homeDir, String defaultDir) {
        this(homeDir, defaultDir, SystemInstance.get().getProperties());
    }

    public FileUtils(String homeDir, String defaultDir, Hashtable env) {
        String homePath = (String)env.get(homeDir);
        if (homePath == null) {
            homePath = (String)env.get(defaultDir);
        }
        if (homePath == null) {
            homePath = System.getProperty("user.dir");
        }
        this.home = new File(homePath);
        if (!this.home.exists() || this.home.exists() && !this.home.isDirectory()) {
            homePath = System.getProperty("user.dir");
            this.home = new File(homePath);
        }
        try {
            this.home = this.home.getCanonicalFile();
        }
        catch (IOException e) {
            this.home = this.home.getAbsoluteFile();
        }
    }

    public File getDirectory(String path) throws IOException {
        return this.getDirectory(path, false);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileUtils)) {
            return false;
        }
        FileUtils that = (FileUtils)obj;
        return this.getDirectory().equals(that.getDirectory());
    }

    public File getDirectory(String path, boolean create) throws IOException {
        File dir;
        block5: {
            dir = new File(this.home, path);
            if (!(dir = dir.getCanonicalFile()).exists() && create) {
                try {
                    if (!dir.mkdirs()) {
                        throw new IOException("Cannot create the directory " + dir.getPath());
                    }
                    break block5;
                }
                catch (SecurityException e) {
                    throw new IOException("Permission denied: Cannot create the directory " + dir.getPath() + " : " + e.getMessage());
                }
            }
            if (dir.exists() && !dir.isDirectory()) {
                throw new IOException("The path specified is not a valid directory: " + dir.getPath());
            }
        }
        return dir;
    }

    public File getDirectory() {
        return this.home;
    }

    public void setDirectory(File dir) {
        this.home = dir;
    }

    public File getFile(String path) throws IOException {
        return this.getFile(path, true);
    }

    public File getFile(String path, boolean validate) throws IOException {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.home, path);
        }
        if (validate && !file.exists()) {
            throw new FileNotFoundException("The path specified is not a valid file: " + file.getPath());
        }
        if (validate && file.isDirectory()) {
            throw new FileNotFoundException("The path specified is a directory, not a file: " + file.getPath());
        }
        return file;
    }

    public static File createTempDirectory(String pathPrefix) throws IOException {
        for (int maxAttempts = 100; maxAttempts > 0; --maxAttempts) {
            String path = pathPrefix + ThreadLocalRandom.current().nextLong();
            File tmpDir = new File(path);
            if (tmpDir.exists() || !tmpDir.mkdirs()) continue;
            return tmpDir;
        }
        throw new IOException("Cannot create temporary directory at: " + pathPrefix);
    }

    public static File createTempDirectory() throws IOException {
        String prefix = System.getProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "openejb";
        return FileUtils.createTempDirectory(prefix);
    }
}

