/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.ClassDiscoveryFilter;
import org.apache.xbean.osgi.bundle.util.DiscoveryRange;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleClassFinder {
    private static final Logger logger = LoggerFactory.getLogger(BundleClassFinder.class);
    public static final ClassDiscoveryFilter FULL_CLASS_DISCOVERY_FILTER = new DummyDiscoveryFilter();
    public static final ClassDiscoveryFilter IMPORTED_PACKAGE_EXCLUSIVE_FILTER = new NonImportedPackageDiscoveryFilter();
    protected static final String EXT = ".class";
    protected static final String PATTERN = "*.class";
    protected Bundle bundle;
    protected PackageAdmin packageAdmin;
    private Map<Bundle, Set<String>> classMap;
    protected ClassDiscoveryFilter discoveryFilter;

    public BundleClassFinder(PackageAdmin packageAdmin, Bundle bundle) {
        this(packageAdmin, bundle, FULL_CLASS_DISCOVERY_FILTER);
    }

    public BundleClassFinder(PackageAdmin packageAdmin, Bundle bundle, ClassDiscoveryFilter discoveryFilter) {
        this.packageAdmin = packageAdmin;
        this.bundle = BundleUtils.unwrapBundle(bundle);
        this.discoveryFilter = discoveryFilter;
    }

    public List<Class<?>> loadClasses(Set<String> classes) {
        ArrayList loadedClasses = new ArrayList(classes.size());
        for (String clazz : classes) {
            try {
                loadedClasses.add(this.bundle.loadClass(clazz));
            }
            catch (Exception exception) {}
        }
        return loadedClasses;
    }

    public Set<String> find() {
        Bundle[] fragments;
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        this.classMap = new HashMap<Bundle, Set<String>>();
        if (this.discoveryFilter.rangeDiscoveryRequired(DiscoveryRange.IMPORT_PACKAGES)) {
            this.scanImportPackages(classes, this.bundle, this.bundle);
        }
        if (this.discoveryFilter.rangeDiscoveryRequired(DiscoveryRange.REQUIRED_BUNDLES)) {
            this.scanRequireBundles(classes, this.bundle);
        }
        if (this.discoveryFilter.rangeDiscoveryRequired(DiscoveryRange.BUNDLE_CLASSPATH)) {
            this.scanBundleClassPath(classes, this.bundle);
        }
        if (this.discoveryFilter.rangeDiscoveryRequired(DiscoveryRange.FRAGMENT_BUNDLES) && (fragments = this.packageAdmin.getFragments(this.bundle)) != null) {
            for (Bundle fragment : fragments) {
                this.scanImportPackages(classes, this.bundle, fragment);
                this.scanRequireBundles(classes, fragment);
                this.scanBundleClassPath(classes, fragment);
            }
        }
        this.classMap.clear();
        return classes;
    }

    protected boolean isClassAcceptable(String name, InputStream in) throws IOException {
        return true;
    }

    protected boolean isClassAcceptable(URL url) {
        return true;
    }

    protected BundleClassFinder createSubBundleClassFinder(PackageAdmin packageAdmin, Bundle bundle, ClassDiscoveryFilter classDiscoveryFilter) {
        return new BundleClassFinder(packageAdmin, bundle, classDiscoveryFilter);
    }

    protected String toJavaStyleClassName(String name) {
        if (name.endsWith(EXT)) {
            name = name.substring(0, name.length() - EXT.length());
        }
        name = name.replace('/', '.');
        return name;
    }

    protected String toJavaStylePackageName(String className) {
        int iLastDotIndex;
        if (className.endsWith(EXT)) {
            className = className.substring(0, className.length() - EXT.length());
        }
        if ((iLastDotIndex = (className = className.replace('/', '.')).lastIndexOf(46)) != -1) {
            return className.substring(0, iLastDotIndex);
        }
        return "";
    }

    private Set<String> findAllClasses(Bundle bundle, ClassDiscoveryFilter userClassDiscoveryFilter, Set<String> exportedPackageNames) {
        Set<String> allClasses = this.classMap.get(bundle);
        if (allClasses == null) {
            BundleClassFinder finder = this.createSubBundleClassFinder(this.packageAdmin, bundle, new ImportExclusivePackageDiscoveryFilterAdapter(userClassDiscoveryFilter, exportedPackageNames));
            allClasses = finder.find();
            this.classMap.put(bundle, allClasses);
        }
        return allClasses;
    }

    private Set<String> findAllClasses(Bundle bundle, String packageName) {
        Set<String> allClasses = this.classMap.get(bundle);
        if (allClasses == null) {
            BundleClassFinder finder = this.createSubBundleClassFinder(this.packageAdmin, bundle, new ImportExclusivePackageDiscoveryFilter(packageName));
            allClasses = finder.find();
            this.classMap.put(bundle, allClasses);
        }
        return allClasses;
    }

    private void scanImportPackages(Collection<String> classes, Bundle host, Bundle fragment) {
        BundleDescription description = new BundleDescription(fragment.getHeaders());
        List<BundleDescription.ImportPackage> imports = description.getExternalImports();
        for (BundleDescription.ImportPackage packageImport : imports) {
            ExportedPackage[] exports;
            Bundle wiredBundle;
            String packageName = packageImport.getName();
            if (!this.discoveryFilter.packageDiscoveryRequired(packageName) || (wiredBundle = this.isWired(host, exports = this.packageAdmin.getExportedPackages(packageName))) == null) continue;
            Set<String> allClasses = this.findAllClasses(wiredBundle, packageName);
            classes.addAll(allClasses);
        }
    }

    private void scanRequireBundles(Collection<String> classes, Bundle bundle) {
        BundleDescription description = new BundleDescription(bundle.getHeaders());
        List<BundleDescription.RequireBundle> requiredBundleList = description.getRequireBundle();
        for (BundleDescription.RequireBundle requiredBundle : requiredBundleList) {
            RequiredBundle[] requiredBundles = this.packageAdmin.getRequiredBundles(requiredBundle.getName());
            Bundle wiredBundle = this.isWired(bundle, requiredBundles);
            if (wiredBundle == null) continue;
            BundleDescription wiredBundleDescription = new BundleDescription(wiredBundle.getHeaders());
            List<BundleDescription.ExportPackage> exportPackages = wiredBundleDescription.getExportPackage();
            HashSet<String> exportedPackageNames = new HashSet<String>();
            for (BundleDescription.ExportPackage exportPackage : exportPackages) {
                exportedPackageNames.add(exportPackage.getName());
            }
            Set<String> allClasses = this.findAllClasses(wiredBundle, this.discoveryFilter, exportedPackageNames);
            classes.addAll(allClasses);
        }
    }

    private void scanBundleClassPath(Collection<String> resources, Bundle bundle) {
        BundleDescription description = new BundleDescription(bundle.getHeaders());
        List<BundleDescription.HeaderEntry> paths = description.getBundleClassPath();
        if (paths.isEmpty()) {
            this.scanDirectory(resources, bundle, "/");
        } else {
            for (BundleDescription.HeaderEntry path : paths) {
                String name = path.getName();
                if (name.equals(".") || name.equals("/")) {
                    this.scanDirectory(resources, bundle, "/");
                    continue;
                }
                if (name.endsWith(".jar") || name.endsWith(".zip")) {
                    this.scanZip(resources, bundle, name);
                    continue;
                }
                this.scanDirectory(resources, bundle, "/" + name);
            }
        }
    }

    private void scanDirectory(Collection<String> classes, Bundle bundle, String basePath) {
        if (!this.discoveryFilter.directoryDiscoveryRequired(basePath = this.addSlash(basePath))) {
            return;
        }
        Enumeration e = bundle.findEntries(basePath, PATTERN, true);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                String entryName = u.getPath().substring(basePath.length());
                if (!this.discoveryFilter.packageDiscoveryRequired(this.toJavaStylePackageName(entryName)) || !this.isClassAcceptable(u)) continue;
                classes.add(this.toJavaStyleClassName(entryName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanZip(Collection<String> classes, Bundle bundle, String zipName) {
        if (!this.discoveryFilter.jarFileDiscoveryRequired(zipName)) {
            return;
        }
        URL zipEntry = bundle.getEntry(zipName);
        if (zipEntry == null) {
            return;
        }
        ZipInputStream in = null;
        try {
            ZipEntry entry;
            in = new ZipInputStream(zipEntry.openStream());
            while ((entry = in.getNextEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(EXT) || !this.discoveryFilter.packageDiscoveryRequired(this.toJavaStylePackageName(name)) || !this.isClassAcceptable(name, in)) continue;
                classes.add(this.toJavaStyleClassName(name));
            }
        }
        catch (IOException ignore) {
            logger.warn("Fail to check zip file " + zipName, (Throwable)ignore);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String addSlash(String name) {
        if (!name.endsWith("/")) {
            name = name + "/";
        }
        return name;
    }

    protected Bundle isWired(Bundle bundle, ExportedPackage[] exports) {
        if (exports != null) {
            for (ExportedPackage exportedPackage : exports) {
                Bundle[] importingBundles = exportedPackage.getImportingBundles();
                if (importingBundles == null) continue;
                for (Bundle importingBundle : importingBundles) {
                    if (importingBundle != bundle) continue;
                    return exportedPackage.getExportingBundle();
                }
            }
        }
        return null;
    }

    protected Bundle isWired(Bundle bundle, RequiredBundle[] requiredBundles) {
        if (requiredBundles != null) {
            for (RequiredBundle requiredBundle : requiredBundles) {
                Bundle[] requiringBundles = requiredBundle.getRequiringBundles();
                if (requiringBundles == null) continue;
                for (Bundle requiringBundle : requiringBundles) {
                    if (requiringBundle != bundle) continue;
                    return requiredBundle.getBundle();
                }
            }
        }
        return null;
    }

    private static class ImportExclusivePackageDiscoveryFilterAdapter
    implements ClassDiscoveryFilter {
        private Set<String> acceptedPackageNames;
        private ClassDiscoveryFilter classDiscoveryFilter;

        public ImportExclusivePackageDiscoveryFilterAdapter(ClassDiscoveryFilter classDiscoveryFilter, Set<String> acceptedPackageNames) {
            this.classDiscoveryFilter = classDiscoveryFilter;
            this.acceptedPackageNames = acceptedPackageNames;
        }

        @Override
        public boolean directoryDiscoveryRequired(String url) {
            return true;
        }

        @Override
        public boolean jarFileDiscoveryRequired(String url) {
            return true;
        }

        @Override
        public boolean packageDiscoveryRequired(String packageName) {
            return this.acceptedPackageNames.contains(packageName) && this.classDiscoveryFilter.packageDiscoveryRequired(packageName);
        }

        @Override
        public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
            return !discoveryRange.equals((Object)DiscoveryRange.IMPORT_PACKAGES);
        }
    }

    private static class ImportExclusivePackageDiscoveryFilter
    implements ClassDiscoveryFilter {
        private String expectedPckageName;

        public ImportExclusivePackageDiscoveryFilter(String expectedPckageName) {
            this.expectedPckageName = expectedPckageName;
        }

        @Override
        public boolean directoryDiscoveryRequired(String url) {
            return true;
        }

        @Override
        public boolean jarFileDiscoveryRequired(String url) {
            return true;
        }

        @Override
        public boolean packageDiscoveryRequired(String packageName) {
            return this.expectedPckageName.equals(packageName);
        }

        @Override
        public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
            return !discoveryRange.equals((Object)DiscoveryRange.IMPORT_PACKAGES);
        }
    }

    public static class NonImportedPackageDiscoveryFilter
    implements ClassDiscoveryFilter {
        @Override
        public boolean directoryDiscoveryRequired(String url) {
            return true;
        }

        @Override
        public boolean jarFileDiscoveryRequired(String url) {
            return true;
        }

        @Override
        public boolean packageDiscoveryRequired(String packageName) {
            return true;
        }

        @Override
        public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
            return !discoveryRange.equals((Object)DiscoveryRange.IMPORT_PACKAGES);
        }
    }

    public static class DummyDiscoveryFilter
    implements ClassDiscoveryFilter {
        @Override
        public boolean directoryDiscoveryRequired(String url) {
            return true;
        }

        @Override
        public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
            return true;
        }

        @Override
        public boolean jarFileDiscoveryRequired(String url) {
            return true;
        }

        @Override
        public boolean packageDiscoveryRequired(String packageName) {
            return true;
        }
    }
}

