/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.NotEmpty;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NotEmptyValidator
implements ConstraintValidator<NotEmpty, Object> {
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) > 0;
        }
        try {
            Method isEmptyMethod = value.getClass().getMethod("isEmpty", new Class[0]);
            if (isEmptyMethod != null) {
                return !Boolean.TRUE.equals(isEmptyMethod.invoke(value, new Object[0]));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException isEmptyMethod) {
            // empty catch block
        }
        String s = value.toString();
        return s != null && !s.isEmpty();
    }
}

