/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.plugins;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.security.limit.ConnectionLimitProvider;
import org.apache.qpid.server.security.limit.ConnectionLimiter;
import org.apache.qpid.server.user.connection.limits.config.RuleSetCreator;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionLimitProvider<X extends AbstractConnectionLimitProvider<X>>
extends AbstractConfiguredObject<X>
implements ConnectionLimitProvider<X> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConnectionLimitProvider.class);
    private static final String FAILED_CREATE_NEW_PROVIDER = "Failed to create a new connection limit provider";
    private final AtomicReference<RuleSetCreator> _creator = new AtomicReference<Object>(null);

    abstract RuleSetCreator newRuleSetCreator();

    public AbstractConnectionLimitProvider(ConfiguredObject<?> parent, Map<String, Object> attributes) {
        super(parent, attributes);
    }

    public ConnectionLimiter getConnectionLimiter() {
        return Optional.ofNullable(this._creator.get()).map(provider -> provider.getLimiter(this.getName())).orElseGet(ConnectionLimiter::noLimits);
    }

    public void onValidate() {
        super.onValidate();
        if (!this.isDurable()) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " must be durable");
        }
    }

    protected void validateOnCreate() {
        try {
            if (this._creator.get() == null) {
                this._creator.compareAndSet(null, this.newRuleSetCreator());
            }
        }
        catch (RuntimeException e) {
            throw new IllegalConfigurationException(FAILED_CREATE_NEW_PROVIDER, (Throwable)e);
        }
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    CompletableFuture<Void> activate() {
        RuleSetCreator creator;
        boolean isManagementMode = ((SystemConfig)this.getModel().getAncestor(SystemConfig.class, (ConfiguredObject)this)).isManagementMode();
        if (State.ERRORED == this.getState()) {
            creator = null;
            this._creator.set(null);
        } else {
            creator = this._creator.get();
        }
        try {
            if (creator == null) {
                this._creator.compareAndSet(null, this.newRuleSetCreator());
            }
            this.setState(isManagementMode ? State.QUIESCED : State.ACTIVE);
        }
        catch (RuntimeException e) {
            LOGGER.debug(String.format("Connection limit provider '%s' can not be activated because of the error: ", this.getName()), (Throwable)e);
            this.setState(State.ERRORED);
            if (isManagementMode) {
                LOGGER.warn(String.format("Failed to activate connection limit provider: %s", this.getName()));
            }
            throw e;
        }
        return CompletableFuture.completedFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ACTIVE, State.STOPPED, State.DELETED, State.UNAVAILABLE}, desiredState=State.ERRORED)
    CompletableFuture<Void> error() {
        this._creator.set(null);
        this.setState(State.ERRORED);
        return CompletableFuture.completedFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    private CompletableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return CompletableFuture.completedFuture(null);
    }

    protected void forceNewRuleSetCreator() {
        try {
            this._creator.set(this.newRuleSetCreator());
        }
        catch (RuntimeException e) {
            this._creator.set(null);
            throw new IllegalConfigurationException(FAILED_CREATE_NEW_PROVIDER, (Throwable)e);
        }
    }

    protected RuleSetCreator creator() {
        return this._creator.get();
    }

    static {
        Handler.register();
    }
}

