/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.plugin.MessageFormat;
import org.apache.qpid.server.plugin.QpidServiceLoader;

public class MessageFormatRegistry {
    private static final Map<Integer, MessageFormat<? extends ServerMessage<?>>> INPUT_CONVERTERS = new HashMap();
    private static final Map<Class<? extends ServerMessage<?>>, MessageFormat<? extends ServerMessage<?>>> OUTPUT_CONVERTERS = new HashMap();

    public static MessageFormat<? extends ServerMessage<?>> getFormat(int format) {
        return INPUT_CONVERTERS.get(format);
    }

    public static MessageFormat<? extends ServerMessage<?>> getFormat(ServerMessage<?> message) {
        return OUTPUT_CONVERTERS.get(message.getClass());
    }

    static {
        for (MessageFormat converter : new QpidServiceLoader().instancesOf(MessageFormat.class)) {
            INPUT_CONVERTERS.put(converter.getSupportedFormat(), converter);
            OUTPUT_CONVERTERS.put(converter.getMessageClass(), converter);
        }
    }
}

