/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.logging;

import com.sleepycat.je.cleaner.Cleaner;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.qpid.server.store.berkeleydb.StandardEnvironmentConfiguration;
import org.apache.qpid.server.util.ParameterizedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLoggingHandler
extends Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Slf4jLoggingHandler.class);
    private static final String SLF4J_JUL_LOGGER_ADAPTER = "org.slf4j.jul.JDK14LoggerAdapter";
    private static final boolean JUL_LOADED = Slf4jLoggingHandler.isSlf4jJdk14Loaded();
    private static final Pattern NOT_DELETED_DUE_TO_PROTECTION = Pattern.compile("Cleaner has ([0-9]+) files not deleted because they are protected.*");
    private static final ThreadLocal<AtomicBoolean> LOGGER_CALLED = ThreadLocal.withInitial(AtomicBoolean::new);
    private final ConcurrentMap<String, Logger> _loggers = new ConcurrentHashMap<String, Logger>();
    private final int _logHandlerCleanerProtectedFilesLimit;
    private final String _prefix;
    private final Set<java.util.logging.Logger> _overridedenLoggers = new HashSet<java.util.logging.Logger>();
    private static final MappedLevel ERROR = new MappedLevel(){

        @Override
        public boolean isEnabled(Logger logger) {
            return logger.isErrorEnabled();
        }

        @Override
        public void log(Logger logger, String message) {
            logger.error(message);
        }
    };
    private static final MappedLevel WARN = new MappedLevel(){

        @Override
        public boolean isEnabled(Logger logger) {
            return logger.isWarnEnabled();
        }

        @Override
        public void log(Logger logger, String message) {
            logger.warn(message);
        }
    };
    private static final MappedLevel INFO = new MappedLevel(){

        @Override
        public boolean isEnabled(Logger logger) {
            return logger.isInfoEnabled();
        }

        @Override
        public void log(Logger logger, String message) {
            logger.info(message);
        }
    };
    private static final MappedLevel DEBUG = new MappedLevel(){

        @Override
        public boolean isEnabled(Logger logger) {
            return logger.isDebugEnabled();
        }

        @Override
        public void log(Logger logger, String message) {
            logger.debug(message);
        }
    };
    private static final MappedLevel TRACE = new MappedLevel(){

        @Override
        public boolean isEnabled(Logger logger) {
            return logger.isTraceEnabled();
        }

        @Override
        public void log(Logger logger, String message) {
            logger.trace(message);
        }
    };
    private static final Map<Level, MappedLevel> LEVEL_MAP;

    public Slf4jLoggingHandler(StandardEnvironmentConfiguration configuration) {
        this._prefix = configuration.getName();
        this.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return Slf4jLoggingHandler.this._prefix + " " + this.formatMessage(record);
            }
        });
        this._logHandlerCleanerProtectedFilesLimit = configuration.getFacadeParameter(Integer.class, "qpid.bdb.je.cleaner_protected_files_limit", 10);
        Map<String, String> levelOverrides = configuration.getFacadeParameter(Map.class, ParameterizedTypes.MAP_OF_STRING_STRING, "qpid.bdb.je.jul_logger_level_override", Collections.emptyMap());
        this.applyJulLoggerLevelOverrides(levelOverrides);
    }

    private void applyJulLoggerLevelOverrides(Map<String, String> julLoggerLevelOverrides) {
        julLoggerLevelOverrides.forEach((julLoggerName, julDesiredLevelString) -> {
            java.util.logging.Logger julLogger;
            Level julDesiredLevel;
            try {
                julDesiredLevel = Level.parse(julDesiredLevelString);
            }
            catch (IllegalArgumentException e) {
                julDesiredLevel = null;
                LOGGER.warn("Unrecognised JUL level name '{}' in JUL override for logger name '{}'", julDesiredLevelString, julLoggerName);
            }
            if (!(julDesiredLevel == null || (julLogger = java.util.logging.Logger.getLogger(julLoggerName)).getLevel() != null && julLogger.isLoggable(julDesiredLevel))) {
                this._overridedenLoggers.add(julLogger);
                julLogger.setLevel(julDesiredLevel);
                LOGGER.warn("JUL logger {} overridden to level {}", (Object)julLogger.getName(), (Object)julLogger.getLevel());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        Logger logger;
        MappedLevel level = this.convertLevel(record);
        if (level.isEnabled(logger = this.getLogger(record.getLoggerName()))) {
            String message;
            Formatter formatter = this.getFormatter();
            try {
                message = formatter.format(record);
            }
            catch (RuntimeException e) {
                this.reportError(null, e, 5);
                return;
            }
            try {
                if (!JUL_LOADED) {
                    level.log(logger, message);
                } else if (LOGGER_CALLED.get().compareAndSet(false, true)) {
                    level.log(logger, message);
                }
            }
            catch (RuntimeException e) {
                this.reportError(null, e, 1);
            }
            finally {
                LOGGER_CALLED.get().set(false);
            }
        }
    }

    private Logger getLogger(String loggerName) {
        Logger logger = (Logger)this._loggers.get(loggerName);
        if (logger == null) {
            logger = LoggerFactory.getLogger((String)loggerName);
            this._loggers.putIfAbsent(loggerName, logger);
        }
        return logger;
    }

    private MappedLevel convertLevel(LogRecord record) {
        Matcher matcher;
        if (record.getLevel() == Level.SEVERE && this.isJECleaner(record) && record.getMessage().startsWith("Average cleaner backlog has grown from")) {
            return INFO;
        }
        if (record.getLevel() == Level.WARNING && this.isJECleaner(record) && (matcher = NOT_DELETED_DUE_TO_PROTECTION.matcher(record.getMessage())).matches() && matcher.groupCount() > 0 && Integer.parseInt(matcher.group(1)) < this._logHandlerCleanerProtectedFilesLimit) {
            return DEBUG;
        }
        return this.convertLevel(record.getLevel());
    }

    private boolean isJECleaner(LogRecord record) {
        return Cleaner.class.getName().equals(record.getLoggerName());
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        MappedLevel mappedLevel = this.convertLevel(record.getLevel());
        return mappedLevel.isEnabled(this.getLogger(record.getLoggerName()));
    }

    private MappedLevel convertLevel(Level level) {
        MappedLevel result = LEVEL_MAP.get(level);
        if (result == null) {
            result = level.intValue() >= Level.SEVERE.intValue() ? ERROR : (level.intValue() >= Level.WARNING.intValue() ? WARN : (level.intValue() >= Level.CONFIG.intValue() ? DEBUG : TRACE));
        }
        return result;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this._overridedenLoggers.clear();
    }

    public static boolean isSlf4jJdk14Loaded() {
        try {
            Class.forName(SLF4J_JUL_LOGGER_ADAPTER);
            return true;
        }
        catch (ClassNotFoundException e) {
            String message = "Could not find class org.slf4j.jul.JDK14LoggerAdapter, slf4j-jdk14 not available";
            LOGGER.debug("Could not find class org.slf4j.jul.JDK14LoggerAdapter, slf4j-jdk14 not available", (Throwable)e);
            return false;
        }
    }

    static {
        HashMap<Level, MappedLevel> map = new HashMap<Level, MappedLevel>();
        map.put(Level.SEVERE, ERROR);
        map.put(Level.WARNING, WARN);
        map.put(Level.INFO, DEBUG);
        map.put(Level.CONFIG, DEBUG);
        map.put(Level.FINE, TRACE);
        map.put(Level.FINER, TRACE);
        map.put(Level.FINEST, TRACE);
        map.put(Level.ALL, TRACE);
        LEVEL_MAP = Collections.unmodifiableMap(map);
    }

    private static interface MappedLevel {
        public boolean isEnabled(Logger var1);

        public void log(Logger var1, String var2);
    }
}

