/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.WriteLockInfo;

public class LockResult {
    private LockGrantType grant;
    private WriteLockInfo wli;

    public LockResult(LockGrantType grant, WriteLockInfo wli) {
        this.grant = grant;
        this.wli = wli;
    }

    public LockGrantType getLockGrant() {
        return this.grant;
    }

    public WriteLockInfo getWriteLockInfo() {
        return this.wli;
    }

    public void setAbortInfo(long abortLsn, boolean abortKD, byte[] abortKey, byte[] abortData, long abortVLSN, int abortExpiration, boolean abortExpirationInHours, DatabaseImpl db) {
        if (this.wli != null && this.wli.getNeverLocked()) {
            if (abortLsn != -1L) {
                this.wli.setAbortLsn(abortLsn);
                this.wli.setAbortKnownDeleted(abortKD);
                this.wli.setAbortKey(abortKey);
                this.wli.setAbortData(abortData);
                this.wli.setAbortVLSN(abortVLSN);
                this.wli.setAbortExpiration(abortExpiration, abortExpirationInHours);
                this.wli.setDb(db);
            }
            this.wli.setNeverLocked(false);
        }
    }

    public void copyWriteLockInfo(WriteLockInfo fromInfo) {
        if (fromInfo != null && this.wli != null) {
            this.wli.copyAllInfo(fromInfo);
            this.wli.setNeverLocked(false);
        }
    }
}

