/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.shared.common.error.StandardException;

class DropIndexConstantAction
extends IndexConstantAction {
    private String fullIndexName;
    private long tableConglomerateId;

    DropIndexConstantAction(String string, String string2, String string3, String string4, UUID uUID, long l) {
        super(uUID, string2, string3, string4);
        this.fullIndexName = string;
        this.tableConglomerateId = l;
    }

    public String toString() {
        return "DROP INDEX " + this.fullIndexName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TableDescriptor tableDescriptor;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        if (this.tableConglomerateId == 0L) {
            tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
            if (tableDescriptor == null) {
                throw StandardException.newException((String)"X0X05.S", (Object[])new Object[]{this.tableName});
            }
            this.tableConglomerateId = tableDescriptor.getHeapConglomerateId();
        }
        this.lockTableForDDL(transactionController, this.tableConglomerateId, true);
        tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
        if (tableDescriptor == null) {
            throw StandardException.newException((String)"X0X05.S", (Object[])new Object[]{this.tableName});
        }
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true);
        ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.indexName, schemaDescriptor, true);
        if (conglomerateDescriptor == null) {
            throw StandardException.newException((String)"X0X99.S", (Object[])new Object[]{this.fullIndexName});
        }
        this.dropConglomerate(conglomerateDescriptor, tableDescriptor, activation, languageConnectionContext);
    }
}

