/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import org.apache.qpid.server.QpidException;

public class AMQException
extends QpidException {
    private final int _errorCode;
    private final boolean _isHardError;

    public AMQException(int errorCode, String message) {
        this(errorCode, message, null);
    }

    public AMQException(int errorCode, String msg, Throwable cause) {
        this(errorCode, true, msg, cause);
    }

    public AMQException(int errorCode, boolean isHardError, String message, Throwable cause) {
        super(message, cause);
        this._errorCode = errorCode;
        this._isHardError = isHardError;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage() + (String)(this._errorCode == 0 ? "" : " [error code: " + this._errorCode + "(" + AMQException.getDefaultDescription(this._errorCode) + ")]");
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public boolean isHardError() {
        return this._isHardError;
    }

    @Override
    public AMQException cloneForCurrentThread() {
        AMQException newAMQE;
        Class<?> amqeClass = this.getClass();
        Class[] paramClasses = new Class[]{Integer.TYPE, String.class, Throwable.class};
        Object[] params = new Object[]{this._errorCode, this.getMessage(), this};
        try {
            newAMQE = (AMQException)amqeClass.getConstructor(paramClasses).newInstance(params);
        }
        catch (Exception creationException) {
            newAMQE = new AMQException(this._errorCode, this._isHardError, this.getMessage(), this);
        }
        return newAMQE;
    }

    private static String getDefaultDescription(int errorCode) {
        switch (errorCode) {
            case 200: {
                return "reply success";
            }
            case 310: {
                return "not delivered";
            }
            case 311: {
                return "message too large";
            }
            case 312: {
                return "no route";
            }
            case 313: {
                return "no consumers";
            }
            case 320: {
                return "connection forced";
            }
            case 402: {
                return "invalid path";
            }
            case 403: {
                return "access refused";
            }
            case 404: {
                return "not found";
            }
            case 405: {
                return "Already exists";
            }
            case 406: {
                return "In use";
            }
            case 407: {
                return "routing key invalid";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "argument invalid";
            }
            case 501: {
                return "frame error";
            }
            case 502: {
                return "syntax error";
            }
            case 503: {
                return "command invalid";
            }
            case 504: {
                return "channel error";
            }
            case 506: {
                return "resource error";
            }
            case 530: {
                return "not allowed";
            }
            case 540: {
                return "not implemented";
            }
            case 541: {
                return "internal error";
            }
            case 542: {
                return "invalid argument";
            }
            case 543: {
                return "client unsupported protocol";
            }
        }
        return "<<unknown>>";
    }
}

