/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class SQLToJavaValueNode
extends JavaValueNode {
    ValueNode value;
    LocalField returnsNullOnNullState;

    SQLToJavaValueNode(ValueNode valueNode, ContextManager contextManager) {
        super(contextManager);
        this.value = valueNode;
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    String getJavaTypeName() throws StandardException {
        JSQLType jSQLType = this.getJSQLType();
        if (jSQLType == null) {
            return "";
        }
        return SQLToJavaValueNode.mapToTypeID(jSQLType).getCorrespondingJavaTypeName();
    }

    @Override
    String getPrimitiveTypeName() throws StandardException {
        JSQLType jSQLType = this.getJSQLType();
        if (jSQLType == null) {
            return "";
        }
        return this.getTypeCompiler(SQLToJavaValueNode.mapToTypeID(jSQLType)).getCorrespondingPrimitiveTypeName();
    }

    @Override
    JSQLType getJSQLType() throws StandardException {
        if (this.jsqlType == null) {
            if (this.value.requiresTypeFromContext()) {
                ParameterNode parameterNode = this.value instanceof UnaryOperatorNode ? ((UnaryOperatorNode)this.value).getParameterOperand() : (ParameterNode)this.value;
                this.jsqlType = parameterNode.getJSQLType();
            } else {
                DataTypeDescriptor dataTypeDescriptor = this.value.getTypeServices();
                if (dataTypeDescriptor != null) {
                    this.jsqlType = new JSQLType(dataTypeDescriptor);
                }
            }
        }
        return this.jsqlType;
    }

    @Override
    JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.value = this.value.bindExpression(fromList, subqueryList, list);
        return this;
    }

    @Override
    DataTypeDescriptor getDataType() throws StandardException {
        return this.value.getTypeServices();
    }

    @Override
    JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.value = this.value.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.value.categorize(jBitSet, bl);
    }

    @Override
    void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.value = this.value.preprocess(n, fromList, subqueryList, predicateList);
    }

    @Override
    int getOrderableVariantType() throws StandardException {
        return this.value.getOrderableVariantType();
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateSQLValue(expressionClassBuilder, methodBuilder);
        this.generateJavaValue(expressionClassBuilder, methodBuilder);
    }

    private void generateSQLValue(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.value.generateExpression(expressionClassBuilder, methodBuilder);
    }

    private void generateJavaValue(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.isPrimitiveType() || this.mustCastToPrimitive()) {
            String string = this.value.getTypeCompiler().getCorrespondingPrimitiveTypeName();
            String[] stringArray = new String[]{this.getSQLValueInterfaceName()};
            MethodBuilder methodBuilder2 = expressionClassBuilder.newGeneratedFun(string, 2, stringArray);
            methodBuilder2.getParameter(0);
            if (this.returnsNullOnNullState != null) {
                this.generateReturnsNullOnNullCheck(methodBuilder2);
            } else {
                methodBuilder2.dup();
                methodBuilder2.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
                methodBuilder2.push(string);
                methodBuilder2.callMethod((short)184, "org.apache.derby.impl.sql.execute.BaseActivation", "nullToPrimitiveTest", "void", 2);
            }
            methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", this.value.getTypeCompiler().getPrimitiveMethodName(), string, 0);
            methodBuilder2.methodReturn();
            methodBuilder2.complete();
            methodBuilder.pushThis();
            methodBuilder.swap();
            methodBuilder.callMethod((short)182, null, methodBuilder2.getName(), string, 1);
        } else {
            if (this.returnsNullOnNullState != null) {
                this.generateReturnsNullOnNullCheck(methodBuilder);
            }
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "getObject", "java.lang.Object", 0);
            methodBuilder.cast(this.value.getTypeId().getCorrespondingJavaTypeName());
        }
    }

    private void generateReturnsNullOnNullCheck(MethodBuilder methodBuilder) {
        methodBuilder.dup();
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.services.io.Storable", "isNull", "boolean", 0);
        methodBuilder.conditionalIf();
        methodBuilder.push(true);
        methodBuilder.startElseCode();
        methodBuilder.getField(this.returnsNullOnNullState);
        methodBuilder.completeConditional();
        methodBuilder.setField(this.returnsNullOnNullState);
    }

    private String getSQLValueInterfaceName() throws StandardException {
        return this.value.getTypeCompiler().interfaceName();
    }

    ValueNode getSQLValueNode() {
        return this.value;
    }

    @Override
    Object getConstantValueAsObject() throws StandardException {
        return this.value.getConstantValueAsObject();
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.value != null) {
            this.value = (ValueNode)this.value.accept(visitor);
        }
    }
}

