/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.Version;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.model.ArtifactProvider;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.ByteArraySerializer;
import opennlp.tools.util.model.DictionarySerializer;
import opennlp.tools.util.model.GenericModelSerializer;
import opennlp.tools.util.model.PropertiesSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public abstract class BaseModel
implements ArtifactProvider,
Serializable {
    private static final long serialVersionUID = -4593612444791752264L;
    protected static final String MANIFEST_ENTRY = "manifest.properties";
    protected static final String FACTORY_NAME = "factory";
    private static final String MANIFEST_VERSION_PROPERTY = "Manifest-Version";
    private static final String COMPONENT_NAME_PROPERTY = "Component-Name";
    private static final String VERSION_PROPERTY = "OpenNLP-Version";
    private static final String TIMESTAMP_PROPERTY = "Timestamp";
    private static final String LANGUAGE_PROPERTY = "Language";
    public static final String TRAINING_CUTOFF_PROPERTY = "Training-Cutoff";
    public static final String TRAINING_ITERATIONS_PROPERTY = "Training-Iterations";
    public static final String TRAINING_EVENTHASH_PROPERTY = "Training-Eventhash";
    private static final String SERIALIZER_CLASS_NAME_PREFIX = "serializer-class-";
    private Map<String, ArtifactSerializer<?>> artifactSerializers = new HashMap();
    protected Map<String, Object> artifactMap = new HashMap<String, Object>();
    protected BaseToolFactory toolFactory;
    private String componentName;
    private boolean subclassSerializersInitiated = false;
    private boolean finishedLoadingArtifacts = false;
    private boolean isLoadedFromSerialized;

    private BaseModel(String componentName, boolean isLoadedFromSerialized) {
        this.isLoadedFromSerialized = isLoadedFromSerialized;
        this.componentName = Objects.requireNonNull(componentName, "componentName must not be null!");
    }

    protected BaseModel(String componentName, String languageCode, Map<String, String> manifestInfoEntries, BaseToolFactory factory) {
        this(componentName, false);
        Objects.requireNonNull(languageCode, "languageCode must not be null");
        this.createBaseArtifactSerializers(this.artifactSerializers);
        Properties manifest = new Properties();
        manifest.setProperty(MANIFEST_VERSION_PROPERTY, "1.0");
        manifest.setProperty(LANGUAGE_PROPERTY, languageCode);
        manifest.setProperty(VERSION_PROPERTY, Version.currentVersion().toString());
        manifest.setProperty(TIMESTAMP_PROPERTY, Long.toString(System.currentTimeMillis()));
        manifest.setProperty(COMPONENT_NAME_PROPERTY, componentName);
        if (manifestInfoEntries != null) {
            for (Map.Entry<String, String> entry : manifestInfoEntries.entrySet()) {
                manifest.setProperty(entry.getKey(), entry.getValue());
            }
        }
        this.artifactMap.put(MANIFEST_ENTRY, manifest);
        this.finishedLoadingArtifacts = true;
        if (factory != null) {
            this.setManifestProperty(FACTORY_NAME, factory.getClass().getCanonicalName());
            this.artifactMap.putAll(factory.createArtifactMap());
            Map<String, String> entries = factory.createManifestEntries();
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                this.setManifestProperty(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.initializeFactory();
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException("Could not initialize tool factory. ", e);
        }
        this.loadArtifactSerializers();
    }

    protected BaseModel(String componentName, String languageCode, Map<String, String> manifestInfoEntries) {
        this(componentName, languageCode, manifestInfoEntries, null);
    }

    protected BaseModel(String componentName, InputStream in) throws IOException {
        this(componentName, true);
        this.loadModel(in);
    }

    protected BaseModel(String componentName, File modelFile) throws IOException {
        this(componentName, true);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(modelFile));){
            this.loadModel(in);
        }
    }

    protected BaseModel(String componentName, Path modelPath) throws IOException {
        this(componentName, true);
        try (InputStream in = Files.newInputStream(modelPath, new OpenOption[0]);){
            this.loadModel(in);
        }
    }

    protected BaseModel(String componentName, URL modelURL) throws IOException {
        this(componentName, true);
        try (BufferedInputStream in = new BufferedInputStream(modelURL.openStream());){
            this.loadModel(in);
        }
    }

    private void loadModel(InputStream in) throws IOException {
        Objects.requireNonNull(in, "in must not be null");
        this.createBaseArtifactSerializers(this.artifactSerializers);
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        int MODEL_BUFFER_SIZE_LIMIT = Integer.MAX_VALUE;
        in.mark(MODEL_BUFFER_SIZE_LIMIT);
        try (ZipInputStream zip = new ZipInputStream(in);){
            ZipEntry entry;
            boolean isSearchingForManifest = true;
            while ((entry = zip.getNextEntry()) != null && isSearchingForManifest) {
                if (MANIFEST_ENTRY.equals(entry.getName())) {
                    ArtifactSerializer<?> factory = this.artifactSerializers.get("properties");
                    this.artifactMap.put(entry.getName(), factory.create(zip));
                    isSearchingForManifest = false;
                }
                zip.closeEntry();
            }
            this.initializeFactory();
            this.loadArtifactSerializers();
            in.reset();
            this.finishLoadingArtifacts(in);
            this.checkArtifactMap();
        }
    }

    private void initializeFactory() throws InvalidFormatException {
        String factoryName = this.getManifestProperty(FACTORY_NAME);
        if (factoryName == null) {
            Class<? extends BaseToolFactory> factoryClass = this.getDefaultFactory();
            if (factoryClass != null) {
                this.toolFactory = BaseToolFactory.create(factoryClass, (ArtifactProvider)this);
            }
        } else {
            try {
                this.toolFactory = BaseToolFactory.create(factoryName, (ArtifactProvider)this);
            }
            catch (InvalidFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return null;
    }

    private void loadArtifactSerializers() {
        if (!this.subclassSerializersInitiated) {
            this.createArtifactSerializers(this.artifactSerializers);
        }
        this.subclassSerializersInitiated = true;
    }

    private void finishLoadingArtifacts(InputStream in) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(in);){
            ZipEntry entry;
            HashMap artifactMap = new HashMap();
            while ((entry = zip.getNextEntry()) != null) {
                String entryName = entry.getName();
                String extension = this.getEntryExtension(entryName);
                ArtifactSerializer factory = this.artifactSerializers.get(extension);
                String artifactSerializerClazzName = this.getManifestProperty(SERIALIZER_CLASS_NAME_PREFIX + entryName);
                if (artifactSerializerClazzName != null) {
                    factory = ExtensionLoader.instantiateExtension(ArtifactSerializer.class, artifactSerializerClazzName);
                }
                if (factory == null) {
                    throw new InvalidFormatException("Unknown artifact format: " + extension);
                }
                artifactMap.put(entryName, factory.create(zip));
                zip.closeEntry();
            }
            this.artifactMap.putAll(artifactMap);
            this.finishedLoadingArtifacts = true;
        }
    }

    private String getEntryExtension(String entry) throws InvalidFormatException {
        int extensionIndex = entry.lastIndexOf(46) + 1;
        if (extensionIndex >= entry.length()) {
            throw new InvalidFormatException("Entry name must have type extension: " + entry);
        }
        return entry.substring(extensionIndex);
    }

    protected ArtifactSerializer<?> getArtifactSerializer(String resourceName) {
        try {
            return this.artifactSerializers.get(this.getEntryExtension(resourceName));
        }
        catch (InvalidFormatException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static Map<String, ArtifactSerializer<?>> createArtifactSerializers() {
        HashMap serializers = new HashMap();
        GenericModelSerializer.register(serializers);
        PropertiesSerializer.register(serializers);
        DictionarySerializer.register(serializers);
        serializers.put("txt", new ByteArraySerializer());
        serializers.put("html", new ByteArraySerializer());
        return serializers;
    }

    protected void createArtifactSerializers(Map<String, ArtifactSerializer<?>> serializers) {
        if (this.toolFactory != null) {
            serializers.putAll(this.toolFactory.createArtifactSerializersMap());
        }
    }

    private void createBaseArtifactSerializers(Map<String, ArtifactSerializer<?>> serializers) {
        serializers.putAll(BaseModel.createArtifactSerializers());
    }

    protected void validateArtifactMap() throws InvalidFormatException {
        if (!(this.artifactMap.get(MANIFEST_ENTRY) instanceof Properties)) {
            throw new InvalidFormatException("Missing the manifest.properties!");
        }
        String versionString = this.getManifestProperty(VERSION_PROPERTY);
        if (versionString != null) {
            Version version;
            try {
                version = Version.parse(versionString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("Unable to parse model version '" + versionString + "'!", e);
            }
            if (!Version.currentVersion().equals(Version.DEV_VERSION)) {
                if (version.getMajor() != 1 && version.getMajor() != 2) {
                    throw new InvalidFormatException("Model version " + String.valueOf(version) + " is not supported by this (" + String.valueOf(Version.currentVersion()) + ") version of OpenNLP!");
                }
                if (!Version.currentVersion().isSnapshot() && version.isSnapshot()) {
                    throw new InvalidFormatException("Model version " + String.valueOf(version) + " is a snapshot - snapshot models are not supported by this non-snapshot version (" + String.valueOf(Version.currentVersion()) + ") of OpenNLP!");
                }
            }
        } else {
            throw new InvalidFormatException("Missing OpenNLP-Version property in manifest.properties!");
        }
        if (this.getManifestProperty(COMPONENT_NAME_PROPERTY) == null) {
            throw new InvalidFormatException("Missing Component-Name property in manifest.properties!");
        }
        if (!this.getManifestProperty(COMPONENT_NAME_PROPERTY).equals(this.componentName)) {
            throw new InvalidFormatException("The " + this.componentName + " cannot load a model for the " + this.getManifestProperty(COMPONENT_NAME_PROPERTY) + "!");
        }
        if (this.getManifestProperty(LANGUAGE_PROPERTY) == null) {
            throw new InvalidFormatException("Missing Language property in manifest.properties!");
        }
        String factoryName = this.getManifestProperty(FACTORY_NAME);
        if (factoryName != null) {
            try {
                if (ExtensionLoader.instantiateExtension(BaseToolFactory.class, factoryName) == null) {
                    throw new InvalidFormatException("Could not load an user extension specified by the model: " + factoryName);
                }
            }
            catch (Exception e) {
                throw new InvalidFormatException("Could not load an user extension specified by the model: " + factoryName, e);
            }
        }
        if (this.toolFactory != null) {
            this.toolFactory.validateArtifactMap();
        }
    }

    protected void checkArtifactMap() {
        if (!this.finishedLoadingArtifacts) {
            throw new IllegalStateException("The method BaseModel.finishLoadingArtifacts(..) was not called by BaseModel subclass.");
        }
        try {
            this.validateArtifactMap();
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public final String getManifestProperty(String key) {
        Properties manifest = (Properties)this.artifactMap.get(MANIFEST_ENTRY);
        return manifest.getProperty(key);
    }

    protected final void setManifestProperty(String key, String value) {
        Properties manifest = (Properties)this.artifactMap.get(MANIFEST_ENTRY);
        manifest.setProperty(key, value);
    }

    @Override
    public final String getLanguage() {
        return this.getManifestProperty(LANGUAGE_PROPERTY);
    }

    public final Version getVersion() {
        String version = this.getManifestProperty(VERSION_PROPERTY);
        return Version.parse(version);
    }

    public final void serialize(OutputStream out) throws IOException {
        if (!this.subclassSerializersInitiated) {
            throw new IllegalStateException("The method BaseModel.loadArtifactSerializers() was not called by BaseModel subclass constructor.");
        }
        for (Map.Entry<String, Object> entry : this.artifactMap.entrySet()) {
            String name = entry.getKey();
            Object artifact = entry.getValue();
            if (!(artifact instanceof SerializableArtifact)) continue;
            SerializableArtifact serializableArtifact = (SerializableArtifact)artifact;
            String artifactSerializerName = serializableArtifact.getArtifactSerializerClass().getName();
            this.setManifestProperty(SERIALIZER_CLASS_NAME_PREFIX + name, artifactSerializerName);
        }
        ZipOutputStream zip = new ZipOutputStream(out);
        for (Map.Entry<String, Object> entry : this.artifactMap.entrySet()) {
            String name = entry.getKey();
            zip.putNextEntry(new ZipEntry(name));
            Object artifact = entry.getValue();
            if (this.skipEntryForSerialization(entry)) continue;
            ArtifactSerializer serializer = this.getArtifactSerializer(name);
            if (artifact instanceof SerializableArtifact) {
                SerializableArtifact serializableArtifact = (SerializableArtifact)artifact;
                String artifactSerializerName = serializableArtifact.getArtifactSerializerClass().getName();
                serializer = ExtensionLoader.instantiateExtension(ArtifactSerializer.class, artifactSerializerName);
            }
            if (serializer == null) {
                throw new IllegalStateException("Missing serializer for " + name);
            }
            serializer.serialize(this.artifactMap.get(name), zip);
            zip.closeEntry();
        }
        zip.finish();
        zip.flush();
    }

    public final void serialize(File f) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            this.serialize(out);
        }
    }

    public final void serialize(Path p) throws IOException {
        this.serialize(p.toFile());
    }

    @Override
    public <T> T getArtifact(String key) {
        Object artifact = this.artifactMap.get(key);
        if (artifact == null) {
            return null;
        }
        return (T)artifact;
    }

    @Override
    public boolean isLoadedFromSerialized() {
        return this.isLoadedFromSerialized;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.componentName);
        this.serialize(out);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.isLoadedFromSerialized = true;
        this.artifactSerializers = new HashMap();
        this.artifactMap = new HashMap<String, Object>();
        this.componentName = in.readUTF();
        this.loadModel(in);
    }

    protected boolean skipEntryForSerialization(Map.Entry<String, Object> entry) {
        return false;
    }
}

