/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.jaas;

import java.util.List;
import javax.security.auth.login.LoginContext;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class JaasAuthenticationToken
extends UsernamePasswordAuthenticationToken {
    private static final long serialVersionUID = 620L;
    private final transient LoginContext loginContext;

    public JaasAuthenticationToken(Object principal, @Nullable Object credentials, LoginContext loginContext) {
        super(principal, credentials);
        this.loginContext = loginContext;
    }

    public JaasAuthenticationToken(Object principal, @Nullable Object credentials, List<GrantedAuthority> authorities, LoginContext loginContext) {
        super(principal, credentials, authorities);
        this.loginContext = loginContext;
    }

    protected JaasAuthenticationToken(Builder<?> builder) {
        super((UsernamePasswordAuthenticationToken.Builder<?>)builder);
        this.loginContext = builder.loginContext;
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    @Override
    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<B extends Builder<B>>
    extends UsernamePasswordAuthenticationToken.Builder<B> {
        private LoginContext loginContext;

        protected Builder(JaasAuthenticationToken token) {
            super(token);
            this.loginContext = token.getLoginContext();
        }

        public B loginContext(LoginContext loginContext) {
            this.loginContext = loginContext;
            return (B)this;
        }

        @Override
        public JaasAuthenticationToken build() {
            return new JaasAuthenticationToken(this);
        }
    }
}

