/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import jakarta.servlet.ServletRequest;
import java.util.Locale;
import org.jspecify.annotations.Nullable;

public interface PortMapper {
    public @Nullable Integer lookupHttpPort(Integer var1);

    public @Nullable Integer lookupHttpsPort(Integer var1);

    default public Integer getServerPort(ServletRequest request) {
        int serverPort = request.getServerPort();
        String scheme = request.getScheme().toLowerCase(Locale.ENGLISH);
        Integer mappedPort = null;
        if ("http".equals(scheme)) {
            mappedPort = this.lookupHttpPort(serverPort);
        } else if ("https".equals(scheme)) {
            mappedPort = this.lookupHttpsPort(serverPort);
        }
        return mappedPort != null ? mappedPort : serverPort;
    }
}

