/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class ModEvaluator
extends NumberEvaluator {
    private final Evaluator<Number> subject;
    private final Evaluator<Number> modValue;

    public ModEvaluator(Evaluator<Number> subject, Evaluator<Number> modValue) {
        this.subject = subject;
        this.modValue = modValue;
    }

    @Override
    public QueryResult<Number> evaluate(EvaluationContext evaluationContext) {
        Number subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new NumberQueryResult(null);
        }
        Number mod = this.modValue.evaluate(evaluationContext).getValue();
        if (mod == null) {
            return new NumberQueryResult(null);
        }
        Number result = subjectValue instanceof Double || mod instanceof Double ? (Number)(subjectValue.doubleValue() % mod.doubleValue()) : (Number)(subjectValue.longValue() % mod.longValue());
        return new NumberQueryResult(result);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

