/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.slf4j;

import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManagerAwareLogger;
import org.ops4j.pax.logging.PaxMarker;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.LoggingEvent;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.DefaultLoggingEventBuilder;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventAware;

public class Slf4jLogger
implements LocationAwareLogger,
PaxLoggingManagerAwareLogger,
LoggingEventAware {
    public static final String SLF4J_MARKER_MDC_ATTRIBUTE = "slf4j.marker";
    public static final String SLF4J_FQCN = Slf4jLogger.class.getName().intern();
    public static final String SLF4J_BUILDER_FQCN = DefaultLoggingEventBuilder.class.getName().intern();
    private String m_name;
    private PaxLogger m_delegate;
    public static ThreadLocal<String> fcqn = new ThreadLocal();

    public Slf4jLogger(String name, PaxLogger delegate) {
        this.m_name = name;
        this.m_delegate = delegate;
    }

    @Override
    public void setPaxLoggingManager(PaxLoggingManager loggingManager) {
        this.m_delegate = loggingManager == null ? FallbackLogFactory.createFallbackLog(FrameworkUtil.getBundle(Logger.class), this.m_name) : loggingManager.getLogger(this.m_name, SLF4J_FQCN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void log(LoggingEvent event) {
        Object[] argArray = event.getArgumentArray();
        int argLen = argArray == null ? 0 : argArray.length;
        Throwable t = event.getThrowable();
        int tLen = t == null ? 0 : 1;
        String msg = event.getMessage();
        Object[] combinedArguments = new Object[argLen + tLen];
        if (argArray != null) {
            System.arraycopy(argArray, 0, combinedArguments, 0, argLen);
        }
        if (t != null) {
            combinedArguments[argLen] = t;
        }
        msg = this.mergeMarkersAndKeyValuePairs(event, msg);
        try {
            fcqn.set(SLF4J_BUILDER_FQCN);
            switch (event.getLevel()) {
                case TRACE: {
                    this.m_delegate.trace(msg, combinedArguments);
                    return;
                }
                case DEBUG: {
                    this.m_delegate.debug(msg, combinedArguments);
                    return;
                }
                case INFO: {
                    this.m_delegate.info(msg, combinedArguments);
                    return;
                }
                case WARN: {
                    this.m_delegate.warn(msg, combinedArguments);
                    return;
                }
                case ERROR: {
                    this.m_delegate.error(msg, combinedArguments);
                    return;
                }
            }
            return;
        }
        finally {
            fcqn.remove();
        }
    }

    private String mergeMarkersAndKeyValuePairs(LoggingEvent aLoggingEvent, String msg) {
        StringBuilder sb = null;
        if (aLoggingEvent.getMarkers() != null) {
            sb = new StringBuilder();
            for (Marker marker : aLoggingEvent.getMarkers()) {
                sb.append(marker);
                sb.append(' ');
            }
        }
        if (aLoggingEvent.getKeyValuePairs() != null) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            for (KeyValuePair kvp : aLoggingEvent.getKeyValuePairs()) {
                sb.append(kvp.key);
                sb.append('=');
                sb.append(kvp.value);
                sb.append(' ');
            }
        }
        if (sb != null) {
            sb.append(msg);
            return sb.toString();
        }
        return msg;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.m_delegate.trace(msg);
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.trace(tuple.getMessage());
            } else {
                this.m_delegate.trace(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.trace(tuple.getMessage());
            } else {
                this.m_delegate.trace(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void trace(String format, Object[] argArray) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.trace(tuple.getMessage());
            } else {
                this.m_delegate.trace(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.m_delegate.trace(msg, (Object)t);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.m_delegate.isTraceEnabled(new PaxMarker(marker));
    }

    @Override
    public void trace(Marker marker, String msg) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isTraceEnabled(m)) {
                this.m_delegate.trace(m, msg);
            }
        } else if (this.m_delegate.isTraceEnabled()) {
            this.m_delegate.trace(msg);
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isTraceEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.format(format, arg);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.trace(m, tuple.getMessage());
                } else {
                    this.m_delegate.trace(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.trace(tuple.getMessage());
            } else {
                this.m_delegate.trace(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isTraceEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.trace(m, tuple.getMessage());
                } else {
                    this.m_delegate.trace(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.trace(tuple.getMessage());
            } else {
                this.m_delegate.trace(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void trace(Marker marker, String format, Object[] argArray) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isTraceEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.trace(m, tuple.getMessage());
                } else {
                    this.m_delegate.trace(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.trace(tuple.getMessage());
            } else {
                this.m_delegate.trace(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isTraceEnabled(m)) {
                this.m_delegate.trace(m, msg, (Object)t);
            }
        } else if (this.m_delegate.isTraceEnabled()) {
            this.m_delegate.trace(msg, (Object)t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.m_delegate.debug(msg);
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.debug(tuple.getMessage());
            } else {
                this.m_delegate.debug(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.debug(tuple.getMessage());
            } else {
                this.m_delegate.debug(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void debug(String format, Object[] argArray) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.debug(tuple.getMessage());
            } else {
                this.m_delegate.debug(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.m_delegate.debug(msg, (Object)t);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.m_delegate.isDebugEnabled(new PaxMarker(marker));
    }

    @Override
    public void debug(Marker marker, String msg) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isDebugEnabled(m)) {
                this.m_delegate.debug(m, msg);
            }
        } else if (this.m_delegate.isDebugEnabled()) {
            this.m_delegate.debug(msg);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isDebugEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.format(format, arg);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.debug(m, tuple.getMessage());
                } else {
                    this.m_delegate.debug(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.debug(tuple.getMessage());
            } else {
                this.m_delegate.debug(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isDebugEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.debug(m, tuple.getMessage());
                } else {
                    this.m_delegate.debug(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.debug(tuple.getMessage());
            } else {
                this.m_delegate.debug(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void debug(Marker marker, String format, Object[] argArray) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isDebugEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.debug(m, tuple.getMessage());
                } else {
                    this.m_delegate.debug(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.debug(tuple.getMessage());
            } else {
                this.m_delegate.debug(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isDebugEnabled(m)) {
                this.m_delegate.debug(m, msg, (Object)t);
            }
        } else if (this.m_delegate.isDebugEnabled()) {
            this.m_delegate.debug(msg, (Object)t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        this.m_delegate.info(msg);
    }

    @Override
    public void info(String format, Object arg) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.info(tuple.getMessage());
            } else {
                this.m_delegate.info(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.info(tuple.getMessage());
            } else {
                this.m_delegate.info(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void info(String format, Object[] argArray) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.info(tuple.getMessage());
            } else {
                this.m_delegate.info(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        this.m_delegate.info(msg, (Object)t);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.m_delegate.isInfoEnabled(new PaxMarker(marker));
    }

    @Override
    public void info(Marker marker, String msg) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isInfoEnabled(m)) {
                this.m_delegate.info(m, msg);
            }
        } else if (this.m_delegate.isInfoEnabled()) {
            this.m_delegate.info(msg);
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isInfoEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.format(format, arg);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.info(m, tuple.getMessage());
                } else {
                    this.m_delegate.info(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.info(tuple.getMessage());
            } else {
                this.m_delegate.info(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isInfoEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.info(m, tuple.getMessage());
                } else {
                    this.m_delegate.info(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.info(tuple.getMessage());
            } else {
                this.m_delegate.info(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void info(Marker marker, String format, Object[] argArray) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isInfoEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.info(m, tuple.getMessage());
                } else {
                    this.m_delegate.info(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.info(tuple.getMessage());
            } else {
                this.m_delegate.info(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isInfoEnabled(m)) {
                this.m_delegate.info(m, msg, (Object)t);
            }
        } else if (this.m_delegate.isInfoEnabled()) {
            this.m_delegate.info(msg, (Object)t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        this.m_delegate.warn(msg);
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.warn(tuple.getMessage());
            } else {
                this.m_delegate.warn(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void warn(String format, Object[] argArray) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.warn(tuple.getMessage());
            } else {
                this.m_delegate.warn(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.warn(tuple.getMessage());
            } else {
                this.m_delegate.warn(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.m_delegate.warn(msg, (Object)t);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.m_delegate.isWarnEnabled(new PaxMarker(marker));
    }

    @Override
    public void warn(Marker marker, String msg) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isWarnEnabled(m)) {
                this.m_delegate.warn(m, msg);
            }
        } else if (this.m_delegate.isWarnEnabled()) {
            this.m_delegate.warn(msg);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isWarnEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.format(format, arg);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.warn(m, tuple.getMessage());
                } else {
                    this.m_delegate.warn(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.warn(tuple.getMessage());
            } else {
                this.m_delegate.warn(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isWarnEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.warn(m, tuple.getMessage());
                } else {
                    this.m_delegate.warn(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.warn(tuple.getMessage());
            } else {
                this.m_delegate.warn(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void warn(Marker marker, String format, Object[] argArray) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isWarnEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.warn(m, tuple.getMessage());
                } else {
                    this.m_delegate.warn(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.warn(tuple.getMessage());
            } else {
                this.m_delegate.warn(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isWarnEnabled(m)) {
                this.m_delegate.warn(m, msg, (Object)t);
            }
        } else if (this.m_delegate.isWarnEnabled()) {
            this.m_delegate.warn(msg, (Object)t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        this.m_delegate.error(msg);
    }

    @Override
    public void error(String format, Object arg) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.error(tuple.getMessage());
            } else {
                this.m_delegate.error(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.error(tuple.getMessage());
            } else {
                this.m_delegate.error(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void error(String format, Object[] argArray) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.error(tuple.getMessage());
            } else {
                this.m_delegate.error(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        this.m_delegate.error(msg, (Object)t);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.m_delegate.isErrorEnabled(new PaxMarker(marker));
    }

    @Override
    public void error(Marker marker, String msg) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isErrorEnabled(m)) {
                this.m_delegate.error(m, msg);
            }
        } else if (this.m_delegate.isErrorEnabled()) {
            this.m_delegate.error(msg);
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isErrorEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.format(format, arg);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.error(m, tuple.getMessage());
                } else {
                    this.m_delegate.error(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.error(tuple.getMessage());
            } else {
                this.m_delegate.error(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isErrorEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.error(m, tuple.getMessage());
                } else {
                    this.m_delegate.error(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.error(tuple.getMessage());
            } else {
                this.m_delegate.error(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void error(Marker marker, String format, Object[] argArray) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isErrorEnabled(m)) {
                FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
                Throwable t = tuple.getThrowable();
                if (t == null) {
                    this.m_delegate.error(m, tuple.getMessage());
                } else {
                    this.m_delegate.error(m, tuple.getMessage(), (Object)t);
                }
            }
        } else if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            Throwable t = tuple.getThrowable();
            if (t == null) {
                this.m_delegate.error(tuple.getMessage());
            } else {
                this.m_delegate.error(tuple.getMessage(), (Object)t);
            }
        }
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        if (marker != null) {
            PaxMarker m = new PaxMarker(marker);
            if (this.m_delegate.isErrorEnabled(m)) {
                this.m_delegate.error(m, msg, (Object)t);
            }
        } else if (this.m_delegate.isErrorEnabled()) {
            this.m_delegate.error(msg, (Object)t);
        }
    }

    @Override
    public void log(Marker marker, String fqcn, int level, String message, Object[] argArray, Throwable t) {
        PaxMarker paxMarker = null;
        if (marker != null) {
            paxMarker = new PaxMarker(marker);
        }
        switch (level) {
            case 0: {
                if (!this.m_delegate.isTraceEnabled()) break;
                FormattingTuple tuple = MessageFormatter.arrayFormat(message, argArray);
                if (paxMarker != null) {
                    this.m_delegate.trace(paxMarker, tuple.getMessage(), (Object)t);
                    break;
                }
                this.m_delegate.trace(tuple.getMessage(), (Object)t);
                break;
            }
            case 10: {
                if (!this.m_delegate.isDebugEnabled()) break;
                FormattingTuple tuple = MessageFormatter.arrayFormat(message, argArray);
                if (paxMarker != null) {
                    this.m_delegate.debug(paxMarker, tuple.getMessage(), (Object)t);
                    break;
                }
                this.m_delegate.debug(tuple.getMessage(), (Object)t);
                break;
            }
            case 20: {
                if (!this.m_delegate.isInfoEnabled()) break;
                FormattingTuple tuple = MessageFormatter.arrayFormat(message, argArray);
                if (paxMarker != null) {
                    this.m_delegate.info(paxMarker, tuple.getMessage(), (Object)t);
                    break;
                }
                this.m_delegate.info(tuple.getMessage(), (Object)t);
                break;
            }
            case 30: {
                if (!this.m_delegate.isWarnEnabled()) break;
                FormattingTuple tuple = MessageFormatter.arrayFormat(message, argArray);
                if (paxMarker != null) {
                    this.m_delegate.warn(paxMarker, tuple.getMessage(), (Object)t);
                    break;
                }
                this.m_delegate.warn(tuple.getMessage(), (Object)t);
                break;
            }
            case 40: {
                if (!this.m_delegate.isErrorEnabled()) break;
                FormattingTuple tuple = MessageFormatter.arrayFormat(message, argArray);
                if (paxMarker != null) {
                    this.m_delegate.error(paxMarker, tuple.getMessage(), (Object)t);
                    break;
                }
                this.m_delegate.error(tuple.getMessage(), (Object)t);
                break;
            }
        }
    }
}

