/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.commands.help;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.impl.console.commands.help.HelpProvider;
import org.apache.karaf.shell.support.NameScoping;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.ShellTable;

public class CommandListHelpProvider
implements HelpProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getHelp(Session session, String path) {
        String mode = "raw";
        if (path.indexOf(124) <= 0) return null;
        if (!path.startsWith("command-list|")) return null;
        if ((path = path.substring("command-list|".length())).indexOf(124) > 0) {
            mode = path.substring(path.indexOf(124) + 1);
            path = path.substring(0, path.indexOf(124));
        }
        Set<Command> commands = this.getCommands(session, path);
        TreeMap<String, String> descriptions = new TreeMap<String, String>();
        for (Command command : commands) {
            String subshell = (String)session.get("SUBSHELL");
            Object name = command.getScope() + ":" + command.getName();
            String description = command.getDescription();
            if (((String)name).startsWith("*:")) {
                name = ((String)name).substring(2);
            }
            if (subshell != null && !subshell.trim().isEmpty() && ((String)name).startsWith(subshell + ":")) {
                name = ((String)name).substring(subshell.length() + 1);
            }
            descriptions.put((String)name, description);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (descriptions.isEmpty()) {
            return null;
        }
        if (descriptions.size() == 1 && descriptions.containsKey(path)) {
            return null;
        }
        this.printMethodList(session, new PrintStream(baos), descriptions, Arrays.asList(mode.split(",")));
        return baos.toString();
    }

    private Set<Command> getCommands(Session session, String path) {
        List<Command> commands = session.getRegistry().getCommands();
        String subshell = (String)session.get("SUBSHELL");
        String completionMode = (String)session.get("karaf.completionMode");
        HashSet<Command> matchingCommands = new HashSet<Command>();
        for (Command command : commands) {
            String name = command.getScope() + ":" + command.getName();
            if (!name.startsWith(path) || completionMode != null && completionMode.equalsIgnoreCase("subshell") && (subshell == null || subshell.trim().isEmpty()) && !name.startsWith("*") || completionMode != null && (completionMode.equalsIgnoreCase("subshell") || completionMode.equalsIgnoreCase("first")) && !name.startsWith(subshell)) continue;
            matchingCommands.add(command);
        }
        return matchingCommands;
    }

    protected void printMethodList(Session session, PrintStream out, SortedMap<String, String> commands, Collection<String> modes) {
        boolean list = false;
        boolean cyan = false;
        int indent = 0;
        for (String mode : modes) {
            if (mode.equals("list")) {
                list = true;
                continue;
            }
            if (mode.equals("cyan")) {
                cyan = true;
                continue;
            }
            if (mode.equals("indent")) {
                indent = 3;
                continue;
            }
            if (!mode.startsWith("indent=")) continue;
            indent = Integer.parseInt(mode.substring("indent=".length())) - 1;
        }
        Terminal term = session.getTerminal();
        int termWidth = term != null ? term.getWidth() : 80;
        ShellTable table = new ShellTable().noHeaders().separator(" ").size(termWidth - 1);
        Col col = new Col("Command").maxSize(64);
        if (indent > 0 || list) {
            table.column(new Col(""));
        }
        if (cyan) {
            col.cyan();
        } else {
            col.bold();
        }
        table.column(col);
        table.column(new Col("Description").wrap());
        for (Map.Entry<String, String> entry : commands.entrySet()) {
            String key = NameScoping.getCommandNameWithoutGlobalPrefix(session, entry.getKey());
            if (indent > 0 || list) {
                StringBuilder prefix = new StringBuilder();
                for (int i = 0; i < indent; ++i) {
                    prefix.append(" ");
                }
                if (list) {
                    prefix.append(" *");
                }
                table.addRow().addContent(prefix.toString(), key, entry.getValue());
                continue;
            }
            table.addRow().addContent(key, entry.getValue());
        }
        table.print(out, true);
    }
}

