/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.util.List;
import org.apache.felix.gogo.runtime.Reflective;
import org.apache.felix.gogo.runtime.Token;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CommandProxy
implements Function {
    private BundleContext context;
    private ServiceReference<?> reference;
    private String function;
    private Object target;

    public CommandProxy(BundleContext context, ServiceReference<?> reference, String function) {
        this.context = context;
        this.reference = reference;
        this.function = function;
    }

    public CommandProxy(Object target, String function) {
        this.function = function;
        this.target = target;
    }

    public Object getTarget() {
        return this.context != null ? this.context.getService(this.reference) : this.target;
    }

    public void ungetTarget() {
        if (this.context != null) {
            try {
                this.context.ungetService(this.reference);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(CommandSession session, List<Object> arguments) throws Exception {
        Object tgt = this.getTarget();
        try {
            if (tgt instanceof Function) {
                for (int i = 0; i < arguments.size(); ++i) {
                    Object obj = arguments.get(i);
                    if (!(obj instanceof Token)) continue;
                    arguments.set(i, obj.toString());
                }
                Object object = ((Function)tgt).execute(session, arguments);
                return object;
            }
            Object object = Reflective.invoke(session, tgt, this.function, arguments);
            return object;
        }
        finally {
            this.ungetTarget();
        }
    }
}

