/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.model.processing;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.features.LocationPattern;
import org.apache.karaf.features.internal.model.processing.BundleReplacements;
import org.apache.karaf.features.internal.model.processing.FeatureReplacements;
import org.apache.karaf.features.internal.model.processing.OverrideBundleDependency;
import org.apache.karaf.features.internal.service.Blacklist;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="featuresProcessing", namespace="http://karaf.apache.org/xmlns/features-processing/v1.0.0")
@XmlType(name="featuresProcessing", propOrder={"blacklistedRepositories", "blacklistedFeatures", "blacklistedBundles", "overrideBundleDependency", "bundleReplacements", "featureReplacements"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FeaturesProcessing {
    public static Logger LOG = LoggerFactory.getLogger(FeaturesProcessing.class);
    public static final String FEATURES_PROCESSING_NS = "http://karaf.apache.org/xmlns/features-processing/v1.0.0";
    @XmlElementWrapper(name="blacklistedRepositories")
    @XmlElement(name="repository")
    private List<String> blacklistedRepositories = new LinkedList<String>();
    @XmlTransient
    private List<LocationPattern> blacklistedRepositoryLocationPatterns = new LinkedList<LocationPattern>();
    @XmlElementWrapper(name="blacklistedFeatures")
    @XmlElement(name="feature")
    private List<BlacklistedFeature> blacklistedFeatures = new LinkedList<BlacklistedFeature>();
    @XmlElementWrapper(name="blacklistedBundles")
    @XmlElement(name="bundle")
    private List<String> blacklistedBundles = new LinkedList<String>();
    @XmlElement
    private OverrideBundleDependency overrideBundleDependency = new OverrideBundleDependency();
    @XmlElement
    private BundleReplacements bundleReplacements = new BundleReplacements();
    @XmlElement
    private FeatureReplacements featureReplacements = new FeatureReplacements();
    @XmlTransient
    private Blacklist blacklist;

    public List<String> getBlacklistedRepositories() {
        return this.blacklistedRepositories;
    }

    public List<LocationPattern> getBlacklistedRepositoryLocationPatterns() {
        return this.blacklistedRepositoryLocationPatterns;
    }

    public List<BlacklistedFeature> getBlacklistedFeatures() {
        return this.blacklistedFeatures;
    }

    public List<String> getBlacklistedBundles() {
        return this.blacklistedBundles;
    }

    public OverrideBundleDependency getOverrideBundleDependency() {
        return this.overrideBundleDependency;
    }

    public void setOverrideBundleDependency(OverrideBundleDependency overrideBundleDependency) {
        this.overrideBundleDependency = overrideBundleDependency;
    }

    public BundleReplacements getBundleReplacements() {
        return this.bundleReplacements;
    }

    public void setBundleReplacements(BundleReplacements bundleReplacements) {
        this.bundleReplacements = bundleReplacements;
    }

    public FeatureReplacements getFeatureReplacements() {
        return this.featureReplacements;
    }

    public void setFeatureReplacements(FeatureReplacements featureReplacements) {
        this.featureReplacements = featureReplacements;
    }

    public Blacklist getBlacklist() {
        return this.blacklist;
    }

    public void postUnmarshall(Blacklist blacklist, Set<String> overrides) {
        LinkedList<String> blacklisted = new LinkedList<String>();
        blacklist.getRepositoryBlacklist().stream().map(LocationPattern::getOriginalUri).forEach(uri -> this.getBlacklistedRepositories().add((String)uri));
        for (String repositoryURI : this.getBlacklistedRepositories()) {
            try {
                this.blacklistedRepositoryLocationPatterns.add(new LocationPattern(repositoryURI));
                blacklisted.add(repositoryURI + ";type=repository");
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Can't parse blacklisted repository location pattern: " + repositoryURI + ". Ignoring.");
            }
        }
        blacklist.getFeatureBlacklist().forEach(fb -> this.getBlacklistedFeatures().add(new BlacklistedFeature(fb.getName(), fb.getVersion())));
        blacklisted.addAll(this.getBlacklistedFeatures().stream().map(bf -> bf.getName() + ";type=feature" + (String)(bf.getVersion() == null ? "" : ";range=\"" + bf.getVersion() + "\"")).collect(Collectors.toList()));
        blacklist.getBundleBlacklist().stream().map(LocationPattern::getOriginalUri).forEach(uri -> this.getBlacklistedBundles().add((String)uri));
        blacklisted.addAll(this.getBlacklistedBundles().stream().map(bl -> bl + ";type=bundle").collect(Collectors.toList()));
        this.blacklist = new Blacklist(blacklisted);
        this.bundleReplacements.getOverrideBundles().addAll(FeaturesProcessing.parseOverridesClauses(overrides));
        Iterator<BundleReplacements.OverrideBundle> iterator = this.bundleReplacements.getOverrideBundles().iterator();
        while (iterator.hasNext()) {
            BundleReplacements.OverrideBundle overrideBundle = iterator.next();
            if (overrideBundle.getOriginalUri() == null) {
                String originalUri;
                if (overrideBundle.getMode() == BundleReplacements.BundleOverrideMode.MAVEN) {
                    LOG.warn("Can't override bundle in maven mode without explicit original URL. Switching to osgi mode.");
                    overrideBundle.setMode(BundleReplacements.BundleOverrideMode.OSGI);
                }
                if ((originalUri = FeaturesProcessing.calculateOverridenURI(overrideBundle.getReplacement(), null)) != null) {
                    overrideBundle.setOriginalUri(originalUri);
                } else {
                    iterator.remove();
                    continue;
                }
            }
            try {
                overrideBundle.compile();
            }
            catch (MalformedURLException e) {
                LOG.warn("Can't parse override URL location pattern: " + overrideBundle.getOriginalUri() + ". Ignoring.");
                iterator.remove();
            }
        }
    }

    public static Collection<? extends BundleReplacements.OverrideBundle> parseOverridesClauses(Set<String> overrides) {
        LinkedList<BundleReplacements.OverrideBundle> result = new LinkedList<BundleReplacements.OverrideBundle>();
        for (Clause clause : Parser.parseClauses(overrides.toArray(new String[overrides.size()]))) {
            String mvnURI = clause.getName();
            URI uri = URI.create(mvnURI);
            if (!"mvn".equals(uri.getScheme())) {
                LOG.warn("Override URI \"" + mvnURI + "\" should use mvn: scheme. Ignoring.");
                continue;
            }
            BundleReplacements.OverrideBundle override = new BundleReplacements.OverrideBundle();
            override.setMode(BundleReplacements.BundleOverrideMode.OSGI);
            override.setReplacement(mvnURI);
            String originalUri = FeaturesProcessing.calculateOverridenURI(mvnURI, clause.getAttribute("range"));
            if (originalUri == null) continue;
            override.setOriginalUri(originalUri);
            try {
                override.compile();
                result.add(override);
            }
            catch (MalformedURLException e) {
                LOG.warn("Can't parse override URL location pattern: " + originalUri + ". Ignoring.");
            }
        }
        return result;
    }

    private static String calculateOverridenURI(String replacement, String range) {
        try {
            org.apache.karaf.util.maven.Parser parser = new org.apache.karaf.util.maven.Parser(replacement);
            if (parser.getVersion() != null && (parser.getVersion().startsWith("[") || parser.getVersion().startsWith("("))) {
                throw new MalformedURLException("Override URI should use single version.");
            }
            if (range != null) {
                VersionRange vr = new VersionRange(range, true);
                if (vr.isOpenCeiling() && vr.getCeiling() == VersionRange.INFINITE_VERSION) {
                    parser.setVersion(String.format("%s%s,*)", vr.isOpenFloor() ? "(" : "[", vr.getFloor()));
                } else {
                    parser.setVersion(vr.toString());
                }
            } else {
                Version v;
                try {
                    v = new Version(VersionCleaner.clean(parser.getVersion()));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Problem parsing override URI \"" + replacement + "\": " + e.getMessage() + ". Version ranges are not handled. Ignoring.");
                    return null;
                }
                Version vfloor = new Version(v.getMajor(), v.getMinor(), 0, null);
                parser.setVersion(new VersionRange(false, vfloor, v, v.compareTo(vfloor) > 0).toString());
            }
            return parser.toMvnURI();
        }
        catch (MalformedURLException e) {
            LOG.warn("Problem parsing override URI \"" + replacement + "\": " + e.getMessage() + ". Ignoring.");
            return null;
        }
    }

    @XmlType(name="blacklistedFeature")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class BlacklistedFeature {
        @XmlValue
        private String name;
        @XmlAttribute
        private String version;

        public BlacklistedFeature() {
        }

        public BlacklistedFeature(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

