/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.commands;

import java.io.PrintStream;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.impl.console.commands.TopLevelCommand;
import org.apache.karaf.shell.impl.console.commands.help.HelpCommand;

public class SubShellCommand
extends TopLevelCommand {
    private final String name;
    private final AtomicInteger references = new AtomicInteger();

    public SubShellCommand(String name) {
        this.name = name;
    }

    public void increment() {
        this.references.incrementAndGet();
    }

    public int decrement() {
        return this.references.decrementAndGet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "Enter the subshell";
    }

    @Override
    protected void doExecute(Session session) throws Exception {
        session.put("SUBSHELL", this.name);
        session.put("SCOPE", this.name + ":" + String.valueOf(session.get("SCOPE")));
    }

    @Override
    protected void printHelp(Session session, PrintStream out) {
        try {
            new HelpCommand(session.getFactory()).execute(session, Collections.singletonList("shell|" + this.name));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to print subshell help", e);
        }
    }
}

