/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.felix.cm.json.Configurations;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.features.ConfigFileInfo;
import org.apache.karaf.features.ConfigInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.service.FeaturesServiceImpl;
import org.apache.karaf.util.StreamUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureConfigInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesServiceImpl.class);
    private static final String CONFIG_KEY = "org.apache.karaf.features.configKey";
    private static final String FILEINSTALL_FILE_NAME = "felix.fileinstall.filename";
    private static final Pattern JSON_PATTERN = Pattern.compile("\\s*\\{[\\s\\S]*");
    private final ConfigurationAdmin configAdmin;
    private File storage;
    private boolean configCfgStore;

    public FeatureConfigInstaller(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
        this.storage = new File(System.getProperty("karaf.etc"));
        this.configCfgStore = true;
    }

    public FeatureConfigInstaller(ConfigurationAdmin configAdmin, boolean configCfgStore) {
        this.configAdmin = configAdmin;
        this.storage = new File(System.getProperty("karaf.etc"));
        this.configCfgStore = configCfgStore;
    }

    private ConfigId parsePid(String pid) {
        int n;
        ConfigId cid = new ConfigId();
        cid.pid = pid;
        int n2 = n = pid.contains("~") ? pid.indexOf(126) : pid.indexOf(45);
        if (n > 0) {
            cid.isFactoryPid = true;
            cid.factoryPid = pid.substring(0, n);
            cid.name = pid.substring(n + 1);
        }
        return cid;
    }

    private Configuration createConfiguration(ConfigurationAdmin configurationAdmin, ConfigId cid) throws IOException, InvalidSyntaxException {
        if (cid.isFactoryPid) {
            if (Objects.nonNull(cid.name)) {
                return configurationAdmin.getFactoryConfiguration(cid.factoryPid, cid.name, null);
            }
            return configurationAdmin.createFactoryConfiguration(cid.factoryPid, null);
        }
        return configurationAdmin.getConfiguration(cid.pid, null);
    }

    private Configuration findExistingConfiguration(ConfigurationAdmin configurationAdmin, ConfigId cid) throws IOException, InvalidSyntaxException {
        String filter = !cid.isFactoryPid ? "(service.pid=" + cid.pid + ")" : "(org.apache.karaf.features.configKey=" + cid.pid + ")";
        Configuration[] configurations = configurationAdmin.listConfigurations(filter);
        return configurations != null && configurations.length > 0 ? configurations[0] : null;
    }

    public void installFeatureConfigs(Feature feature) throws IOException, InvalidSyntaxException {
        for (ConfigInfo config : feature.getConfigurations()) {
            String configValue = config.getValue();
            TypedProperties properties = new TypedProperties();
            boolean jsonFormat = false;
            if (config.isExternal()) {
                try {
                    configValue = this.loadConfiguration(new URL(configValue));
                }
                catch (MalformedURLException e) {
                    throw new IOException("Failed to load configuration from URL " + configValue + " for feature " + feature.getName() + "/" + feature.getVersion(), e);
                }
            }
            if (JSON_PATTERN.matcher(configValue).matches()) {
                properties = this.convertToTypedProperties(Configurations.buildReader().build((Reader)new StringReader(configValue)).readConfiguration());
                jsonFormat = true;
            } else {
                properties.load(new StringReader(configValue));
            }
            ConfigId cid = this.parsePid(config.getName());
            Configuration cfg = this.findExistingConfiguration(this.configAdmin, cid);
            if (cfg == null || config.isOverride()) {
                File cfgFile = null;
                if (this.storage != null) {
                    cfgFile = jsonFormat ? new File(this.storage, cid.pid + ".json") : new File(this.storage, cid.pid + ".cfg");
                }
                if (!cfgFile.exists() || config.isOverride()) {
                    Dictionary<String, Object> cfgProps = this.convertToDict(properties);
                    cfg = this.createConfiguration(this.configAdmin, cid);
                    cfgProps.put(CONFIG_KEY, cid.pid);
                    properties.put(CONFIG_KEY, (Object)cid.pid);
                    cfg.update(cfgProps);
                    if (this.storage != null && this.configCfgStore) {
                        properties.put(FILEINSTALL_FILE_NAME, (Object)cfgFile.getAbsoluteFile().toURI().toString());
                        cfgProps.put(FILEINSTALL_FILE_NAME, cfgFile.getAbsoluteFile().toURI().toString());
                    }
                    try {
                        this.updateStorage(cid, properties, false, jsonFormat);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Can't update cfg file", (Throwable)e);
                    }
                    continue;
                }
                LOGGER.info("Skipping configuration {} - file already exists", (Object)cfgFile);
                continue;
            }
            if (!config.isAppend()) continue;
            boolean update = false;
            Dictionary p = cfg.getProcessedProperties(null);
            for (String key : properties.keySet()) {
                if (p.get(key) != null) continue;
                p.put(key, properties.get(key));
                update = true;
            }
            if (!update) continue;
            cfg.update(p);
            try {
                this.updateStorage(cid, properties, true, jsonFormat);
            }
            catch (Exception e) {
                LOGGER.warn("Can't update cfg file", (Throwable)e);
            }
        }
        for (ConfigFileInfo configFile : feature.getConfigurationFiles()) {
            this.installConfigurationFile(configFile.getLocation(), configFile.getFinalname(), configFile.isOverride());
        }
    }

    private String loadConfiguration(URL url) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(url.openStream());){
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamUtils.copy(inputStream, outputStream);
            String string = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
    }

    public void uninstallFeatureConfigs(Feature feature) throws IOException, InvalidSyntaxException {
        if (feature != null) {
            if (feature.getConfigurations() != null) {
                for (ConfigInfo configInfo : feature.getConfigurations()) {
                    ConfigId configId = this.parsePid(configInfo.getName());
                    Configuration configuration = this.findExistingConfiguration(this.configAdmin, configId);
                    if (configuration != null) {
                        configuration.delete();
                    }
                    File cfgFile = null;
                    if (this.storage != null) {
                        cfgFile = new File(this.storage, configId.pid + ".cfg");
                    }
                    if (!cfgFile.exists()) continue;
                    cfgFile.delete();
                }
            }
            if (feature.getConfigurationFiles() != null) {
                for (ConfigFileInfo configFileInfo : feature.getConfigurationFiles()) {
                    String finalname = FeatureConfigInstaller.substFinalName(configFileInfo.getFinalname());
                    File cfgFile = new File(finalname);
                    if (!cfgFile.exists()) continue;
                    cfgFile.delete();
                }
            }
        }
    }

    private Dictionary<String, Object> convertToDict(Map<String, Object> props) {
        Hashtable<String, Object> cfgProps = new Hashtable<String, Object>();
        for (Map.Entry<String, Object> e : props.entrySet()) {
            ((Dictionary)cfgProps).put(e.getKey(), e.getValue());
        }
        return cfgProps;
    }

    private TypedProperties convertToTypedProperties(Dictionary<String, Object> dict) {
        TypedProperties typedProperties = new TypedProperties();
        Enumeration<String> keys = dict.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            typedProperties.put(key, dict.get(key));
        }
        return typedProperties;
    }

    protected static String substFinalName(String finalname) {
        String markerVarBeg = "${";
        String markerVarEnd = "}";
        boolean startsWithVariable = ((String)finalname).startsWith("${") && ((String)finalname).contains("}");
        String dummyKey = "";
        try {
            finalname = InterpolationHelper.substVars((String)finalname, "", null, null, null, true, true, false);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.info("Substitution failed. Skip substitution of variables of configuration final name ({}).", finalname);
        }
        if (!startsWithVariable || ((String)finalname).startsWith("${")) {
            String basePath = System.getProperty("karaf.base");
            finalname = basePath + File.separator + (String)finalname;
        }
        while (((String)finalname).contains("${") && ((String)finalname).contains("}")) {
            int beg = ((String)finalname).indexOf("${");
            int end = ((String)finalname).indexOf("}");
            String rem = ((String)finalname).substring(beg, end + "}".length());
            finalname = ((String)finalname).replace(rem, "");
        }
        return finalname;
    }

    private void installConfigurationFile(String fileLocation, String finalname, boolean override) throws IOException {
        File file = new File(finalname = FeatureConfigInstaller.substFinalName(finalname));
        if (file.exists()) {
            if (!override) {
                LOGGER.debug("Configuration file {} already exist, don't override it", (Object)finalname);
                return;
            }
            LOGGER.info("Configuration file {} already exist, overriding it", (Object)finalname);
        } else {
            LOGGER.info("Creating configuration file {}", (Object)finalname);
        }
        try (BufferedInputStream is = new BufferedInputStream(new URL(fileLocation).openStream());){
            if (!file.exists()) {
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                file.createNewFile();
            }
            try (FileOutputStream fop = new FileOutputStream(file);){
                StreamUtils.copy(is, fop);
            }
        }
        catch (RuntimeException | MalformedURLException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
    }

    protected void updateStorage(ConfigId cid, TypedProperties props, boolean append, boolean jsonFormat) throws Exception {
        if (this.storage != null && this.configCfgStore) {
            File cfgFile = this.getConfigFile(cid, jsonFormat);
            if (!cfgFile.exists()) {
                File tmpCfgFile = File.createTempFile(cfgFile.getName(), ".tmp", cfgFile.getParentFile());
                if (jsonFormat) {
                    Configurations.buildWriter().build((Writer)new FileWriter(tmpCfgFile)).writeConfiguration(this.convertToDict(props));
                } else {
                    props.save(tmpCfgFile);
                }
                tmpCfgFile.renameTo(cfgFile);
            } else {
                this.updateExistingConfig(props, append, cfgFile, jsonFormat);
            }
        }
    }

    private File getConfigFile(ConfigId cid, boolean jsonFormat) throws IOException, InvalidSyntaxException {
        Configuration cfg = this.findExistingConfiguration(this.configAdmin, cid);
        File cfgFile = jsonFormat ? new File(this.storage, cid.pid + ".json") : new File(this.storage, cid.pid + ".cfg");
        if (cfg != null && cfg.getProcessedProperties(null) != null) {
            Object val = cfg.getProcessedProperties(null).get(FILEINSTALL_FILE_NAME);
            try {
                if (val instanceof URL) {
                    cfgFile = new File(((URL)val).toURI());
                }
                if (val instanceof URI) {
                    cfgFile = new File((URI)val);
                }
                if (val instanceof String) {
                    cfgFile = new File(new URL((String)val).toURI());
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        LOGGER.trace("Update {}", (Object)cfgFile.getName());
        return cfgFile;
    }

    private void updateExistingConfig(TypedProperties props, boolean append, File cfgFile, boolean jsonFormat) throws IOException {
        TypedProperties properties = new TypedProperties();
        if (jsonFormat) {
            properties = this.convertToTypedProperties(Configurations.buildReader().build((Reader)new FileReader(cfgFile)).readConfiguration());
        } else {
            properties.load(cfgFile);
        }
        for (String key : props.keySet()) {
            if (this.isInternalKey(key)) continue;
            List<String> comments = props.getComments(key);
            Object value = props.get(key);
            if (!properties.containsKey(key)) {
                properties.put(key, comments, value);
                continue;
            }
            if (append) continue;
            if (comments.isEmpty()) {
                comments = properties.getComments(key);
            }
            properties.put(key, comments, value);
        }
        if (!append) {
            ArrayList<String> propertiesToRemove = new ArrayList<String>();
            for (String key : properties.keySet()) {
                if (props.containsKey(key) || this.isInternalKey(key)) continue;
                propertiesToRemove.add(key);
            }
            for (String key : propertiesToRemove) {
                properties.remove(key);
            }
        }
        this.storage.mkdirs();
        if (jsonFormat) {
            Configurations.buildWriter().build((Writer)new FileWriter(cfgFile)).writeConfiguration(new Hashtable<String, Object>(properties));
        } else {
            properties.save(cfgFile);
        }
    }

    private boolean isInternalKey(String key) {
        return "service.pid".equals(key) || "service.factoryPid".equals(key) || FILEINSTALL_FILE_NAME.equals(key);
    }

    private static final class ConfigId {
        boolean isFactoryPid;
        String pid;
        String factoryPid;
        String name;

        private ConfigId() {
        }
    }
}

