/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.resultset.ResultSetWrapper;

public class ResultSetOnClose
extends ResultSetWrapper {
    private final Runnable onClose;
    private boolean isClosed = false;

    public ResultSetOnClose(ResultSet rs, Runnable onClose) {
        super(rs);
        this.onClose = onClose;
    }

    private void onClose() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.onClose.run();
    }

    @Override
    public boolean hasNext() {
        boolean b = super.hasNext();
        if (!b) {
            this.onClose();
        }
        return b;
    }

    @Override
    public QuerySolution next() {
        try {
            return super.next();
        }
        catch (NoSuchElementException ex) {
            this.onClose();
            throw ex;
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super QuerySolution> action) {
        super.forEachRemaining(action);
        this.onClose();
    }

    @Override
    public QuerySolution nextSolution() {
        try {
            return super.nextSolution();
        }
        catch (NoSuchElementException ex) {
            this.onClose();
            throw ex;
        }
    }

    @Override
    public Binding nextBinding() {
        try {
            return super.nextBinding();
        }
        catch (NoSuchElementException ex) {
            this.onClose();
            throw ex;
        }
    }

    @Override
    public void close() {
        super.close();
        this.onClose();
    }
}

