/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.test;

import org.apache.jena.atlas.test.ExecGenerator;

public class RepeatExecution {
    public static void repeatExecutions(ExecGenerator execGenerator, int iterations, boolean showProgress) {
        int dots = 10;
        int lines = 500;
        if (iterations > 10000) {
            dots = 10 * dots;
            lines = 10 * lines;
        }
        long start = System.currentTimeMillis();
        int successes = 0;
        int failures = 0;
        boolean eol = true;
        for (int i = 0; i < iterations; ++i) {
            if (showProgress && i % lines == 0) {
                eol = true;
                if (i != 0) {
                    System.out.println();
                }
                System.out.printf("%-6d: ", i);
            } else {
                eol = false;
            }
            if (showProgress && i % dots == 0) {
                System.out.print(".");
            }
            try {
                execGenerator.executeOneTest();
                ++successes;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                if (++failures >= 1) break;
            }
        }
        long finish = System.currentTimeMillis();
        if (showProgress && !eol) {
            System.out.println();
        }
        System.out.printf("Successes = %d : Failures = %d\n", successes, failures);
        double x = (double)(finish - start) / 1000.0;
        System.out.printf("Time = %.2fs; avg = %.4fs\n", x, x / (double)iterations);
    }
}

