/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.frequency.util;

import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFTUtil {
    private final String result;
    private final double compressRate;
    private static final Logger logger = LoggerFactory.getLogger(FFTUtil.class);

    public FFTUtil(String res, double cmprate) {
        this.result = res;
        this.compressRate = cmprate;
    }

    public void outputCompressed(PointCollector collector, double[] a) throws Exception {
        int n = a.length / 2;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += a[2 * i] * a[2 * i] + a[2 * i + 1] * a[2 * i + 1];
        }
        double temp = a[0] * a[0] + a[1] * a[1];
        this.add(collector, a, 0);
        for (int i = 1; i <= n / 2; ++i) {
            this.add(collector, a, i);
            temp += (a[2 * i] * a[2 * i] + a[2 * i + 1] * a[2 * i + 1]) * 2.0;
            if (!(temp > this.compressRate * sum)) continue;
            if (!logger.isDebugEnabled()) break;
            logger.debug(String.valueOf(i));
            break;
        }
        this.add(collector, a, n - 1);
    }

    public void add(PointCollector collector, double[] a, int i) throws Exception {
        double ans = 0.0;
        switch (this.result) {
            case "real": {
                ans = a[i * 2];
                break;
            }
            case "imag": {
                ans = a[i * 2 + 1];
                break;
            }
            case "abs": {
                ans = Math.sqrt(a[i * 2] * a[i * 2] + a[2 * i + 1] * a[2 * i + 1]);
                break;
            }
            case "angle": {
                ans = Math.atan2(a[2 * i + 1], a[2 * i]);
                break;
            }
            default: {
                throw new UDFException("It's impossible");
            }
        }
        collector.putDouble(i, ans);
    }

    public void outputUncompressed(PointCollector collector, double[] a) throws Exception {
        int n = a.length / 2;
        for (int i = 0; i < n; ++i) {
            this.add(collector, a, i);
        }
    }
}

