/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.recovery;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.Utils$;
import org.apache.livy.server.recovery.StateStore;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u00015\u0011ACR5mKNK8\u000f^3n'R\fG/Z*u_J,'BA\u0002\u0005\u0003!\u0011XmY8wKJL(BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u0005Y&4\u0018P\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005)\u0019F/\u0019;f'R|'/\u001a\t\u0003'Qi\u0011AB\u0005\u0003+\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003!a\u0017N^=D_:4\u0007CA\n\u001a\u0013\tQbA\u0001\u0005MSZL8i\u001c8g\u0011!a\u0002A!A!\u0002\u0013i\u0012aD7pG.4\u0015\u000e\\3D_:$X\r\u001f;\u0011\u0007y\t3%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019y\u0005\u000f^5p]B\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0003MNT!\u0001\u000b\u0005\u0002\r!\fGm\\8q\u0013\tQSEA\u0006GS2,7i\u001c8uKb$\b\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0002/_A\u0002\"a\u0004\u0001\t\u000b]Y\u0003\u0019\u0001\r\t\u000bqY\u0003\u0019A\u000f\t\u000b1\u0002A\u0011\u0001\u001a\u0015\u00059\u001a\u0004\"B\f2\u0001\u0004A\u0002b\u0002\u0014\u0001\u0005\u0004%I!N\u000b\u0002mA\u0011AeN\u0005\u0003q\u0015\u0012!BR5mKNK8\u000f^3n\u0011\u0019Q\u0004\u0001)A\u0005m\u0005\u0019am\u001d\u0011\t\u000fq\u0002!\u0019!C\u0005{\u0005)am]+sSV\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006\u0019a.\u001a;\u000b\u0003\r\u000bAA[1wC&\u0011Q\t\u0011\u0002\u0004+JK\u0005BB$\u0001A\u0003%a(\u0001\u0004ggV\u0013\u0018\u000e\t\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0003-1\u0017\u000e\\3D_:$X\r\u001f;\u0016\u0003\rBa\u0001\u0014\u0001!\u0002\u0013\u0019\u0013\u0001\u00044jY\u0016\u001cuN\u001c;fqR\u0004\u0003\"\u0002(\u0001\t\u0003z\u0015aA:fiR\u0019\u0001k\u0015/\u0011\u0005y\t\u0016B\u0001* \u0005\u0011)f.\u001b;\t\u000bQk\u0005\u0019A+\u0002\u0007-,\u0017\u0010\u0005\u0002W3:\u0011adV\u0005\u00031~\ta\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001l\b\u0005\u0006;6\u0003\rAX\u0001\u0006m\u0006dW/\u001a\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\n\u000bA\u0001\\1oO&\u00111\r\u0019\u0002\u0007\u001f\nTWm\u0019;\t\u000b\u0015\u0004A\u0011\t4\u0002\u0007\u001d,G/\u0006\u0002hYR\u0011\u0001. \u000b\u0003SV\u00042AH\u0011k!\tYG\u000e\u0004\u0001\u0005\u000b5$'\u0019\u00018\u0003\u0003Q\u000b\"a\u001c:\u0011\u0005y\u0001\u0018BA9 \u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AH:\n\u0005Q|\"aA!os\"9a\u000fZA\u0001\u0002\b9\u0018AC3wS\u0012,gnY3%cA\u0019\u0001p\u001f6\u000e\u0003eT!A_\u0010\u0002\u000fI,g\r\\3di&\u0011A0\u001f\u0002\t\u00072\f7o\u001d+bO\")A\u000b\u001aa\u0001+\"1q\u0010\u0001C!\u0003\u0003\t1bZ3u\u0007\"LG\u000e\u001a:f]R!\u00111AA\u000e!\u0015\t)!!\u0006V\u001d\u0011\t9!!\u0005\u000f\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004\r\u0003\u0019a$o\\8u}%\t\u0001%C\u0002\u0002\u0014}\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0018\u0005e!aA*fc*\u0019\u00111C\u0010\t\u000bQs\b\u0019A+\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\u00051!/Z7pm\u0016$2\u0001UA\u0012\u0011\u0019!\u0016Q\u0004a\u0001+\"9\u0011q\u0005\u0001\u0005\n\u0005%\u0012aB1cgB\u000bG\u000f\u001b\u000b\u0005\u0003W\t\t\u0004E\u0002%\u0003[I1!a\f&\u0005\u0011\u0001\u0016\r\u001e5\t\rQ\u000b)\u00031\u0001V\u0011\u001d\t)\u0004\u0001C\u0001\u0003o\ta\"[:Gg&s7+\u00194f\u001b>$W\r\u0006\u0002\u0002:A\u0019a$a\u000f\n\u0007\u0005urDA\u0004C_>dW-\u00198\t\u000f\u0005U\u0002\u0001\"\u0001\u0002BQ!\u0011\u0011HA\"\u0011!\t)%a\u0010A\u0002\u0005\u001d\u0013a\u00013ggB!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N\u001d\nA\u0001\u001b3gg&!\u0011\u0011KA&\u0005U!\u0015n\u001d;sS\n,H/\u001a3GS2,7+_:uK6Dq!!\u0016\u0001\t\u0003\t9&\u0001\nti\u0006\u0014HoU1gK6{G-Z\"iK\u000e\\G#\u0001)")
public class FileSystemStateStore
extends StateStore
implements Logging {
    private final LivyConf livyConf;
    private final FileSystem fs;
    private final URI org$apache$livy$server$recovery$FileSystemStateStore$$fsUri;
    private final FileContext org$apache$livy$server$recovery$FileSystemStateStore$$fileContext;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FileSystemStateStore fileSystemStateStore = this;
        synchronized (fileSystemStateStore) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    private FileSystem fs() {
        return this.fs;
    }

    public URI org$apache$livy$server$recovery$FileSystemStateStore$$fsUri() {
        return this.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri;
    }

    public FileContext org$apache$livy$server$recovery$FileSystemStateStore$$fileContext() {
        return this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext;
    }

    @Override
    public void set(String key, Object value) {
        Path tmpPath = this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
        Utils$.MODULE$.usingResource((Closeable)this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().create(tmpPath, createFlag, new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1)new Serializable(this, key, value, tmpPath){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemStateStore $outer;
            private final String key$1;
            private final Object value$1;
            private final Path tmpPath$1;

            public final void apply(FSDataOutputStream tmpFile) {
                tmpFile.write(this.$outer.serializeToBytes(this.value$1));
                tmpFile.close();
                this.$outer.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().rename(this.tmpPath$1, this.$outer.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(this.key$1), new Options.Rename[]{Options.Rename.OVERWRITE});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$1 = key$1;
                this.value$1 = value$1;
                this.tmpPath$1 = tmpPath$1;
            }
        });
        try {
            Path crcPath = new Path(tmpPath.getParent(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".crc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpPath.getName()})));
            this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().delete(crcPath, false);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public <T> Option<T> get(String key, ClassTag<T> evidence$1) {
        None$ none$;
        try {
            none$ = (Option)Utils$.MODULE$.usingResource((Closeable)this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().open(this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(key)), (Function1)new Serializable(this, evidence$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemStateStore $outer;
                private final ClassTag evidence$1$1;

                public final Option<T> apply(FSDataInputStream is) {
                    return Option$.MODULE$.apply(this.$outer.deserialize(IOUtils.toByteArray((InputStream)is), this.evidence$1$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.evidence$1$1 = evidence$1$1;
                }
            });
        }
        catch (IOException iOException) {
            this.warn((Function0<Object>)new Serializable(this, key){
                public static final long serialVersionUID = 0L;
                private final String key$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to read ", " from state store."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$2}));
                }
                {
                    this.key$2 = key$2;
                }
            }, iOException);
            none$ = None$.MODULE$;
        }
        catch (FileNotFoundException fileNotFoundException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Seq<String> getChildren(String key) {
        Seq seq;
        try {
            seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().util().listStatus(this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(key))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(FileStatus x$1) {
                    return x$1.getPath().getName();
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        catch (IOException iOException) {
            this.warn((Function0<Object>)new Serializable(this, key){
                public static final long serialVersionUID = 0L;
                private final String key$3;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to list ", " from state store."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$3}));
                }
                {
                    this.key$3 = key$3;
                }
            }, iOException);
            seq = (Seq)Seq$.MODULE$.empty();
        }
        catch (FileNotFoundException fileNotFoundException) {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    @Override
    public void remove(String key) {
        try {
            this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().delete(this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(key), false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.warn((Function0<Object>)new Serializable(this, key){
                public static final long serialVersionUID = 0L;
                private final String key$4;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove non-existed file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$4}));
                }
                {
                    this.key$4 = key$4;
                }
            });
        }
    }

    public Path org$apache$livy$server$recovery$FileSystemStateStore$$absPath(String key) {
        return new Path(this.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri().getPath(), key);
    }

    public boolean isFsInSafeMode() {
        boolean bl;
        FileSystem fileSystem = this.fs();
        if (fileSystem instanceof DistributedFileSystem) {
            DistributedFileSystem distributedFileSystem = (DistributedFileSystem)fileSystem;
            bl = this.isFsInSafeMode(distributedFileSystem);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isFsInSafeMode(DistributedFileSystem dfs) {
        return dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, true);
    }

    public void startSafeModeCheck() {
        int safeModeInterval = this.livyConf.getInt(LivyConf$.MODULE$.HDFS_SAFE_MODE_INTERVAL_IN_SECONDS());
        int safeModeMaxRetryAttempts = this.livyConf.getInt(LivyConf$.MODULE$.HDFS_SAFE_MODE_MAX_RETRY_ATTEMPTS());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), safeModeMaxRetryAttempts).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemStateStore $outer;

            public final boolean apply(int retryAttempts) {
                return this.apply$mcZI$sp(retryAttempts);
            }

            public boolean apply$mcZI$sp(int retryAttempts) {
                return this.$outer.isFsInSafeMode();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).foreach((Function1)new Serializable(this, safeModeInterval){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemStateStore $outer;
            private final int safeModeInterval$1;

            public final void apply(int retryAttempts) {
                this.apply$mcVI$sp(retryAttempts);
            }

            public void apply$mcVI$sp(int retryAttempts) {
                this.$outer.info((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "HDFS is still in safe mode. Waiting...";
                    }
                });
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.safeModeInterval$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.safeModeInterval$1 = safeModeInterval$1;
            }
        });
        if (this.isFsInSafeMode()) {
            throw new IllegalStateException("Reached max retry attempts for safe mode check in hdfs file system");
        }
    }

    public FileSystemStateStore(LivyConf livyConf, Option<FileContext> mockFileContext) {
        Path stateStorePath;
        block4: {
            this.livyConf = livyConf;
            super(livyConf);
            Logging.class.$init$((Logging)this);
            this.fs = FileSystem.newInstance((Configuration)livyConf.hadoopConf());
            String fsPath = livyConf.get(LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL());
            Predef$.MODULE$.require(fsPath != null && !fsPath.isEmpty(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please config ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL().key()}));
                }
            });
            this.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri = new URI(fsPath);
            this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext = (FileContext)mockFileContext.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemStateStore $outer;

                public final FileContext apply() {
                    return FileContext.getFileContext((URI)this.$outer.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().setUMask(new FsPermission("077"));
            this.startSafeModeCheck();
            stateStorePath = this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(".");
            try {
                this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().mkdir(stateStorePath, FsPermission.getDirDefault(), true);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (!this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().getFileStatus(stateStorePath).isDirectory()) break block4;
            }
            FileStatus fileStatus = this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().getFileStatus(this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath("."));
            FsAction fsAction = fileStatus.getPermission().getUserAction();
            FsAction fsAction2 = FsAction.ALL;
            Predef$.MODULE$.require(!(fsAction != null ? !fsAction.equals(fsAction2) : fsAction2 != null), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemStateStore $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Livy doesn't have permission to access state store: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            FsAction fsAction3 = fileStatus.getPermission().getGroupAction();
            FsAction fsAction4 = FsAction.NONE;
            if (fsAction3 == null ? fsAction4 != null : !fsAction3.equals(fsAction4)) {
                this.warn((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystemStateStore $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group users have permission to access state store: ", ". This is insecure."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            FsAction fsAction5 = fileStatus.getPermission().getOtherAction();
            FsAction fsAction6 = FsAction.NONE;
            if (fsAction5 == null ? fsAction6 != null : !fsAction5.equals(fsAction6)) {
                this.warn((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystemStateStore $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Other users have permission to access state store: ", ". This is in secure."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            return;
        }
        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a directory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stateStorePath})));
    }

    public FileSystemStateStore(LivyConf livyConf) {
        this(livyConf, (Option<FileContext>)None$.MODULE$);
    }
}

