/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter;

import com.google.common.base.Strings;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmCompilationMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmInfoMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.netty4.NettyAllocatorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.baseenv.MemUsage;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.apache.bifromq.starter.ServiceBootstrapper;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.config.StandaloneConfigConsolidator;
import org.apache.bifromq.starter.metrics.netty.PooledByteBufAllocator;
import org.apache.bifromq.starter.module.APIServerModule;
import org.apache.bifromq.starter.module.ConfigModule;
import org.apache.bifromq.starter.module.CoreServiceModule;
import org.apache.bifromq.starter.module.DistServiceModule;
import org.apache.bifromq.starter.module.ExecutorsModule;
import org.apache.bifromq.starter.module.InboxServiceModule;
import org.apache.bifromq.starter.module.MQTTServiceModule;
import org.apache.bifromq.starter.module.PluginModule;
import org.apache.bifromq.starter.module.RPCClientSSLContextModule;
import org.apache.bifromq.starter.module.RPCServerBuilderModule;
import org.apache.bifromq.starter.module.RetainServiceModule;
import org.apache.bifromq.starter.module.ServiceInjectorModule;
import org.apache.bifromq.starter.module.SessionDictServiceModule;
import org.apache.bifromq.starter.module.SharedResourcesHolder;
import org.apache.bifromq.starter.utils.ClusterDomainUtil;
import org.apache.bifromq.starter.utils.ConfigFileUtil;
import org.apache.bifromq.sysprops.BifroMQSysProp;
import org.apache.bifromq.sysprops.props.ClusterDomainResolveTimeoutSeconds;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneStarter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandaloneStarter.class);
    private static final Options CLI_OPTIONS = new Options().addOption(Option.builder().option("c").longOpt("conf").desc("the conf file for Starter").hasArg(true).optionalArg(false).argName("CONF_FILE").required(true).build());
    private final List<AutoCloseable> closeables = new LinkedList<AutoCloseable>();
    private final StandaloneConfig config;
    private final IAgentHost agentHost;
    private final ServiceBootstrapper.BootstrappedServices bootstrappedServices;
    private final SharedResourcesHolder sharedResourcesHolder;

    private StandaloneStarter(StandaloneConfig config, IAgentHost agentHost, ServiceBootstrapper.BootstrappedServices bootstrappedServices, SharedResourcesHolder sharedResourcesHolder) {
        this.config = config;
        this.agentHost = agentHost;
        this.bootstrappedServices = bootstrappedServices;
        this.sharedResourcesHolder = sharedResourcesHolder;
    }

    private static void printConfigs(StandaloneConfig config) {
        log.info("Available Processors: {}", (Object)EnvProvider.INSTANCE.availableProcessors());
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        log.info("JVM arguments: \n  {}", (Object)String.join((CharSequence)"\n  ", arguments));
        log.info("Settings, which can be modified at runtime, allowing for dynamic adjustment of BifroMQ's service behavior per tenant. See https://bifromq.apache.org/docs/plugin/setting_provider/intro/");
        log.info("The initial value of each setting could be overridden by JVM arguments like: '-DMQTT5Enabled=false'");
        for (Setting setting : Setting.values()) {
            log.info("Setting: {}={}", (Object)setting.name(), setting.current(""));
        }
        log.info("BifroMQ system properties: ");
        Reflections reflections = new Reflections(BifroMQSysProp.class.getPackageName(), new Scanner[0]);
        for (Class subclass : reflections.getSubTypesOf(BifroMQSysProp.class)) {
            try {
                BifroMQSysProp prop = (BifroMQSysProp)subclass.getField("INSTANCE").get(null);
                log.info("BifroMQSysProp: {}={}", (Object)prop.propKey(), prop.get());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Failed to access INSTANCE field of subclass: " + subclass.getName(), e);
            }
        }
        log.info("Consolidated Config(YAML): \n{}", (Object)ConfigFileUtil.serialize(config));
    }

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            CommandLine cmd = parser.parse(CLI_OPTIONS, args);
            File confFile = new File(cmd.getOptionValue("c"));
            if (!confFile.exists()) {
                throw new RuntimeException("Conf file does not exist: " + cmd.getOptionValue("c"));
            }
            StandaloneConfig config = ConfigFileUtil.build(confFile, StandaloneConfig.class);
            StandaloneConfigConsolidator.consolidate(config);
            StandaloneStarter.printConfigs(config);
            if (!Strings.isNullOrEmpty((String)config.getClusterConfig().getEnv())) {
                Metrics.globalRegistry.config().commonTags(new String[]{"env", config.getClusterConfig().getEnv()});
            }
            Injector serviceInjector = Guice.createInjector((Module[])new Module[]{new ConfigModule(config), new RPCClientSSLContextModule(), new CoreServiceModule(), new RPCServerBuilderModule(), new PluginModule(), new ExecutorsModule()});
            Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(config), new DistServiceModule(), new InboxServiceModule(), new RetainServiceModule(), new SessionDictServiceModule(), new MQTTServiceModule(), new APIServerModule(), new ServiceInjectorModule(serviceInjector)});
            StandaloneStarter starter = StandaloneStarter.builder().config(config).agentHost((IAgentHost)serviceInjector.getInstance(IAgentHost.class)).bootstrappedServices(((ServiceBootstrapper)injector.getInstance(ServiceBootstrapper.class)).bootstrap()).sharedResourcesHolder((SharedResourcesHolder)serviceInjector.getInstance(SharedResourcesHolder.class)).build();
            Thread shutdownThread = new Thread(starter::stop);
            shutdownThread.setName("shutdown");
            Runtime.getRuntime().addShutdownHook(shutdownThread);
            starter.start();
        }
        catch (Throwable e) {
            log.error("Failed to start BifroMQ", e);
            formatter.printHelp("CMD", CLI_OPTIONS);
            System.exit(-1);
        }
    }

    void start() {
        this.startSystemMetrics();
        this.join();
        this.bootstrappedServices.start();
        log.info("Standalone broker started");
    }

    void stop() {
        this.bootstrappedServices.stop();
        this.sharedResourcesHolder.close();
        this.closeables.forEach(closable -> {
            try {
                closable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        log.info("Standalone broker stopped");
    }

    private void join() {
        String env = this.config.getClusterConfig().getEnv();
        String clusterDomainName = this.config.getClusterConfig().getClusterDomainName();
        String seeds = this.config.getClusterConfig().getSeedEndpoints();
        if (!Strings.isNullOrEmpty((String)clusterDomainName)) {
            log.debug("AgentHost[{}] join clusterDomainName: {}", (Object)env, (Object)clusterDomainName);
            ((CompletableFuture)ClusterDomainUtil.resolve(clusterDomainName, Duration.ofSeconds((Long)ClusterDomainResolveTimeoutSeconds.INSTANCE.get())).thenApply(seedAddrs -> Arrays.stream(seedAddrs).map(addr -> new InetSocketAddress((InetAddress)addr, this.config.getClusterConfig().getPort())).collect(Collectors.toSet()))).whenComplete((seedEndpoints, e) -> {
                if (e != null) {
                    log.warn("ClusterDomainName[{}] is unresolvable, due to {}", (Object)clusterDomainName, (Object)e.getMessage());
                } else {
                    log.info("ClusterDomainName[{}] resolved to seedEndpoints: {}", (Object)clusterDomainName, seedEndpoints);
                    this.joinSeeds((Set<InetSocketAddress>)seedEndpoints);
                }
            });
        }
        if (!Strings.isNullOrEmpty((String)seeds)) {
            log.debug("AgentHost[{}] join seedEndpoints: {}", (Object)env, (Object)seeds);
            Set<InetSocketAddress> seedEndpoints2 = Arrays.stream(seeds.split(",")).map(endpoint -> {
                String[] hostPort = endpoint.trim().split(":");
                return new InetSocketAddress(hostPort[0], Integer.parseInt(hostPort[1]));
            }).collect(Collectors.toSet());
            this.joinSeeds(seedEndpoints2);
        }
    }

    private void joinSeeds(Set<InetSocketAddress> seeds) {
        this.agentHost.join(seeds).whenComplete((v, e) -> {
            if (e != null) {
                log.warn("AgentHost failed to join seedEndpoint: {}", (Object)seeds, e);
            } else {
                log.info("AgentHost joined seedEndpoint: {}", (Object)seeds);
            }
        });
    }

    private void startSystemMetrics() {
        new UptimeMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmInfoMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new ClassLoaderMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmCompilationMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmThreadMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        JvmGcMetrics jvmGcMetrics = new JvmGcMetrics();
        jvmGcMetrics.bindTo((MeterRegistry)Metrics.globalRegistry);
        this.closeables.add((AutoCloseable)jvmGcMetrics);
        JvmHeapPressureMetrics jvmHeapPressureMetrics = new JvmHeapPressureMetrics();
        jvmHeapPressureMetrics.bindTo((MeterRegistry)Metrics.globalRegistry);
        this.closeables.add((AutoCloseable)jvmHeapPressureMetrics);
        new NettyAllocatorMetrics((ByteBufAllocatorMetricProvider)PooledByteBufAllocator.INSTANCE).bindTo((MeterRegistry)Metrics.globalRegistry);
        new NettyAllocatorMetrics((ByteBufAllocatorMetricProvider)UnpooledByteBufAllocator.DEFAULT).bindTo((MeterRegistry)Metrics.globalRegistry);
        Gauge.builder((String)"netty.direct.memory.usage", () -> MemUsage.local().nettyDirectMemoryUsage()).register((MeterRegistry)Metrics.globalRegistry);
    }

    @Generated
    public static StandaloneStarterBuilder builder() {
        return new StandaloneStarterBuilder();
    }

    static {
        RxJavaPlugins.setErrorHandler(e -> log.error("Uncaught RxJava exception", e));
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> log.error("Caught an uncaught exception in thread[{}]", (Object)t.getName(), (Object)e));
    }

    @Generated
    public static class StandaloneStarterBuilder {
        @Generated
        private StandaloneConfig config;
        @Generated
        private IAgentHost agentHost;
        @Generated
        private ServiceBootstrapper.BootstrappedServices bootstrappedServices;
        @Generated
        private SharedResourcesHolder sharedResourcesHolder;

        @Generated
        StandaloneStarterBuilder() {
        }

        @Generated
        public StandaloneStarterBuilder config(StandaloneConfig config) {
            this.config = config;
            return this;
        }

        @Generated
        public StandaloneStarterBuilder agentHost(IAgentHost agentHost) {
            this.agentHost = agentHost;
            return this;
        }

        @Generated
        public StandaloneStarterBuilder bootstrappedServices(ServiceBootstrapper.BootstrappedServices bootstrappedServices) {
            this.bootstrappedServices = bootstrappedServices;
            return this;
        }

        @Generated
        public StandaloneStarterBuilder sharedResourcesHolder(SharedResourcesHolder sharedResourcesHolder) {
            this.sharedResourcesHolder = sharedResourcesHolder;
            return this;
        }

        @Generated
        public StandaloneStarter build() {
            return new StandaloneStarter(this.config, this.agentHost, this.bootstrappedServices, this.sharedResourcesHolder);
        }

        @Generated
        public String toString() {
            return "StandaloneStarter.StandaloneStarterBuilder(config=" + String.valueOf(this.config) + ", agentHost=" + String.valueOf(this.agentHost) + ", bootstrappedServices=" + String.valueOf(this.bootstrappedServices) + ", sharedResourcesHolder=" + String.valueOf(this.sharedResourcesHolder) + ")";
        }
    }
}

