/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server;

import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.baseenv.MemUsage;
import org.apache.bifromq.baserpc.server.ResponsePipeline;
import org.apache.bifromq.inbox.record.TenantInboxInstance;
import org.apache.bifromq.inbox.rpc.proto.SendReply;
import org.apache.bifromq.inbox.rpc.proto.SendRequest;
import org.apache.bifromq.inbox.server.FetchSignalSender;
import org.apache.bifromq.plugin.subbroker.DeliveryResult;
import org.apache.bifromq.sysprops.props.IngressSlowDownDirectMemoryUsage;
import org.apache.bifromq.sysprops.props.IngressSlowDownHeapMemoryUsage;
import org.apache.bifromq.sysprops.props.MaxSlowDownTimeoutSeconds;
import org.apache.bifromq.type.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InboxWriterPipeline
extends ResponsePipeline<SendRequest, SendReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxWriterPipeline.class);
    private static final double SLOWDOWN_DIRECT_MEM_USAGE = (Double)IngressSlowDownDirectMemoryUsage.INSTANCE.get();
    private static final double SLOWDOWN_HEAP_MEM_USAGE = (Double)IngressSlowDownHeapMemoryUsage.INSTANCE.get();
    private static final Duration SLOWDOWN_TIMEOUT = Duration.ofSeconds(((Integer)MaxSlowDownTimeoutSeconds.INSTANCE.get()).intValue());
    private final IWriteCallback writeCallback;
    private final ISendRequestHandler handler;
    private final String delivererKey;
    private final ConcurrentLinkedQueue<WriteTask> tasks = new ConcurrentLinkedQueue();
    private final AtomicBoolean draining = new AtomicBoolean(false);

    public InboxWriterPipeline(IWriteCallback writeCallback, ISendRequestHandler handler, StreamObserver<SendReply> responseObserver) {
        super(responseObserver, () -> MemUsage.local().nettyDirectMemoryUsage() > SLOWDOWN_DIRECT_MEM_USAGE || MemUsage.local().heapMemoryUsage() > SLOWDOWN_HEAP_MEM_USAGE, SLOWDOWN_TIMEOUT);
        this.writeCallback = writeCallback;
        this.handler = handler;
        this.delivererKey = this.metadata("1");
    }

    protected CompletableFuture<SendReply> handleRequest(String ignore, SendRequest request) {
        log.trace("Received inbox write request: deliverer={}, \n{}", (Object)this.delivererKey, (Object)request);
        return this.submitAndTrigger(request);
    }

    private CompletableFuture<SendReply> submitAndTrigger(SendRequest request) {
        WriteTask task = new WriteTask(request);
        this.tasks.add(task);
        task.replyFuture.whenComplete((v, e) -> this.drain());
        this.bridge(this.doWrite(task.request), task.replyFuture);
        return task.onDone;
    }

    private void drain() {
        WriteTask head;
        block3: do {
            if (!this.draining.compareAndSet(false, true)) {
                return;
            }
            try {
                while (true) {
                    if ((head = this.tasks.peek()) == null) {
                        continue block3;
                    }
                    if (!head.replyFuture.isDone()) {
                        continue block3;
                    }
                    this.tasks.poll();
                    this.bridge(head.replyFuture, head.onDone);
                }
            }
            finally {
                this.draining.set(false);
            }
        } while ((head = this.tasks.peek()) != null && head.replyFuture.isDone());
    }

    private void bridge(CompletableFuture<SendReply> from, CompletableFuture<SendReply> to) {
        from.whenComplete((v, e) -> {
            if (e != null) {
                to.completeExceptionally((Throwable)e);
            } else {
                to.complete((SendReply)v);
            }
        });
    }

    private CompletableFuture<SendReply> doWrite(SendRequest request) {
        return this.handler.handle(request).thenApply(v -> {
            FetchSignalSender.INSTANCE.execute(() -> {
                long now = System.nanoTime();
                v.getReply().getResultMap().forEach((tenantId, deliveryResults) -> deliveryResults.getResultList().forEach(result -> {
                    if (result.getCode() == DeliveryResult.Code.OK) {
                        this.writeCallback.afterWrite(TenantInboxInstance.from((String)tenantId, (MatchInfo)result.getMatchInfo()), this.delivererKey, now);
                    }
                }));
            });
            return v;
        });
    }

    static interface IWriteCallback {
        public void afterWrite(TenantInboxInstance var1, String var2, long var3);
    }

    static interface ISendRequestHandler {
        public CompletableFuture<SendReply> handle(SendRequest var1);
    }

    private static class WriteTask {
        final SendRequest request;
        final CompletableFuture<SendReply> replyFuture;
        final CompletableFuture<SendReply> onDone;

        WriteTask(SendRequest request) {
            this.request = request;
            this.replyFuture = new CompletableFuture();
            this.onDone = new CompletableFuture();
        }
    }
}

