/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server;

import io.grpc.stub.StreamObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.baserpc.server.AckStream;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.basescheduler.exception.BatcherUnavailableException;
import org.apache.bifromq.inbox.rpc.proto.InboxFetchHint;
import org.apache.bifromq.inbox.rpc.proto.InboxFetched;
import org.apache.bifromq.inbox.server.IInboxFetcher;
import org.apache.bifromq.inbox.server.InboxFetcherRegistry;
import org.apache.bifromq.inbox.server.scheduler.FetchRequest;
import org.apache.bifromq.inbox.storage.proto.BatchFetchRequest;
import org.apache.bifromq.inbox.storage.proto.Fetched;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InboxFetchPipeline
extends AckStream<InboxFetchHint, InboxFetched>
implements IInboxFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxFetchPipeline.class);
    private static final int NOT_KNOWN_CAPACITY = -1;
    private final String id;
    private final String delivererKey;
    private final Map<Long, FetchState> inboxFetchSessions;
    private final Map<InboxId, Set<Long>> inboxSessionMap = new ConcurrentHashMap<InboxId, Set<Long>>();
    private final Fetcher fetcher;
    private final Disposable disposable;
    private volatile boolean closed = false;

    public InboxFetchPipeline(StreamObserver<InboxFetched> responseObserver, Fetcher fetcher, InboxFetcherRegistry registry) {
        super(responseObserver);
        this.id = this.metadata("0");
        this.delivererKey = this.metadata("1");
        this.inboxFetchSessions = new ConcurrentHashMap<Long, FetchState>();
        this.fetcher = fetcher;
        registry.reg(this);
        this.disposable = this.ack().doFinally(() -> {
            registry.unreg(this);
            this.closed = true;
        }).subscribe(fetchHint -> {
            String inboxId = fetchHint.getInboxId();
            log.trace("Got hint: tenantId={}, inboxId={}\n{}", new Object[]{this.tenantId, inboxId, fetchHint});
            if (fetchHint.getCapacity() < 0) {
                this.inboxFetchSessions.computeIfPresent(fetchHint.getSessionId(), (k, v) -> {
                    this.inboxSessionMap.computeIfPresent(new InboxId(v.inboxId, v.incarnation), (k1, set) -> {
                        set.remove(fetchHint.getSessionId());
                        return set.isEmpty() ? null : set;
                    });
                    return null;
                });
            } else {
                FetchState fetchState = this.inboxFetchSessions.compute(fetchHint.getSessionId(), (k, v) -> {
                    if (v == null) {
                        v = new FetchState(fetchHint.getInboxId(), fetchHint.getIncarnation(), fetchHint.getSessionId());
                        this.inboxSessionMap.computeIfAbsent(new InboxId(fetchHint.getInboxId(), fetchHint.getIncarnation()), k1 -> new HashSet()).add(fetchHint.getSessionId());
                    }
                    v.lastFetchQoS0Seq.set(Math.max(fetchHint.getLastFetchQoS0Seq(), v.lastFetchQoS0Seq.get()));
                    v.lastFetchSendBufferSeq.set(Math.max(fetchHint.getLastFetchSendBufferSeq(), v.lastFetchSendBufferSeq.get()));
                    v.downStreamCapacity.set(Math.max(0, fetchHint.getCapacity()));
                    return v;
                });
                log.trace("Fetch state update: tenantId={}, inbox={}\n{}", new Object[]{this.tenantId, inboxId, fetchState});
                this.fetch(fetchState);
            }
        });
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String tenantId() {
        return this.tenantId;
    }

    @Override
    public String delivererKey() {
        return this.delivererKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(InboxFetched message) {
        InboxFetchPipeline inboxFetchPipeline = this;
        synchronized (inboxFetchPipeline) {
            super.send((Object)message);
        }
    }

    @Override
    public boolean signalFetch(String inboxId, long incarnation, long now) {
        log.trace("Signal fetch: tenantId={}, inboxId={}", (Object)this.tenantId, (Object)inboxId);
        Set sessionIds = this.inboxSessionMap.getOrDefault(new InboxId(inboxId, incarnation), Collections.emptySet());
        for (Long sessionId : sessionIds) {
            FetchState fetchState = this.inboxFetchSessions.get(sessionId);
            if (fetchState == null || fetchState.signalFetchTS.get() >= now) continue;
            fetchState.hasMore.set(true);
            fetchState.signalFetchTS.set(now);
            this.fetch(fetchState);
        }
        return !sessionIds.isEmpty();
    }

    @Override
    public void close() {
        super.close();
        this.disposable.dispose();
    }

    private void fetch(long sessionId) {
        FetchState fetchState = this.inboxFetchSessions.get(sessionId);
        if (fetchState != null) {
            this.fetch(fetchState);
        }
    }

    private void fetch(FetchState fetchState) {
        if (this.closed) {
            return;
        }
        if (fetchState.hasMore.get() && fetchState.downStreamCapacity.get() > 0 && fetchState.fetching.compareAndSet(false, true)) {
            long sessionId = fetchState.sessionId;
            String inboxId = fetchState.inboxId;
            long incarnation = fetchState.incarnation;
            log.trace("Fetching inbox: tenantId={}, inboxId={}", (Object)this.tenantId, (Object)inboxId);
            FetchRequest request = new FetchRequest(this.tenantId, inboxId, incarnation, BatchFetchRequest.Params.newBuilder().setMaxFetch(fetchState.downStreamCapacity.get()).setQos0StartAfter(fetchState.lastFetchQoS0Seq.get()).setSendBufferStartAfter(fetchState.lastFetchSendBufferSeq.get()).build());
            long fetchTS = System.nanoTime();
            this.fetcher.fetch(request).whenComplete(CompletableFutureUtil.unwrap((fetched, e) -> {
                if (this.closed) {
                    return;
                }
                if (e != null) {
                    try {
                        if (e instanceof BatcherUnavailableException) {
                            this.send(InboxFetched.newBuilder().setSessionId(fetchState.sessionId).setInboxId(inboxId).setIncarnation(incarnation).setFetched(Fetched.newBuilder().setResult(Fetched.Result.TRY_LATER).build()).build());
                            return;
                        }
                        if (e instanceof BackPressureException) {
                            this.send(InboxFetched.newBuilder().setSessionId(fetchState.sessionId).setInboxId(inboxId).setIncarnation(incarnation).setFetched(Fetched.newBuilder().setResult(Fetched.Result.BACK_PRESSURE_REJECTED).build()).build());
                            return;
                        }
                        log.debug("Failed to fetch inbox: tenantId={}, inboxId={}, incarnation={}", new Object[]{this.tenantId, inboxId, incarnation, e});
                        this.send(InboxFetched.newBuilder().setSessionId(fetchState.sessionId).setInboxId(inboxId).setIncarnation(incarnation).setFetched(Fetched.newBuilder().setResult(Fetched.Result.ERROR).build()).build());
                    }
                    catch (Throwable t) {
                        log.error("Unexpected error", t);
                    }
                    finally {
                        fetchState.fetching.set(false);
                    }
                } else {
                    log.trace("Fetched inbox: tenantId={}, inboxId={}, incarnation={}\n{}", new Object[]{this.tenantId, inboxId, incarnation, fetched});
                    try {
                        this.send(InboxFetched.newBuilder().setSessionId(sessionId).setInboxId(inboxId).setIncarnation(incarnation).setFetched(fetched).build());
                        if (fetched.getQos0MsgCount() > 0 || fetched.getSendBufferMsgCount() > 0) {
                            if (fetched.getQos0MsgCount() > 0) {
                                fetchState.lastFetchQoS0Seq.set(fetched.getQos0Msg(fetched.getQos0MsgCount() - 1).getSeq());
                            }
                            int fetchedCount = 0;
                            if (fetched.getSendBufferMsgCount() > 0) {
                                fetchedCount += fetched.getSendBufferMsgCount();
                                fetchState.downStreamCapacity.accumulateAndGet(fetched.getSendBufferMsgCount(), (a, b) -> a == -1 ? a : Math.max(a - b, 0));
                                fetchState.lastFetchSendBufferSeq.set(fetched.getSendBufferMsg(fetched.getSendBufferMsgCount() - 1).getSeq());
                            }
                            fetchState.hasMore.set(fetchedCount >= request.params().getMaxFetch() || fetchState.signalFetchTS.get() > fetchTS);
                        } else {
                            fetchState.hasMore.set(fetchState.signalFetchTS.get() > fetchTS);
                        }
                        fetchState.fetching.set(false);
                        if (fetchState.downStreamCapacity.get() > 0 && fetchState.hasMore.get()) {
                            this.fetch(sessionId);
                        }
                    }
                    catch (Throwable t) {
                        log.error("Unexpected error", t);
                    }
                }
            }));
        }
    }

    static interface Fetcher {
        public CompletableFuture<Fetched> fetch(FetchRequest var1);
    }

    private record InboxId(String inboxId, long incarnation) {
    }

    private static class FetchState {
        final String inboxId;
        final long incarnation;
        final long sessionId;
        final AtomicBoolean fetching = new AtomicBoolean(false);
        final AtomicBoolean hasMore = new AtomicBoolean(true);
        final AtomicLong signalFetchTS = new AtomicLong();
        final AtomicInteger downStreamCapacity = new AtomicInteger(-1);
        final AtomicLong lastFetchQoS0Seq = new AtomicLong(-1L);
        final AtomicLong lastFetchSendBufferSeq = new AtomicLong(-1L);

        FetchState(String inboxId, long incarnation, long sessionId) {
            this.inboxId = inboxId;
            this.incarnation = incarnation;
            this.sessionId = sessionId;
        }

        @Generated
        public String toString() {
            return "InboxFetchPipeline.FetchState(inboxId=" + this.inboxId + ", incarnation=" + this.incarnation + ", sessionId=" + this.sessionId + ", fetching=" + String.valueOf(this.fetching) + ", hasMore=" + String.valueOf(this.hasMore) + ", signalFetchTS=" + String.valueOf(this.signalFetchTS) + ", downStreamCapacity=" + String.valueOf(this.downStreamCapacity) + ", lastFetchQoS0Seq=" + String.valueOf(this.lastFetchQoS0Seq) + ", lastFetchSendBufferSeq=" + String.valueOf(this.lastFetchSendBufferSeq) + ")";
        }
    }
}

