/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl;

import org.apache.hc.core5.annotation.Internal;

@Internal
public class FieldValidationSupport {
    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    public static boolean isNameCharValid(char ch) {
        return ch > ' ' && ch != ':' && ch < '\u007f';
    }

    public static boolean isNameCharLowerCaseValid(char ch) {
        return FieldValidationSupport.isNameCharValid(ch) && (ch < 'A' || ch > 'Z');
    }

    public static boolean isValueCharValid(char ch) {
        return ch != '\u0000' && ch != '\n' && ch != '\r';
    }

    public static boolean isNameValid(CharSequence s, int pos, int len) {
        for (int i = pos; i < len; ++i) {
            if (FieldValidationSupport.isNameCharValid(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameValid(CharSequence s) {
        return FieldValidationSupport.isNameValid(s, 0, s.length());
    }

    public static boolean isNameLowerCaseValid(CharSequence s, int pos, int len) {
        for (int i = pos; i < len; ++i) {
            if (FieldValidationSupport.isNameCharLowerCaseValid(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameLowerCaseValid(CharSequence s) {
        return FieldValidationSupport.isNameLowerCaseValid(s, 0, s.length());
    }

    public static boolean isValueValid(CharSequence s) {
        if (s.length() == 0) {
            return true;
        }
        if (FieldValidationSupport.isWhitespace(s.charAt(0)) || FieldValidationSupport.isWhitespace(s.charAt(s.length() - 1))) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (FieldValidationSupport.isValueCharValid(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

