/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.hive.iceberg.org.apache.avro.file.CodecFactory;
import org.apache.hive.iceberg.org.apache.avro.file.DataFileWriter;
import org.apache.hive.iceberg.org.apache.avro.io.DatumWriter;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroMetrics;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class AvroFileAppender<D>
implements FileAppender<D> {
    private final PositionOutputStream stream;
    private DataFileWriter<D> writer;
    private final DatumWriter<?> datumWriter;
    private final Schema icebergSchema;
    private final MetricsConfig metricsConfig;
    private long numRecords = 0L;
    private boolean isClosed = false;

    AvroFileAppender(Schema icebergSchema, org.apache.hive.iceberg.org.apache.avro.Schema schema, OutputFile file, Function<org.apache.hive.iceberg.org.apache.avro.Schema, DatumWriter<?>> createWriterFunc, CodecFactory codec, Map<String, String> metadata, MetricsConfig metricsConfig, boolean overwrite) throws IOException {
        this.icebergSchema = icebergSchema;
        this.stream = overwrite ? file.createOrOverwrite() : file.create();
        this.datumWriter = createWriterFunc.apply(schema);
        this.writer = AvroFileAppender.newAvroWriter(schema, this.stream, this.datumWriter, codec, metadata);
        this.metricsConfig = metricsConfig;
    }

    @Override
    public void add(D datum) {
        try {
            ++this.numRecords;
            this.writer.append(datum);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public Metrics metrics() {
        Preconditions.checkState(this.isClosed, "Cannot return metrics while appending to an open file.");
        return AvroMetrics.fromWriter(this.datumWriter, this.icebergSchema, this.numRecords, this.metricsConfig);
    }

    @Override
    public long length() {
        if (this.stream != null) {
            try {
                return this.stream.storedLength();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to get stream length", new Object[0]);
            }
        }
        throw new RuntimeIOException("Failed to get stream length: no open stream", new Object[0]);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.isClosed = true;
        }
    }

    private static <D> DataFileWriter<D> newAvroWriter(org.apache.hive.iceberg.org.apache.avro.Schema schema, PositionOutputStream stream, DatumWriter<?> metricsAwareDatumWriter, CodecFactory codec, Map<String, String> metadata) throws IOException {
        DataFileWriter writer = new DataFileWriter(metricsAwareDatumWriter);
        writer.setCodec(codec);
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            writer.setMeta(entry.getKey(), entry.getValue());
        }
        return writer.create(schema, stream);
    }
}

