/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.drop;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Drop Table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DropTableDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final boolean ifExists;
    private final boolean purge;
    private final ReplicationSpec replicationSpec;
    private final boolean validationRequired;

    public DropTableDesc(String tableName, boolean ifExists, boolean ifPurge, ReplicationSpec replicationSpec) {
        this(tableName, ifExists, ifPurge, replicationSpec, true);
    }

    public DropTableDesc(String tableName, boolean ifExists, boolean purge, ReplicationSpec replicationSpec, boolean validationRequired) {
        this.tableName = tableName;
        this.ifExists = ifExists;
        this.purge = purge;
        this.replicationSpec = replicationSpec == null ? new ReplicationSpec() : replicationSpec;
        this.validationRequired = validationRequired;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    public boolean getValidationRequired() {
        return this.validationRequired;
    }
}

