/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import org.apache.datasketches.hive.tuple.ObjectInspectorValidator;
import org.apache.datasketches.hive.tuple.SketchEvaluator;
import org.apache.datasketches.hive.tuple.UnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.Summary;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

public abstract class UnionSketchUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] inspectors = info.getParameterObjectInspectors();
        if (inspectors.length < 1) {
            throw new UDFArgumentException("Expected at least 1 argument");
        }
        ObjectInspectorValidator.validateGivenPrimitiveCategory(inspectors[0], 0, PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        if (inspectors.length > 1) {
            ObjectInspectorValidator.validateIntegralParameter(inspectors[1], 1);
        }
        this.checkExtraArguments(inspectors);
        return this.createEvaluator();
    }

    protected void checkExtraArguments(ObjectInspector[] inspectors) throws SemanticException {
        if (inspectors.length > 2) {
            throw new UDFArgumentException("Expected no more than 2 arguments");
        }
    }

    public abstract GenericUDAFEvaluator createEvaluator();

    public static abstract class UnionSketchEvaluator<S extends Summary>
    extends SketchEvaluator<S> {
        private PrimitiveObjectInspector sketchInspector_;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] inspectors) throws HiveException {
            super.init(mode, inspectors);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.sketchInspector_ = (PrimitiveObjectInspector)inspectors[0];
                if (inspectors.length > 1) {
                    this.nominalNumEntriesInspector_ = (PrimitiveObjectInspector)inspectors[1];
                }
            } else {
                this.intermediateInspector_ = (StructObjectInspector)inspectors[0];
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "sketch"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY)));
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer buf, Object[] data) throws HiveException {
            byte[] serializedSketch;
            if (data[0] == null) {
                return;
            }
            UnionState state = (UnionState)buf;
            if (!state.isInitialized()) {
                this.initializeState(state, data);
            }
            if ((serializedSketch = (byte[])this.sketchInspector_.getPrimitiveJavaObject(data[0])) == null) {
                return;
            }
            state.update(Sketches.heapifySketch((Memory)Memory.wrap((byte[])serializedSketch), this.getSummaryDeserializer()));
        }

        protected void initializeState(UnionState<S> state, Object[] data) {
            int nominalNumEntries = 4096;
            if (this.nominalNumEntriesInspector_ != null) {
                nominalNumEntries = PrimitiveObjectInspectorUtils.getInt((Object)data[1], (PrimitiveObjectInspector)this.nominalNumEntriesInspector_);
            }
            state.init(nominalNumEntries, this.getSummarySetOperationsForIterate(data));
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new UnionState();
        }
    }
}

