/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.Reader;
import java.util.HashMap;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.statistics.StatisticDescriptorImpl;
import org.apache.geode.internal.statistics.StatisticsTypeXml;
import org.apache.geode.internal.statistics.ValidatingStatisticsType;

@Immutable
public class StatisticsTypeImpl
implements ValidatingStatisticsType {
    private final String name;
    private final String description;
    private final StatisticDescriptor[] stats;
    private final HashMap<String, StatisticDescriptor> statsMap;
    private final int longStatCount;
    private final int doubleStatCount;

    public static StatisticsType[] fromXml(Reader reader, StatisticsTypeFactory factory) {
        return new StatisticsTypeXml().read(reader, factory);
    }

    public StatisticsTypeImpl(String name, String description, StatisticDescriptor[] stats) {
        if (name == null) {
            throw new NullPointerException("Cannot have a null statistics type name.");
        }
        if (stats == null) {
            throw new NullPointerException("Cannot have a null statistic descriptors.");
        }
        if (stats.length > 254) {
            throw new IllegalArgumentException(String.format("The requested descriptor count %s exceeds the maximum which is  %s .", stats.length, 254));
        }
        this.name = name;
        this.description = description;
        this.stats = stats;
        this.statsMap = new HashMap(stats.length * 2);
        this.longStatCount = this.addTypedDescriptorToMap((byte)6, 0);
        this.doubleStatCount = this.addTypedDescriptorToMap((byte)8, this.longStatCount);
    }

    private int addTypedDescriptorToMap(byte typeCode, int startOfSequentialIds) {
        int count = 0;
        for (StatisticDescriptor stat : this.stats) {
            StatisticDescriptorImpl sd = (StatisticDescriptorImpl)stat;
            if (sd.getTypeCode() != typeCode) continue;
            sd.setId(startOfSequentialIds + count);
            ++count;
            this.addDescriptorToMap(sd);
        }
        return count;
    }

    private void addDescriptorToMap(StatisticDescriptor sd) {
        StatisticDescriptor previousValue = this.statsMap.put(sd.getName(), sd);
        if (previousValue != null) {
            throw new IllegalArgumentException(String.format("Duplicate StatisticDescriptor named %s", sd.getName()));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public StatisticDescriptor[] getStatistics() {
        return this.stats;
    }

    @Override
    public int nameToId(String name) {
        return this.nameToDescriptor(name).getId();
    }

    @Override
    public StatisticDescriptor nameToDescriptor(String name) {
        StatisticDescriptor stat = this.statsMap.get(name);
        if (stat == null) {
            throw new IllegalArgumentException(String.format("There is no statistic named %s", name));
        }
        return stat;
    }

    public int getLongStatCount() {
        return this.longStatCount;
    }

    public int getDoubleStatCount() {
        return this.doubleStatCount;
    }

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "{name=" + this.name + ", description=" + this.description + ", stats.length=" + this.stats.length + "}";
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        StatisticDescriptor[] yourStats;
        if (o == null) {
            return false;
        }
        if (!(o instanceof StatisticsType)) {
            return false;
        }
        StatisticsType other = (StatisticsType)o;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        StatisticDescriptor[] myStats = this.getStatistics();
        if (myStats.length != (yourStats = other.getStatistics()).length) {
            return false;
        }
        for (int i = 0; i < myStats.length; ++i) {
            if (myStats[i].equals(yourStats[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidLongId(int id) {
        return id < this.longStatCount;
    }

    @Override
    public boolean isValidDoubleId(int id) {
        return this.longStatCount <= id && id < this.longStatCount + this.doubleStatCount;
    }
}

